/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.ticketmanager.TicketActionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketLinking;
import com.inet.helpdesk.core.ticketmanager.TicketMaintenance;
import com.inet.helpdesk.core.ticketmanager.TicketManagerComponents;
import com.inet.helpdesk.core.ticketmanager.TicketManagerFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.TicketPermissionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.generated.GeneratedAttributeChangeEventSender;
import com.inet.plugin.ServerPluginManager;

public class TicketManager {
    private static TicketManagerComponents INSTANCE;

    public static TicketManagerVetoPower getVetoPower() {
        return TicketManager.getInstance().getVetoPower();
    }

    public static TicketManipulator getManipulator() {
        return TicketManager.getInstance().getManipulator();
    }

    public static TicketReader getReader() {
        return TicketManager.getInstance().getReader();
    }

    public static TicketReaderForSystem getReaderForSystem() {
        return TicketManager.getInstance().getReaderForSystem();
    }

    public static TicketActionChecker getTicketActionChecker() {
        return TicketManager.getInstance().getActionChecker();
    }

    public static TicketPermissionChecker getTicketPermissionChecker() {
        return TicketManager.getInstance().getTicketPermissionChecker();
    }

    public static TicketMaintenance getMaintenance() {
        return TicketManager.getInstance().getMaintenance();
    }

    public static ExtendingTicketManager extending() {
        return new ExtendingTicketManager();
    }

    public static TicketLinking getTicketLinking() {
        return TicketManager.getInstance().getTicketLinking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TicketManagerComponents getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TicketManager> clazz = TicketManager.class;
        synchronized (TicketManager.class) {
            if (INSTANCE != null) return INSTANCE;
            try {
                ServerPluginManager spm = ServerPluginManager.getInstance();
                TicketManagerFactory factory = (TicketManagerFactory)spm.getSingleInstance(TicketManagerFactory.class);
                INSTANCE = factory.create();
            }
            catch (Throwable ex) {
                ErrorCode.throwAny((Throwable)ex);
            }
            return INSTANCE;
        }
    }

    private TicketManager() {
    }

    public static class ExtendingTicketManager {
        public TicketField<Object> getField(String fieldKey) {
            return Tickets.getFieldByKey(fieldKey);
        }

        public TicketSubOperations getTicketInnerOperations() {
            return TicketManager.getInstance().getTicketInnerOperations();
        }

        public GeneratedAttributeChangeEventSender getGeneratedAttributeEventSender() {
            return TicketManager.getInstance().getGeneratedAttributeEventSender();
        }
    }
}

