/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketfieldsettings.config;

import com.inet.config.ConfigurationManager;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.fieldsettings.structure.GenericFieldConfigStructureProvider;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketfieldsettings.config.TicketFieldSettingsProperty;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class TicketFieldSettingsStructureProvider
extends GenericFieldConfigStructureProvider {
    public static final String CATEGORY_TICKET_FIELDS = "category.fields.tickets";
    public static final String PROP_GROUP_FIELD_TICKETS_TITLE_LABEL = "propGroup.field.tickets.title";
    public static final String PROP_GROUP_FIELD_TICKETS = "propGroup.field.tickets";
    public static final String PROPERTY_KEY_TICKETFIELDS = "property.fields.ticket";
    public static final String ICON_CUSTOM_FIELD = "custom-ticket";
    public static final String ICON_SYSTEM_FIELD = "system-ticket";

    public TicketFieldSettingsStructureProvider() {
        super(() -> TicketFieldSettingsManager.getInstance(), PROPERTY_KEY_TICKETFIELDS);
    }

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "ticketsettings": {
                categories.add(new ConfigCategory(131, CATEGORY_TICKET_FIELDS, this.translate(settings, CATEGORY_TICKET_FIELDS, new Object[0]), "field.settings.ticket"));
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        try {
            switch (categoryKey) {
                case "category.fields.tickets": {
                    return TicketFieldSettingsStructureProvider.class.getResource("/com/inet/helpdesk/core/ticketfieldsettings/config/ticket_field_config_48.png");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.fields.tickets": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_FIELD_TICKETS_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_FIELD_TICKETS));
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "propGroup.field.tickets": {
                configProperties.add((ConfigProperty)new TicketFieldSettingsProperty(PROPERTY_KEY_TICKETFIELDS, settings, TicketFieldSettingsManager.getInstance()));
                break;
            }
            case "propGroup.field.tickets.title": {
                this.addTo(configProperties, "field.tickets.title_label", "Label", settings);
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, ConfigStructureSettings settings) {
        if (PROPERTY_KEY_TICKETFIELDS.equals(key)) {
            List changedValueList = (List)settings.getChangedValue(key, List.class);
            changedValueList.stream().filter(m -> "identifier".equals(m.get("fieldsettingsKey"))).findFirst().ifPresent(m -> {
                String defaultIdentifier = (String)m.remove(HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION.getKey());
                if (defaultIdentifier == null) {
                    defaultIdentifier = "";
                }
                ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION.getKey(), defaultIdentifier);
            });
        }
        return super.save(key, value, settings);
    }
}

