/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;
import com.inet.mail.api.SecurityUtils;
import java.sql.DriverManager;
import java.util.TimeZone;

@JsonData
public class DatabaseConfigInfo {
    public static final String MS_SQL_DEFAULT_PORT = "1433";
    public static final String MY_SQL_DEFAULT_PORT = "3306";
    public static final String ORACLE_DEFAULT_PORT = "1521";
    public static final String INET_TDS = "com.inet.tds.TdsDriver";
    public static final String INET_ORA = "com.inet.ora.OraDriver";
    public static final String MYSQL_DRV = "com.mysql.cj.jdbc.Driver";
    public static final String MARIADB_DRV = "org.mariadb.jdbc.Driver";
    private Status status = Status.Unknown;
    private String dbName = "";
    private String url = null;
    private String user = "";
    private String encodedPassword = "";
    private String host = "";
    private String port = "";
    private String sid = "";
    private String catalog = "";
    private DatabaseType driver = DatabaseType.unknown;

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getUrl() {
        DatabaseType driver = this.getDriver();
        if (DatabaseType.other.equals((Object)driver) || !StringFunctions.isEmpty((String)this.url)) {
            return this.url;
        }
        String urlStr = "jdbc:" + String.valueOf((Object)driver) + ":";
        Object hostStr = this.getHost().trim();
        if (DatabaseType.odbc.equals((Object)driver)) {
            urlStr = "jdbc:odbc:" + this.getCatalog();
        } else {
            if (((String)hostStr).length() == 0) {
                return "";
            }
            if (DatabaseType.inetdae7.equals((Object)driver)) {
                boolean notNumericPort = false;
                try {
                    Integer.parseInt(this.getPort());
                }
                catch (Exception ex) {
                    notNumericPort = true;
                }
                if (!notNumericPort) {
                    hostStr = (String)hostStr + ":" + this.getPort();
                }
                hostStr = (String)hostStr + "?database=" + this.getCatalog();
                if (notNumericPort) {
                    hostStr = (String)hostStr + "&instance=" + this.getPort();
                }
            } else if (DatabaseType.inetora.equals((Object)driver)) {
                hostStr = (String)hostStr + ":" + this.getPort();
                if (this.getSid().length() > 0) {
                    hostStr = (String)hostStr + ":" + this.getSid();
                }
            } else if (DatabaseType.mysql.equals((Object)driver)) {
                hostStr = "//" + (String)hostStr + ":" + this.getPort() + "/" + this.getCatalog() + "?serverTimezone=" + TimeZone.getDefault().getID();
                if (DriverManager.getLogWriter() != null) {
                    hostStr = (String)hostStr + "&profileSQL=true";
                }
            } else if (DatabaseType.mariadb.equals((Object)driver)) {
                hostStr = "//" + (String)hostStr + ":" + this.getPort() + "/" + this.getCatalog() + "?serverTimezone=" + TimeZone.getDefault().getID();
                if (DriverManager.getLogWriter() != null) {
                    hostStr = (String)hostStr + "&profileSQL=true";
                }
            }
            urlStr = urlStr + (String)hostStr;
        }
        return urlStr;
    }

    public String getCustomUrl() {
        return this.url != null && this.url.isEmpty() ? null : this.url;
    }

    public String getUrlWithoutDB() {
        if (DatabaseType.other.equals((Object)this.getDriver()) || !StringFunctions.isEmpty((String)this.url)) {
            return this.getUrl();
        }
        switch (this.getDriver()) {
            case mysql: 
            case mariadb: {
                String cat = "/" + this.getCatalog();
                String url = this.getUrl();
                int index = url.indexOf(cat + "?server");
                if (index == -1) {
                    return this.getUrl();
                }
                return url.substring(0, index) + url.substring(index + cat.length());
            }
            case inetdae7: {
                String urlStr = "jdbc:" + String.valueOf((Object)this.getDriver()) + ":";
                Object hostStr = this.getHost().trim();
                if (((String)hostStr).isEmpty()) {
                    return "";
                }
                try {
                    Integer.parseInt(this.getPort());
                    hostStr = (String)hostStr + ":" + this.getPort();
                }
                catch (Exception ex) {
                    hostStr = (String)hostStr + "?instance=" + this.getPort();
                }
                return urlStr + (String)hostStr;
            }
        }
        return this.getUrl();
    }

    public String getDriverClassName() {
        if (this.driver == null) {
            return INET_TDS;
        }
        switch (this.driver) {
            case inetdae7: {
                return INET_TDS;
            }
            case inetora: {
                return INET_ORA;
            }
            case mysql: {
                return MYSQL_DRV;
            }
            case mariadb: {
                return MARIADB_DRV;
            }
        }
        return INET_TDS;
    }

    public void setCustomUrl(String url) {
        if (url != null && url.isEmpty()) {
            url = null;
        }
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setEncodedPassword(String encodedPassword) {
        this.encodedPassword = encodedPassword;
    }

    public String getDecodedPassword() {
        return SecurityUtils.decodePassword((String)this.encodedPassword);
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    public String getHost() {
        this.parseHostAndInstanceIfNeeded();
        return this.host;
    }

    private void parseHostAndInstanceIfNeeded() {
        if (this.host != null && (this.host.contains("/") || this.host.contains("\\"))) {
            String[] parts = this.host.split("[/\\\\]", 2);
            this.host = parts[0];
            this.port = parts.length > 1 ? parts[1] : this.getDefaultPort();
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        this.parseHostAndInstanceIfNeeded();
        if (this.port == null || this.port.length() == 0) {
            return this.getDefaultPort();
        }
        return this.port;
    }

    private String getDefaultPort() {
        switch (this.driver) {
            case inetdae7: {
                return MS_SQL_DEFAULT_PORT;
            }
            case inetora: {
                return ORACLE_DEFAULT_PORT;
            }
            case mysql: 
            case mariadb: {
                return MY_SQL_DEFAULT_PORT;
            }
        }
        return "";
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getCatalogForConnection() {
        if (this.getCustomUrl() == null) {
            return this.getCatalog();
        }
        return null;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public int getBackendType() {
        if (this.driver == null) {
            return 2;
        }
        switch (this.driver) {
            case inetdae7: {
                return 2;
            }
            case inetora: {
                return 3;
            }
            case mysql: {
                return 4;
            }
        }
        return 2;
    }

    public DatabaseType getDriver() {
        return this.driver;
    }

    public void setDriver(DatabaseType driver) {
        this.driver = driver;
    }

    public void setDecodedPassword(char[] password) {
        this.encodedPassword = SecurityUtils.encodePassword((char[])password);
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseConfigInfo that = (DatabaseConfigInfo)o;
        if (this.catalog != null ? !this.catalog.equals(that.catalog) : that.catalog != null) {
            return false;
        }
        if (this.dbName != null ? !this.dbName.equals(that.dbName) : that.dbName != null) {
            return false;
        }
        if (this.driver != null ? !this.driver.equals((Object)that.driver) : that.driver != null) {
            return false;
        }
        if (this.encodedPassword != null ? !this.encodedPassword.equals(that.encodedPassword) : that.encodedPassword != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.sid != null ? !this.sid.equals(that.sid) : that.sid != null) {
            return false;
        }
        String thisurl = this.getUrl();
        String thaturl = that.getUrl();
        if (thisurl != null ? !thisurl.equals(thaturl) : thaturl != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.dbName != null ? this.dbName.hashCode() : 0;
        result = 31 * result + (this.getUrl() != null ? this.getUrl().hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.encodedPassword != null ? this.encodedPassword.hashCode() : 0);
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.sid != null ? this.sid.hashCode() : 0);
        result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
        result = 31 * result + (this.driver != null ? this.driver.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DatabaseConfigInfo [status=" + String.valueOf((Object)this.status) + ", dbName=" + this.dbName + ", url=" + this.url + ", user=" + this.user + ", encodedPassword=" + this.encodedPassword + ", host=" + this.host + ", port=" + this.port + ", sid=" + this.sid + ", catalog=" + this.catalog + ", driver=" + String.valueOf((Object)this.driver) + "]";
    }

    @JsonData
    public static enum Status {
        Valid,
        Invalid,
        Locked,
        Unknown;

    }

    @JsonData
    public static enum DatabaseType {
        inetdae7,
        mysql,
        inetora,
        odbc,
        other,
        unknown,
        mariadb;

    }
}

