/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.attachmentdisplay;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.attachmentdisplay.AttachmentDisplayRequest;
import com.inet.helpdesk.attachmentdisplay.AttachmentDisplayResponse;
import com.inet.helpdesk.core.attachmentdisplay.AttachmentDisplayProvider;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.util.EncodingFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class AttachmentDisplay
extends ServiceMethod<AttachmentDisplayRequest, AttachmentDisplayResponse> {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.attachmentdisplay.i18n.LanguageResources", AttachmentDisplay.class);

    public String getMethodName() {
        return "helpdesk.attachmentdisplay";
    }

    public AttachmentDisplayResponse invoke(HttpServletRequest req, HttpServletResponse resp, AttachmentDisplayRequest input) throws IOException {
        String type = null;
        String src = null;
        boolean jsonSerialized = false;
        try {
            String attachmentPath = input.getAttachmentPath();
            int indexOf = attachmentPath.indexOf(63);
            if (indexOf >= 0) {
                attachmentPath = attachmentPath.substring(0, indexOf);
            }
            try {
                attachmentPath = EncodingFunctions.decodeUrlPath((String)attachmentPath);
                AttachmentKey key = AttachmentFilePathBuilder.convertRestfulPathToKey((String)attachmentPath);
                AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
                AttachmentRow attachment = attService.getAttachment(key);
                if (attachment != null) {
                    type = "unknown";
                    String mimeType = MimeTypes.getMimeType((String)attachment.getFileName());
                    List providers = ServerPluginManager.getInstance().get(AttachmentDisplayProvider.class);
                    Optional<AttachmentDisplayProvider> findProvider = providers.stream().filter(p -> p.isResponsible(mimeType, attachment)).findFirst();
                    if (findProvider.isPresent()) {
                        AttachmentDisplayProvider displayProvider = findProvider.get();
                        type = displayProvider.getType();
                        src = displayProvider.getSourceOrContent(mimeType, attachment);
                        jsonSerialized = displayProvider.isJsonSerializedSource();
                    }
                }
            }
            catch (IllegalArgumentException wrongAgain) {
                LogManager.getApplicationLogger().warn((Object)("Cannot recognize attachment link: " + attachmentPath));
            }
        }
        catch (Throwable t) {
            LogManager.getApplicationLogger().error(t);
        }
        return new AttachmentDisplayResponse(input.getAttachmentPath(), type, jsonSerialized, src);
    }

    public short getMethodType() {
        return 1;
    }
}

