/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCreateIndexCommand;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.model.NodeIndex;
import java.sql.SQLException;

public class MSSQLCreatePrimaryIndexCommand
extends DefaultCreateIndexCommand {
    private DatabaseInfos dbInfos;

    public MSSQLCreatePrimaryIndexCommand(DatabaseInfos dbInfos) {
        super(dbInfos, null);
        this.dbInfos = dbInfos;
    }

    @Override
    public int execute() throws SQLException {
        return super.execute();
    }

    @Override
    public void printCreatePrefix(Node element, StringBuilder b) {
        String name = element.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name());
        if (name != null) {
            b.append("CONSTRAINT ");
            b.append(this.dbInfos.checkIndexName(this.dbInfos.getQuote(name)));
            b.append(" ");
        }
        b.append("PRIMARY KEY ");
        AttributeMap<String> attributes = element.getAttributeMap();
        if (attributes.containsKey((Object)IDatabaseInfos.INDEX_PARAM.type)) {
            String type = attributes.get((Object)IDatabaseInfos.INDEX_PARAM.type);
            try {
                NodeIndex.TYPE typeEnum = NodeIndex.TYPE.valueOf(NodeIndex.TYPE.class, type);
                switch (typeEnum) {
                    case tableIndexClustered: {
                        b.append("CLUSTERED ");
                        break;
                    }
                    case tableIndexOther: {
                        b.append("NONCLUSTERED ");
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void printName(Node element, StringBuilder b) {
    }

    @Override
    public void printTableTarget(Node element, StringBuilder b) {
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return element.getName() == NodeFactory.TAG.index && "PRIMARY".equalsIgnoreCase(element.getAttributeMap().get((Object)IDatabaseInfos.INDEX_PARAM.index_name));
    }
}

