/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.List;

public class DefaultAddColumnCommand
implements ITableCommand {
    private DatabaseInfos dbInfo;
    private final Node name;
    private String column;
    private DefaultCommandSyntax syntax;
    private final String prefix;

    public DefaultAddColumnCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableNode) {
        this.name = tableNode;
        this.dbInfo = dbInfo;
        this.syntax = syntax;
        this.prefix = "ALTER TABLE " + ((ISchemaNode)((Object)this.name)).getSourceName(dbInfo);
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public String getSqlStatement() {
        return this.prefix + this.column;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return action == ICommandFactory.COMMAND_TYPE.create && element != null && element.getName() == NodeFactory.TAG.column && this.column == null;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.addstructure;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        String nullableValue;
        AttributeMap<String> attributes = element.getAttributeMap();
        if (!attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.column_name)) {
            throw new SQLException("Cannot create an empty column in table '" + String.valueOf(this.name) + "'");
        }
        if (!attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.data_type)) {
            throw new SQLException("Cannot create a table colum in table '" + String.valueOf(this.name) + "' without a data type");
        }
        StringBuilder b = new StringBuilder();
        b.append(" ADD COLUMN ");
        b.append(this.dbInfo.getQuoteIdentiferIfNeeded(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_name).toString())).append(" ");
        boolean identity = attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.isautoincrement) && "true".equals(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.isautoincrement));
        b.append(this.syntax.getTypeString(element)).append(" ");
        if (attributes.containsKey((Object)IDatabaseInfos.COLUMN_PARAM.isnotnullable) && "true".equals(nullableValue = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.isnotnullable).toString())) {
            b.append("NOT NULL ");
        }
        String defaultValue = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_def);
        if (!identity && defaultValue != null && defaultValue.trim().length() > 0) {
            int type = Integer.parseInt(attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.data_type));
            String string = this.dbInfo.getQuotedValue(defaultValue.toString(), type);
            b.append("DEFAULT ").append(string).append(" ");
        }
        this.column = b.toString();
        return null;
    }
}

