/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.shared.model.Actions;
import com.inet.helpdesk.ticketmanager.TicketManipulatorInternal;
import com.inet.helpdesk.ticketmanager.model.OperationChangedTicketImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class BundleTicketActionExtensionFactory
implements TicketActionExtensionFactory {
    @Override
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        ExtensionArguments.BundleTicketActionExtensionData extData = arguments.get(ExtensionArguments.EXTARG_BUNDLE_TICKETS);
        if (extData instanceof ExtensionArguments.BundleTicketActionExtensionData) {
            return new BundleTicketActionExtension(extData);
        }
        return null;
    }

    private String shortenReaStepDescIfNeeded(String desc) {
        if (desc.length() > 255) {
            String dots = "...";
            return desc.substring(0, 255 - dots.length()) + dots;
        }
        return desc;
    }

    private class BundleTicketActionExtension
    implements TicketActionExtension {
        private final List<Integer> slaveTicketIDs;
        private final Map<Integer, List<Integer>> slaveToBundledTicketsMap;

        public BundleTicketActionExtension(ExtensionArguments.BundleTicketActionExtensionData extData) {
            this.slaveTicketIDs = extData.getSlaveTicketIDs();
            this.slaveToBundledTicketsMap = extData.getSlaveToBundledTicketsMap();
        }

        @Override
        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            long lastModified = System.currentTimeMillis();
            MutableReaStepData fields = reaStep.getFields();
            ProcessingTime processingTime = fields.get(ReaStepVO.FIELD_PROCESSING_TIME);
            if (processingTime == null) {
                processingTime = ProcessingTime.of(lastModified);
            } else {
                lastModified = processingTime.getEnd();
            }
            fields.put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
            ArrayList<Integer> listOfIDs = new ArrayList<Integer>();
            for (int slaveID : this.slaveTicketIDs) {
                listOfIDs.add(slaveID);
                listOfIDs.addAll(this.slaveToBundledTicketsMap.getOrDefault(slaveID, Collections.emptyList()));
            }
            String commaSeparatedSlaveTicketIDs = listOfIDs.stream().map(val -> val.toString()).collect(Collectors.joining(", "));
            String desc = Tickets.MSG.getMsg(Tickets.serverLocale(), "action.bundle.master", new Object[]{commaSeparatedSlaveTicketIDs});
            desc = BundleTicketActionExtensionFactory.this.shortenReaStepDescIfNeeded(desc);
            reaStep.getFields().put(ReaStepVO.FIELD_DESC, desc);
            this.bundleTickets(ticket, lastModified, processingTime);
        }

        private void bundleTickets(OperationChangedTicket masterTicket, long lastModified, ProcessingTime processingTime) {
            TicketVO masterTicketVO = masterTicket.getOldTicket().get();
            Integer bundleId = masterTicketVO.getID();
            AtomicLong sumTimeOfMaster = new AtomicLong();
            for (int slaveId : this.slaveTicketIDs) {
                OperationChangedTicket slaveTicket = this.makeTicketSlaveInBundle(masterTicket, lastModified, bundleId, sumTimeOfMaster, slaveId);
                Iterator iterator = this.slaveToBundledTicketsMap.getOrDefault(slaveId, Collections.emptyList()).iterator();
                while (iterator.hasNext()) {
                    int formerSlave = (Integer)iterator.next();
                    this.makeTicketSlaveInBundle(slaveTicket, lastModified, bundleId, sumTimeOfMaster, formerSlave);
                }
                this.addReaStepForSlaveTicket(masterTicketVO.getID(), slaveId, slaveTicket, processingTime);
                this.addReaStepsForTicketsBundledToSlaveTicket(masterTicketVO.getID(), slaveId, processingTime, masterTicket.getParentModel());
            }
            Integer previousBunOfMaster = masterTicketVO.getAttribute(Tickets.ATTRIBUTE_BUNDLE_ID);
            if (previousBunOfMaster == null) {
                masterTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_BUNDLE_ID, bundleId);
            }
            TicketManager.extending().getTicketInnerOperations().getReaStepsForTicket(masterTicketVO.getID(), BundleStepsFilter.WITH_BUNDLE_STEPS).forEach(ticketStep -> {
                if (ticketStep.getStartDate() > 0L && ticketStep.getEndDate() > 0L) {
                    sumTimeOfMaster.addAndGet((ticketStep.getEndDate() - ticketStep.getStartDate()) / 60000L);
                }
            });
            masterTicket.getAfterWriteOperations().add(() -> {
                TicketManipulatorInternal.TicketInnerOperationsImpl ticketInnerOperationsImpl = (TicketManipulatorInternal.TicketInnerOperationsImpl)TicketManager.extending().getTicketInnerOperations();
                ticketInnerOperationsImpl.clearCachedBundleTickets(masterTicket.getTicketId());
                ticketInnerOperationsImpl.updateAttachmentFlagForTicket(masterTicket.getTicketId());
            });
            masterTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_SUM_TIME, sumTimeOfMaster.intValue());
        }

        private OperationChangedTicket makeTicketSlaveInBundle(OperationChangedTicket masterTicket, long lastModified, Integer bundleId, AtomicLong sumTimeOfMaster, int slaveId) {
            OperationChangedTicket slaveTicket = masterTicket.getParentModel().changeExistingTicket(slaveId);
            slaveTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_EDITOR_GUID, TicketManipulatorInternal.getCurrentUserAccountOrThrowISE().getID());
            slaveTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_CHANGED, lastModified);
            slaveTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_BUNDLE_ID, bundleId);
            List<ReaStepVO> reaStepsForTicket = TicketManager.getReader().getReaStepsForTicket(slaveId, BundleStepsFilter.WITH_BUNDLE_STEPS);
            for (ReaStepVO slaveReaStep : reaStepsForTicket) {
                if (!Actions.isMoveReaStepWithActionFromBundleSlaveToMaster(slaveReaStep.getActionID())) continue;
                ((OperationChangedTicketImpl)slaveTicket).changeReaStep(slaveReaStep.getID(), bundleId);
                if (slaveReaStep.getStartDate() > 0L && slaveReaStep.getEndDate() > 0L) {
                    sumTimeOfMaster.addAndGet((slaveReaStep.getEndDate() - slaveReaStep.getStartDate()) / 60000L);
                }
                masterTicket.changeReaStep(slaveReaStep.getID());
            }
            masterTicket.getAfterWriteOperations().add(() -> ((TicketManipulatorInternal.TicketInnerOperationsImpl)TicketManager.extending().getTicketInnerOperations()).clearCachedBundleTickets(slaveId));
            if (slaveTicket.getOldTicket().get().isMasterInBundle()) {
                slaveTicket.getAfterWriteOperations().add(() -> ((TicketManipulatorInternal.TicketInnerOperationsImpl)TicketManager.extending().getTicketInnerOperations()).updateAttachmentFlagForTicket(slaveTicket.getTicketId()));
            }
            return slaveTicket;
        }

        private void addReaStepForSlaveTicket(int masterTicketID, int slaveTicketID, OperationChangedTicket ticket, ProcessingTime processingTime) {
            String stepDescription;
            List bundledTickets = this.slaveToBundledTicketsMap.getOrDefault(slaveTicketID, Collections.emptyList());
            if (bundledTickets.isEmpty()) {
                stepDescription = Tickets.MSG.getMsg(Tickets.serverLocale(), "action.bundle.slave", new Object[]{masterTicketID});
            } else {
                String commaSeparatedIDs = bundledTickets.stream().map(val -> val.toString()).collect(Collectors.joining(", "));
                stepDescription = Tickets.MSG.getMsg(Tickets.serverLocale(), "action.bundle.slaveisbundle", new Object[]{masterTicketID, commaSeparatedIDs});
                stepDescription = BundleTicketActionExtensionFactory.this.shortenReaStepDescIfNeeded(stepDescription);
            }
            MutableReaStepData slaveTicketStepData = new MutableReaStepData();
            slaveTicketStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
            slaveTicketStepData.put(ReaStepVO.FIELD_DESC, stepDescription);
            ticket.addReaStep(-1, slaveTicketStepData, MutableReaStepText.empty());
        }

        private void addReaStepsForTicketsBundledToSlaveTicket(int masterTicketID, int slaveTicketID, ProcessingTime processingTime, TicketOperationModel model) {
            List bundledTickets = this.slaveToBundledTicketsMap.getOrDefault(slaveTicketID, Collections.emptyList());
            Iterator iterator = bundledTickets.iterator();
            while (iterator.hasNext()) {
                int ticketID = (Integer)iterator.next();
                String stepDescription = Tickets.MSG.getMsg(Tickets.serverLocale(), "action.bundle.slaveisbundle", new Object[]{masterTicketID, slaveTicketID});
                MutableReaStepData bundledTicketStepData = new MutableReaStepData();
                bundledTicketStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
                bundledTicketStepData.put(ReaStepVO.FIELD_DESC, stepDescription);
                OperationChangedTicket ticket = model.changeExistingTicket(ticketID);
                ticket.addReaStep(-1, bundledTicketStepData, MutableReaStepText.empty());
            }
        }
    }
}

