/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.extension.ExtensionUtils;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.mail.reader.EmailReader_HDProcessing;
import com.inet.helpdesk.mail.reader.ProcessingMailData;
import com.inet.helpdesk.mail.reader.RawReadMailData;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import srv.automatic.trigger.Trigger;
import srv.automatic.trigger.TriggerHandler;
import srv.controller.ticket.timeline.ResourceTimelineManager;

public class TriggerAndParameterHandler {
    private static final ConfigValue<String> PARAM_START_TAG = new ConfigValue(HDConfigKeys.PARAM_START_TAG);
    private static final ConfigValue<String> PARAM_END_TAG = new ConfigValue(HDConfigKeys.PARAM_END_TAG);
    private static final String PARAM_SUPPRESS_ACTIONS = "suppressaction";
    private Map<String, String> headerbackup;

    public boolean trigger_MAIL_NEW_IN_Exists() {
        return TriggerHandler.getTrigger(0) != null;
    }

    public void _run_MAIL_IN_TRIGGER_if_exists(ProcessingMailData mailData, TicketVO ticketVo) {
        Trigger trigger = TriggerHandler.getTrigger(1);
        if (trigger == null) {
            return;
        }
        Map<String, String> customParameterMap = mailData.getCustomParameterMap();
        this.writeReadOnlyInfosIntoMap(customParameterMap, mailData.getResourceId());
        this.writeTicketValuesIntoMap(customParameterMap, mailData, ticketVo);
        this.writeUserDataIntoMap(customParameterMap, mailData.getSenderUserAccount(), mailData);
        Exception exception = trigger.checkData(customParameterMap, true);
        if (exception != null) {
            EmailReader_HDProcessing.LOGGER.error((Object)"Error in Mail-trigger MAIL_IN_TRIGGER");
            EmailReader_HDProcessing.LOGGER.error((Throwable)exception);
        }
        this.removeReadOnlyValuesFromMap(customParameterMap);
        this.readTicketValuesFromMap(customParameterMap, mailData, ticketVo);
        this.readUserDataFromMap(customParameterMap, mailData.getSenderUserAccount(), mailData);
        this.readSuppressFromMap(customParameterMap, mailData);
    }

    private void readSuppressFromMap(Map<String, String> customParameterMap, ProcessingMailData mailData) {
        String suppress = customParameterMap.remove(PARAM_SUPPRESS_ACTIONS);
        if (suppress != null) {
            if (suppress.equalsIgnoreCase("errormails")) {
                mailData.getResponseType().suppressErrorMails();
            } else if (suppress.equalsIgnoreCase("all")) {
                mailData.getResponseType().suppressTicketActions();
                mailData.getResponseType().suppressAllMails();
            } else if (suppress.equalsIgnoreCase("actions")) {
                mailData.getResponseType().suppressTicketActions();
            } else if (suppress.equalsIgnoreCase("automails")) {
                mailData.getResponseType().suppressAllAutoMails();
            }
        }
    }

    private void removeReadOnlyValuesFromMap(Map<String, String> customParameterMap) {
        customParameterMap.remove("resanwesend");
        customParameterMap.remove("current_status");
        customParameterMap.remove("LetzterBearbeiterGUID");
        customParameterMap.remove("isdispatched");
        customParameterMap.remove("letzterbearbeiter");
        customParameterMap.remove("emaileingang");
        customParameterMap.remove("username");
        customParameterMap.remove("locale");
    }

    private void writeReadOnlyInfosIntoMap(Map<String, String> data, GUID resourceId) {
        boolean accessible = false;
        try {
            if (resourceId != null) {
                int resourceIdInt = HDUsersAndGroups.getResourceId(resourceId);
                accessible = ResourceTimelineManager.getInstance().isResourceAccessibleNow(resourceIdInt);
            }
        }
        catch (Exception ex) {
            EmailReader_HDProcessing.LOGGER.error((Throwable)ex);
        }
        data.put("resanwesend", String.valueOf(accessible));
    }

    public void writeTicketValuesIntoMap(Map<String, String> data, ProcessingMailData model, @Nullable TicketVO ticketVo) {
        ItilVO itilVo;
        Integer itil;
        Integer katId;
        Integer prio;
        GUID resource;
        Integer clasId;
        data.put("emaileingang", model.getReadInAccount().getAccount());
        if (ticketVo != null) {
            UserAccount aa;
            data.put("current_status", String.valueOf(ticketVo.getStatusID()));
            GUID userId = ticketVo.getLastEditorID();
            if (userId != null) {
                data.put("LetzterBearbeiterGUID", userId.toString());
            }
            data.put("isdispatched", String.valueOf(ticketVo.isDispatched()));
            GUID lastEditorID = ticketVo.getLastEditorID();
            if (lastEditorID != null && (aa = UserManager.getInstance().getUserAccount(lastEditorID)) != null) {
                data.put("letzterbearbeiter", aa.getDisplayName());
            }
            data.put("aufid", String.valueOf(ticketVo.getID()));
        }
        if ((clasId = (Integer)this.fromModelOrTicket(model, ticketVo, Tickets.FIELD_CLASSIFICATION_ID.getKey())) != null) {
            ClassificationVO vo = (ClassificationVO)ClassificationManager.getInstance().get(clasId);
            data.put("klassifizierung", vo != null ? vo.getDisplayValue() : "");
        }
        if ((resource = (GUID)this.fromModelOrTicket(model, ticketVo, Tickets.FIELD_RESOURCE_GUID.getKey())) != null) {
            String str = ExtensionUtils.getResourceDisplayName(resource);
            data.put("resbezeichnung", str != null ? str : "");
        }
        if ((prio = (Integer)this.fromModelOrTicket(model, ticketVo, Tickets.FIELD_PRIORITY_ID.getKey())) != null) {
            data.put("priid", prio.toString());
        }
        if ((katId = (Integer)this.fromModelOrTicket(model, ticketVo, Tickets.FIELD_CATEGORY_ID.getKey())) != null) {
            try {
                String str = CategoryManager.getInstance().findCategoryPathOrThrow(katId);
                data.put("betreff", str);
            }
            catch (ServerDataException exc) {
                EmailReader_HDProcessing.LOGGER.debug((Object)("EMAILREADER -> unknown category " + katId));
            }
        }
        if ((itil = (Integer)this.fromModelOrTicket(model, ticketVo, Tickets.FIELD_ITIL_ID.getKey())) != null && (itilVo = (ItilVO)ItilManager.getInstance().get(itil)) != null) {
            data.put("itilbezeichnung", itilVo.getDisplayValue());
        }
        this.putIfNotNull(data, "auftragfrei1", (String)this.fromModelOrTicket(model, ticketVo, "custom1"));
        this.putIfNotNull(data, "auftragfrei1", (String)this.fromModelOrTicket(model, ticketVo, "custom1"));
        this.putIfNotNull(data, "auftragfrei2", (String)this.fromModelOrTicket(model, ticketVo, "custom2"));
        this.putIfNotNull(data, "auftragfrei3", (String)this.fromModelOrTicket(model, ticketVo, "custom3"));
        this.putIfNotNull(data, "auftragfrei4", (String)this.fromModelOrTicket(model, ticketVo, "custom4"));
        this.putIfNotNull(data, "auftragfrei5", (String)this.fromModelOrTicket(model, ticketVo, "custom5"));
        this.putIfNotNull(data, "auftragfrei6", (String)this.fromModelOrTicket(model, ticketVo, "custom6"));
        this.putIfNotNull(data, "auftragfrei7", (String)this.fromModelOrTicket(model, ticketVo, "custom7"));
        this.putIfNotNull(data, "kennung", (String)this.fromModelOrTicket(model, ticketVo, Tickets.FIELD_IDENTIFIER.getKey()));
        Integer status = model.getTicketStatusChangedByTrigger() != null ? model.getTicketStatusChangedByTrigger() : (ticketVo != null ? ticketVo.getStatusID() : 0);
        StatusVO statusVO = (StatusVO)StatusManager.getInstance().get(status);
        if (statusVO != null) {
            data.put("status", status.toString());
        } else {
            EmailReader_HDProcessing.LOGGER.error((Object)("Invalid status configured in parameter or trigger: " + status));
        }
        data.put("newuser", String.valueOf(model.isNewUserCanBeCreated()));
        data.put("auftrag", model.getContentText().getText());
        data.put("subject", model.getSubject());
        data.put("derbetreff", model.getSubject());
        data.put("sender", model.getSenderMail());
        data.put("e-mail empfaenger", model.getRecipient());
    }

    private void putIfNotNull(Map<String, String> data, String key, String value) {
        if (value != null) {
            data.put(key, value);
        }
    }

    private <T> T fromModelOrTicket(ProcessingMailData model, @Nullable TicketVO ticketVo, String field) {
        T clasId = null;
        if (model.getChangedTicketFields().containsKey(field)) {
            clasId = (T)model.getChangedTicketFields().get(field);
        } else if (ticketVo != null) {
            clasId = ticketVo.getFieldOrAttributeValue(Tickets.getFieldByKey(field));
        }
        return clasId;
    }

    private void readTicketValuesFromMap(Map<String, String> customParameterMap, ProcessingMailData model, @Nullable TicketVO ticketVo) {
        String aufid;
        Timestamp date;
        String str;
        block58: {
            if (customParameterMap.containsKey("klassifizierung")) {
                String klassification = customParameterMap.remove("klassifizierung");
                ClassificationVO vo = (ClassificationVO)ClassificationManager.getInstance().getByDisplayName(klassification, false);
                if (vo != null) {
                    int clasId = vo.getId();
                    if (ticketVo == null || ticketVo.getClassificationID() != clasId) {
                        model.getChangedTicketFields().put(Tickets.FIELD_CLASSIFICATION_ID, Integer.valueOf(clasId));
                    } else {
                        model.getChangedTicketFields().remove(Tickets.FIELD_CLASSIFICATION_ID);
                    }
                } else {
                    EmailReader_HDProcessing.LOGGER.error((Object)String.format("Classification %s from trigger does not exist.", klassification));
                }
            } else {
                model.getChangedTicketFields().remove(Tickets.FIELD_CLASSIFICATION_ID);
            }
            str = customParameterMap.remove("resbezeichnungstart");
            if (str != null) {
                String resourcePrefix = str.toLowerCase();
                Optional<UserGroupInfo> ress = UserGroupManager.getInstance().getGroups(HDUsersAndGroups.RESOURCE).stream().filter(r -> r.getDisplayName().toLowerCase().startsWith(resourcePrefix)).findFirst();
                if (ress.isPresent()) {
                    model.getChangedTicketFields().put(Tickets.FIELD_RESOURCE_GUID, ress.get().getID());
                }
            } else {
                str = customParameterMap.remove("resbezeichnung");
                if (str == null || str.length() == 0) {
                    model.getChangedTicketFields().remove(Tickets.FIELD_RESOURCE_GUID);
                } else {
                    UserGroupInfo matchedResource = null;
                    int splitPos = str.indexOf(92);
                    if (splitPos > 0) {
                        Set resources = UserGroupManager.getInstance().getGroups(HDUsersAndGroups.RESOURCE);
                        String mainResource = str.substring(0, splitPos);
                        matchedResource = resources.stream().filter(ugi -> mainResource.equalsIgnoreCase(ugi.getName()) && ugi.isActive() && ugi.getParentID() == null).findFirst().orElse(null);
                        if (matchedResource != null) {
                            String subResName = str.substring(splitPos + 1);
                            GUID mainId = matchedResource.getID();
                            matchedResource = resources.stream().filter(ugi -> subResName.equalsIgnoreCase(ugi.getName()) && ugi.isActive() && ugi.getParentID() == mainId).findFirst().orElse(null);
                        }
                    } else {
                        matchedResource = HDUsersAndGroups.getFirstActiveResourceMatchedByName(str);
                    }
                    if (matchedResource != null) {
                        if (ticketVo == null || !Objects.equals(ticketVo.getResourceID(), matchedResource.getID())) {
                            model.getChangedTicketFields().put(Tickets.FIELD_RESOURCE_GUID, matchedResource.getID());
                        } else {
                            model.getChangedTicketFields().remove(Tickets.FIELD_RESOURCE_GUID);
                        }
                    }
                }
            }
            String prioName = customParameterMap.remove("pribezeichnung");
            if (prioName != null) {
                PriorityVO vo = (PriorityVO)PriorityManager.getInstance().getByDisplayName(prioName, true);
                if (vo == null) {
                    EmailReader_HDProcessing.LOGGER.error((Object)String.format("Prio %s from trigger does not exist.", prioName));
                } else if (ticketVo == null || ticketVo.getPriorityID() != vo.getId()) {
                    model.getChangedTicketFields().put(Tickets.FIELD_PRIORITY_ID, Integer.valueOf(vo.getId()));
                } else {
                    model.getChangedTicketFields().remove(Tickets.FIELD_PRIORITY_ID);
                }
            } else {
                String priid = customParameterMap.remove("priid");
                if (priid != null) {
                    try {
                        int prioId = Integer.parseInt(priid);
                        PriorityVO vo = (PriorityVO)PriorityManager.getInstance().get(prioId);
                        if (vo == null || vo.isDeleted()) {
                            EmailReader_HDProcessing.LOGGER.error((Object)String.format("Prio %s from trigger does not exist.", priid));
                            break block58;
                        }
                        if (ticketVo == null || ticketVo.getPriorityID() != prioId) {
                            model.getChangedTicketFields().put(Tickets.FIELD_PRIORITY_ID, Integer.valueOf(prioId));
                            break block58;
                        }
                        model.getChangedTicketFields().remove(Tickets.FIELD_PRIORITY_ID);
                    }
                    catch (Throwable e) {
                        EmailReader_HDProcessing.LOGGER.error(e);
                    }
                } else {
                    model.getChangedTicketFields().remove(Tickets.FIELD_PRIORITY_ID);
                }
            }
        }
        String categoryPath = customParameterMap.remove("betreff");
        Integer betID = null;
        if (categoryPath != null) {
            try {
                betID = CategoryManager.getInstance().findOrCreateCategory(categoryPath);
            }
            catch (SQLException e) {
                EmailReader_HDProcessing.LOGGER.error((Throwable)e);
            }
        }
        if (!(ticketVo != null && Objects.equals(ticketVo.getCategoryID(), betID) || betID == null)) {
            model.getChangedTicketFields().put(Tickets.FIELD_CATEGORY_ID, betID);
        } else {
            model.getChangedTicketFields().remove(Tickets.FIELD_CATEGORY_ID);
        }
        Integer itilId = null;
        String itil = customParameterMap.remove("itilbezeichnung");
        if (itil != null) {
            ItilVO vo = (ItilVO)ItilManager.getInstance().getByDisplayName(itil, true);
            if (vo != null) {
                itilId = vo.getId();
            } else {
                EmailReader_HDProcessing.LOGGER.error((Object)String.format("ITIL %s from trigger does not exist.", itil));
            }
        }
        if (!(ticketVo != null && Objects.equals(ticketVo.getItilID(), itilId) || itilId == null)) {
            model.getChangedTicketFields().put(Tickets.FIELD_ITIL_ID, itilId);
        } else {
            model.getChangedTicketFields().remove(Tickets.FIELD_ITIL_ID);
        }
        this.readStringValueFromMap(model, "auftragfrei1", "custom1", customParameterMap, ticketVo);
        this.readStringValueFromMap(model, "auftragfrei2", "custom2", customParameterMap, ticketVo);
        this.readStringValueFromMap(model, "auftragfrei3", "custom3", customParameterMap, ticketVo);
        this.readStringValueFromMap(model, "auftragfrei4", "custom4", customParameterMap, ticketVo);
        this.readStringValueFromMap(model, "auftragfrei5", "custom5", customParameterMap, ticketVo);
        this.readStringValueFromMap(model, "auftragfrei6", "custom6", customParameterMap, ticketVo);
        this.readStringValueFromMap(model, "auftragfrei7", "custom7", customParameterMap, ticketVo);
        this.readStringValueFromMap(model, "kennung", Tickets.FIELD_IDENTIFIER.getKey(), customParameterMap, ticketVo);
        str = customParameterMap.remove("statusbezeichnung");
        Integer status = null;
        if (str != null) {
            StatusVO vo = (StatusVO)StatusManager.getInstance().getByDisplayName(str, true);
            if (vo != null && vo.getId() > -1) {
                status = vo.getId();
            }
        } else {
            str = customParameterMap.remove("status");
            if (str != null) {
                try {
                    status = Integer.parseInt(str);
                    if (StatusManager.getInstance().get(status) == null) {
                        status = null;
                    }
                }
                catch (Throwable e) {
                    EmailReader_HDProcessing.LOGGER.error(e);
                }
            }
        }
        Integer oldStatus = model.getTicketStatusChangedByTrigger() != null ? model.getTicketStatusChangedByTrigger() : (ticketVo != null ? ticketVo.getStatusID() : 0);
        if (!Objects.equals(oldStatus, status)) {
            model.setTicketStatusChangedByTrigger(status);
        } else {
            model.setTicketStatusChangedByTrigger(null);
        }
        model.setNewUserCanBeCreated(Boolean.valueOf(customParameterMap.remove("newuser")));
        str = customParameterMap.remove("deadlinezeit");
        if (str != null && (date = TriggerAndParameterHandler.getDateFromString(str)) != null) {
            model.getChangedTicketFields().put(Tickets.FIELD_DEADLINE, Long.valueOf(date.getTime()));
        }
        if (customParameterMap.get("wvzeit") != null && (date = TriggerAndParameterHandler.getDateFromString(customParameterMap.remove("wvzeit"))) != null) {
            model.setWiedervorlageDateByTrigger(date.getTime());
        }
        model.getContentText().setText(customParameterMap.remove("auftrag"));
        model.setSubject(customParameterMap.remove("subject"));
        String newSender = customParameterMap.remove("sender");
        if (!Objects.equals(model.getSenderMail(), newSender)) {
            try {
                InternetAddress address = new InternetAddress(newSender);
                model.setSenderMail(address.getAddress());
                String alias = address.getPersonal();
                if (alias != null) {
                    model.setSenderName(alias);
                } else {
                    model.setSenderName(address.getAddress());
                }
            }
            catch (AddressException e) {
                EmailReader_HDProcessing.LOGGER.warn((Object)e);
            }
        }
        if ((aufid = customParameterMap.remove("aufid")) != null && ticketVo == null) {
            try {
                int ticketId = Integer.valueOf(aufid);
                model.setTicketId(ticketId);
            }
            catch (NumberFormatException nfe) {
                EmailReader_HDProcessing.LOGGER.debug((Object)("EmailReader: invalid aufid from trigger:" + aufid));
            }
        }
    }

    private void readStringValueFromMap(ProcessingMailData model, String keyInMap, String field, Map<String, String> customParameterMap, TicketVO ticketVo) {
        boolean hasKey = customParameterMap.containsKey(keyInMap);
        String value = customParameterMap.remove(keyInMap);
        if ((ticketVo == null || !Objects.equals(ticketVo.getFieldOrAttributeValue(Tickets.getFieldByKey(field)), value)) && hasKey) {
            model.getChangedTicketFields().put(field, value);
        } else {
            model.getChangedTicketFields().remove(Tickets.getFieldByKey(field));
        }
    }

    public boolean _runMail_NEW_IN_TRIGGER(ProcessingMailData mailData, RawReadMailData rawData) {
        Trigger trigger = TriggerHandler.getTrigger(0);
        if (trigger != null) {
            mailData.backup();
            this.headerbackup = new HashMap<String, String>(rawData.getHeaderValues());
            Map<String, String> customParameterMap = mailData.getCustomParameterMap();
            this.writeReadOnlyInfosIntoMap(customParameterMap, mailData.getResourceId());
            this.writeTicketValuesIntoMap(customParameterMap, mailData, null);
            this.writeHeaderValuesIntoMap(customParameterMap, rawData.getHeaderValues());
            this.writeUserDataIntoMap(customParameterMap, mailData.getSenderUserAccount(), mailData);
            Exception error = trigger.checkData(customParameterMap, true);
            if (error != null) {
                EmailReader_HDProcessing.LOGGER.error((Object)"Error in Mail-trigger MAIL_NEW_IN_TRIGGER");
                EmailReader_HDProcessing.LOGGER.error((Throwable)error);
            }
            this.removeReadOnlyValuesFromMap(customParameterMap);
            this.readTicketValuesFromMap(customParameterMap, mailData, null);
            this.readHeaderValuesFromMap(customParameterMap, rawData.getHeaderValues());
            this.readUserDataFromMap(customParameterMap, mailData.getSenderUserAccount(), mailData);
            this.readSuppressFromMap(customParameterMap, mailData);
            mailData.getChangedUserFields().remove((UserField)UsersAndGroups.FIELD_EMAIL);
            return true;
        }
        return false;
    }

    private void writeHeaderValuesIntoMap(Map<String, String> customParameterMap, Map<String, String> headerValues) {
        List<String> knownHeaders = Arrays.asList("foreign key", "X-Mailer", "local key");
        for (String key : headerValues.keySet()) {
            String val = headerValues.get(key);
            if (knownHeaders.contains(key)) {
                customParameterMap.put(key, val);
                continue;
            }
            customParameterMap.put("#" + key, val);
        }
    }

    private void readHeaderValuesFromMap(Map<String, String> customParameterMap, Map<String, String> headerValues) {
        String[] knownHeaders;
        for (String headerKey : knownHeaders = new String[]{"foreign key", "X-Mailer", "local key"}) {
            String foreignKey = customParameterMap.remove(headerKey);
            if (foreignKey != null) {
                headerValues.put(headerKey, foreignKey);
                continue;
            }
            headerValues.remove(headerKey);
        }
    }

    public void revertChangesDoneByMAIL_NEW_IN_Trigger(ProcessingMailData mailData, Map<String, String> headerMap) {
        Integer ticketId = mailData.getTicketId();
        mailData.restoreFromBackup();
        mailData.setTicketId(ticketId);
        headerMap.clear();
        headerMap.putAll(this.headerbackup);
    }

    private Map<String, UserField<String>> getParamToFieldMap() {
        HashMap<String, UserField<String>> map = new HashMap<String, UserField<String>>();
        map.put("nachname", (UserField<String>)UsersAndGroups.FIELD_LASTNAME);
        map.put("vorname", (UserField<String>)UsersAndGroups.FIELD_FIRSTNAME);
        map.put("telefon", (UserField<String>)UsersAndGroups.FIELD_TELEPHONE);
        map.put("notiz", (UserField<String>)UsersAndGroups.FIELD_NOTE);
        map.put("useremail", (UserField<String>)UsersAndGroups.FIELD_EMAIL);
        map.put("zimmer", HDUsersAndGroups.FIELD_ROOM);
        map.put("computername", HDUsersAndGroups.FIELD_COMPUTER_NAME);
        map.put("abteilung", UsersAndGroups.getFieldByKey((String)"department"));
        map.put("kostenstelle", HDUsersAndGroups.FIELD_COST_CENTRE);
        map.put("benutzerfrei1", UsersAndGroups.getFieldByKey((String)"custom1"));
        map.put("benutzerfrei2", UsersAndGroups.getFieldByKey((String)"custom2"));
        map.put("benutzerfrei3", UsersAndGroups.getFieldByKey((String)"custom3"));
        map.put("benutzerfrei4", UsersAndGroups.getFieldByKey((String)"custom4"));
        map.put("benutzerfrei5", UsersAndGroups.getFieldByKey((String)"custom5"));
        map.put("benutzerfrei6", UsersAndGroups.getFieldByKey((String)"custom6"));
        return map;
    }

    private void readUserDataFromMap(Map<String, String> customParameterMap, @Nullable UserAccount userAccount, ProcessingMailData model) {
        Map<String, UserField<String>> paramToFieldMap = this.getParamToFieldMap();
        BiConsumer<String, UserField> updateModel = (paramName, field) -> {
            model.getChangedUserFields().remove(field);
            String val = (String)customParameterMap.remove(paramName);
            if (!(val == null || val.isEmpty() || userAccount != null && Objects.equals(val, userAccount.getValue(field)))) {
                model.getChangedUserFields().put(field, (Object)val);
            }
        };
        paramToFieldMap.entrySet().forEach(e -> updateModel.accept((String)e.getKey(), (UserField)e.getValue()));
        String bgr = customParameterMap.remove("benutzerklasse");
        if (StringFunctions.isEmpty((String)bgr)) {
            bgr = customParameterMap.remove("benutzergruppe");
        }
        if (bgr != null) {
            UserClassVO test = (UserClassVO)UserClassManager.getInstance().getByDisplayName(bgr, true);
            if (test != null) {
                model.getChangedUserFields().put((UserField)HDUsersAndGroups.FIELD_CLASS_ID, (Object)test.getId());
            } else {
                model.getChangedUserFields().remove((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
            }
        } else {
            model.getChangedUserFields().remove((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
        }
        String locationName = customParameterMap.remove("gebbezeichnung");
        if (locationName != null && !locationName.isEmpty()) {
            int locationId;
            LocationVO locVo = (LocationVO)LocationManager.getInstance().getByDisplayName(locationName, true);
            if (locVo == null) {
                try {
                    locationId = LocationManager.getInstance().add(new LocationVO(-1, locationName, null, null, null, 0, false));
                }
                catch (SQLException e1) {
                    throw new RuntimeException(e1);
                }
            } else {
                locationId = locVo.getId();
            }
            if (userAccount == null || !Objects.equals(locationId, userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID))) {
                model.getChangedUserFields().put((UserField)HDUsersAndGroups.FIELD_LOCATION_ID, (Object)locationId);
            } else {
                model.getChangedUserFields().remove((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
            }
        } else {
            model.getChangedUserFields().remove((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
        }
    }

    private void writeUserDataIntoMap(Map<String, String> customParameterMap, @Nullable UserAccount userAccount, ProcessingMailData model) {
        Map<String, UserField<String>> paramToFieldMap = this.getParamToFieldMap();
        BiConsumer<String, UserField> updateModel = (paramName, field) -> {
            if (userAccount != null || model.getChangedUserFields().containsField(field)) {
                String changedVal = (String)model.getChangedUserFields().get(field);
                if (changedVal == null && userAccount != null) {
                    changedVal = (String)userAccount.getValue(field);
                }
                customParameterMap.put((String)paramName, changedVal == null ? "" : changedVal);
            }
        };
        paramToFieldMap.entrySet().forEach(e -> updateModel.accept((String)e.getKey(), (UserField)e.getValue()));
        if (userAccount != null) {
            UserClassVO userGroupVO;
            LocationVO locationVO;
            customParameterMap.put("username", userAccount.getDisplayName());
            String test = (String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE);
            if ("xx".equals(test)) {
                test = EmailReader_HDProcessing.EMAIL_MESSAGES.getMsg("LOKALE", new Object[0]);
            }
            if (test == null) {
                test = "";
            }
            customParameterMap.put("locale", test);
            Integer gebID = (Integer)model.getChangedUserFields().get((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
            if (gebID == null) {
                gebID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
            }
            customParameterMap.put("gebbezeichnung", (locationVO = (LocationVO)LocationManager.getInstance().get(gebID)) != null ? locationVO.getDisplayValue() : "");
            Integer groupID = (Integer)model.getChangedUserFields().get((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
            if (groupID == null) {
                groupID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
            }
            customParameterMap.put("benutzergruppe", (userGroupVO = (UserClassVO)UserClassManager.getInstance().get(groupID)) != null ? userGroupVO.getDisplayValue() : "");
            customParameterMap.put("benutzerklasse", userGroupVO != null ? userGroupVO.getDisplayValue() : "");
        }
    }

    public void lookForParametersInAuftragsText(ProcessingMailData mailData) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.writeTicketValuesIntoMap(parameters, mailData, null);
        String paramStartTag = (String)PARAM_START_TAG.get();
        String paramEndTag = (String)PARAM_END_TAG.get();
        String content = mailData.getContentText().getText();
        int begin = 0;
        char[] replaceBuf = null;
        while (true) {
            int pos3;
            int i;
            int pos1 = content.indexOf(paramStartTag, begin);
            int pos2 = content.indexOf(paramEndTag, begin);
            if (pos2 <= pos1 || pos1 <= -1) break;
            if (replaceBuf == null) {
                replaceBuf = content.toCharArray();
            }
            for (i = pos1; i < pos1 + paramStartTag.length(); ++i) {
                replaceBuf[i] = 32;
            }
            for (i = pos1 + paramStartTag.length(); i < pos2; ++i) {
                if (replaceBuf[i] >= ' ') continue;
                replaceBuf[i] = 32;
            }
            for (i = pos2; i < pos2 + paramEndTag.length(); ++i) {
                replaceBuf[i] = 32;
            }
            String testStr = new String(replaceBuf, pos1 + paramStartTag.length(), pos2 - (pos1 + paramStartTag.length()));
            if (mailData.getContentText().hasHtmlContent()) {
                testStr = HtmlConverter.html2text((String)testStr);
            }
            if ((pos3 = testStr.indexOf(61)) > -1) {
                parameters.put(testStr.substring(0, pos3).toLowerCase().trim(), testStr.substring(pos3 + 1).trim());
            }
            begin = pos2 + paramEndTag.length();
        }
        if (replaceBuf != null) {
            parameters.put("auftrag", new String(replaceBuf));
            this.readTicketValuesFromMap(parameters, mailData, null);
            this.readSuppressFromMap(parameters, mailData);
        }
    }

    private static Timestamp getDateFromString(String str) {
        Object dt = null;
        try {
            dt = DateFormat.getDateTimeInstance(3, 3, Locale.GERMAN).parseObject(str);
        }
        catch (Throwable er) {
            try {
                dt = DateFormat.getDateTimeInstance(3, 3, Locale.US).parseObject(str);
            }
            catch (Throwable er1) {
                try {
                    dt = DateFormat.getDateTimeInstance(3, 3, Locale.UK).parseObject(str);
                }
                catch (Throwable er2) {
                    try {
                        dt = DateFormat.getDateTimeInstance().parse(str);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            if (dt == null) {
                dt = new Date(str);
            }
        }
        catch (Throwable er) {
            HDLogger.error(er);
        }
        if (dt instanceof Date) {
            Date date = (Date)dt;
            long day = 86400000L;
            if (date.getTime() > System.currentTimeMillis() && date.getTime() < System.currentTimeMillis() + day * 60L) {
                return new Timestamp(date.getTime());
            }
        }
        return null;
    }
}

