/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.annotations.InternalApi;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholderProvider;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionForTicketOwner;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextEventLog;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextMember;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlWriter;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.text.Element;

@InternalApi
public class AutoTextManager
extends GenericFieldsManager<AutoTextVO> {
    public static final int TYP_VISIBLE_PROCESSING = 2;
    public static final int TYP_VISIBLE_EMAIL_ANSWER = 4;
    public static final int TYP_VISIBLE_NEW_TICKET = 8;
    public static final int TYP_SIGNATURE = 16;
    public static final String TEXTBAUSTEIN_START_TAG = "{";
    public static final String TEXTBAUSTEIN_END_TAG = "}";
    public static final String PLACEHOLDER_TICKET_GUID = "ticket.guid";
    public static final String PLACEHOLDER_CUSTOM_TICKETID_STRING = "ticketIdString";
    public static final String PLACEHOLDER_CUSTOM_TICKETID_INTEGER = "ticketIdInteger";
    public static final String PLACEHOLDER_CUSTOM_REASTEPDATA = "reastep";
    public static final String PLACEHOLDER_CUSTOM_CURRENTUSER_DISPLAYNAME = "currentuser.displayname";
    public static final String PLACEHOLDER_CUSTOM_OWNER_DISPLAYNAME = "ticketowner.displayname";
    public static final String PLACEHOLDER_CUSTOM_USER_EMAIL = "email";
    public static final String PLACEHOLDER_PREFIX_OWNER = "ticketowner.";
    public static final String PLACEHOLDER_PREFIX_CURRENTUSER = "currentuser.";
    public static final String PLACEHOLDER_PREFIX_DATETIME = "datetime.";
    public static final String PLACEHOLDER_DATETIME_TIME = "time";
    public static final String PLACEHOLDER_DATETIME_DATE = "date";
    public static final String PLACEHOLDER_DATETIME_TIMESHORT = "timeshort";
    public static final String PLACEHOLDER_DATETIME_DATESHORT = "dateshort";
    private static final Comparator<AutoTextVO> COMPARE_IGNORE_CASE = (o1, o2) -> {
        int compareToIgnoreCase;
        String g1 = o1.getGroupLabel();
        String g2 = o2.getGroupLabel();
        if (g1 == null) {
            g1 = "";
        }
        if (g2 == null) {
            g2 = "";
        }
        if (g1.length() == 0) {
            if (g2.length() > 0) {
                return 1;
            }
        } else if (g2.length() == 0) {
            return -1;
        }
        if ((compareToIgnoreCase = g1.compareToIgnoreCase(g2)) == 0) {
            compareToIgnoreCase = o1.getLabel().compareToIgnoreCase(o2.getLabel());
        }
        return compareToIgnoreCase;
    };

    public AutoTextManager() {
        super(AutoTextVO.class, "tblAutoTexts");
    }

    @Override
    public int add(AutoTextVO vo) throws SQLException {
        this.validate(vo);
        AutoTextEventLog.AutoTextAdded.log(vo);
        return super.add(vo);
    }

    @Override
    public void update(AutoTextVO vo) throws SQLException {
        this.update(vo, true);
    }

    public void update(AutoTextVO vo, boolean logChange) throws SQLException {
        this.validate(vo);
        AutoTextVO oldVo = (AutoTextVO)this.get(vo.getId());
        if (oldVo.equals(vo)) {
            return;
        }
        String oldLabel = oldVo.getLabel();
        super.update(vo);
        if (logChange) {
            if (!vo.getLabel().equals(oldLabel)) {
                AutoTextEventLog.AutoTextChanged.log(vo, oldLabel);
            } else {
                AutoTextEventLog.AutoTextChanged.log(vo);
            }
        }
    }

    @Override
    public AutoTextVO remove(int id) throws SQLException {
        AutoTextVO removed = (AutoTextVO)super.remove(id);
        if (removed != null) {
            AutoTextEventLog.AutoTextDeleted.log(removed);
        }
        return removed;
    }

    private void validate(AutoTextVO vo) {
        if (vo.getShortcut() != null && vo.getShortcut().length() > 10) {
            throw new ClientMessageException(Tickets.MSG.getMsg("autotext.error.shortcutTooLong", new Object[]{10}));
        }
        if (vo.getLabel() != null && vo.getLabel().length() > 200) {
            throw new ClientMessageException(Tickets.MSG.getMsg("autotext.error.labelTooLong", new Object[]{200}));
        }
    }

    public List<AutoTextVO> getAllAutoTexts() {
        return this.getAutoTexts(null, null, null, false);
    }

    public List<AutoTextVO> getAutoTexts(@Nullable Integer ticketId, @Nullable Integer stepId, @Nullable Integer actionId) {
        return this.getAutoTexts(ticketId, stepId, actionId, true);
    }

    public List<AutoTextVO> getAutoTexts(@Nullable Integer ticketId, @Nullable Integer stepId, @Nullable Integer actionId, boolean filterAutoTextsBasedOnTicketContext) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        int userID = HDUsersAndGroups.getUserID(currentUserAccount);
        UserGroupManager ugm = UserGroupManager.getInstance();
        Set groupsForUser = currentUserAccount != null ? ugm.getGroupsForUser(currentUserAccount.getID()) : new HashSet();
        HashSet allGroups = new HashSet();
        groupsForUser.stream().forEach(g -> allGroups.addAll(this.getGroupsAndParentGroups((UserGroupInfo)g, ugm, allGroups)));
        List<AutoTextVO> all = this.getAvailableAutoTextsForUser(currentUserAccount != null ? currentUserAccount.getID() : null);
        all.removeIf(vo -> {
            if (!(vo.getUserId() != null && userID == vo.getUserId() || this.canAccessDueToAllowedMembers(currentUserAccount, allGroups, (AutoTextVO)vo))) {
                return true;
            }
            if (filterAutoTextsBasedOnTicketContext) {
                boolean actionSendEmail;
                boolean emailVisible;
                int flags = vo.getTyp();
                boolean newTicketVisible = (flags & 8) > 0;
                boolean processingVisible = (flags & 2) > 0;
                boolean bl = emailVisible = (flags & 4) == 4;
                if (ticketId == null) {
                    return !newTicketVisible;
                }
                boolean bl2 = actionSendEmail = actionId != null && actionId == -7;
                if (actionSendEmail) {
                    return !emailVisible;
                }
                return !processingVisible;
            }
            return false;
        });
        all = all.stream().map(vo -> {
            String langText = vo.getContentText();
            String contentWithPlaceholdersFilled = this.fillPlaceholders(langText, ticketId, stepId);
            AutoTextVO entry = AutoTextVO.of(vo.getId(), vo.getUserId(), vo.getLabel(), vo.getTyp(), contentWithPlaceholdersFilled, vo.getShortcut(), vo.getGroupLabel(), vo.getMemberships());
            return entry;
        }).sorted(COMPARE_IGNORE_CASE).collect(Collectors.toList());
        return all;
    }

    @Nullable
    public AutoTextVO getAutoUserSignature() {
        GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
        List<AutoTextVO> availableAutoTextsForUser = this.getAvailableAutoTextsForUser(currentUserAccountID);
        List signatures = availableAutoTextsForUser.stream().filter(AutoTextVO::isEmailSignature).collect(Collectors.toList());
        int userId = HDUsersAndGroups.getUserID(currentUserAccountID);
        List ownSignatures = signatures.stream().filter(at -> at.getUserId() != null && at.getUserId() == userId && (at.getMemberships() == null || at.getMemberships().isEmpty())).collect(Collectors.toList());
        if (!ownSignatures.isEmpty()) {
            signatures = ownSignatures;
        }
        if (signatures.size() != 1) {
            return null;
        }
        return (AutoTextVO)signatures.get(0);
    }

    @Nullable
    public AutoTextVO getAutoUserSignature(Integer ticketId, Integer stepId) {
        GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
        AutoTextVO at = this.getAutoUserSignature();
        if (at == null) {
            return null;
        }
        String content = this.fillPlaceholders(at.getContentText(), ticketId, stepId);
        return AutoTextVO.of(at.getId(), HDUsersAndGroups.getUserID(currentUserAccountID), at.getLabel(), at.getTyp(), content, at.getShortcut(), at.getGroupLabel(), at.getMemberships());
    }

    public String fillPlaceholders(String content, @Nullable Integer ticketId, @Nullable Integer stepId) {
        return this.fillPlaceholders(content, ticketId, stepId, placeHolderName -> TEXTBAUSTEIN_START_TAG + placeHolderName + TEXTBAUSTEIN_END_TAG);
    }

    public String fillPlaceholders(String content, @Nullable Integer ticketId, @Nullable Integer stepId, Function<String, String> toPlaceholder) {
        if (StringFunctions.isEmpty((String)content)) {
            return content;
        }
        TicketVO ticket = ticketId == null ? null : TicketManager.getReader().getTicket(ticketId);
        UserAccount supporter = UserManager.getInstance().getCurrentUserAccount();
        for (String placeHolder : this.getAllPossiblePlaceholders().keySet()) {
            String fullPlaceholder = toPlaceholder.apply(placeHolder);
            if (content == null || !content.contains(fullPlaceholder)) continue;
            Object replacer = this.getCustomPlaceholderValue(placeHolder, ticket, stepId, supporter);
            if (replacer == null) {
                TicketFieldDefinition def;
                replacer = placeHolder.startsWith(PLACEHOLDER_PREFIX_CURRENTUSER) ? this.getCurrentUserFieldValue(supporter, placeHolder) : ((def = this.findDefinition(placeHolder)) != null ? this.getTicketFieldValue(ticket, def) : "?" + placeHolder + "?");
            }
            if (this.isValidHttpUrl((String)replacer)) {
                content = content.replace("<a href=\"" + fullPlaceholder + "\"", "<a href=\"" + (String)replacer + "\"");
                content = content.replace(fullPlaceholder, "<a href=\"" + (String)replacer + "\">" + (String)replacer + "</a>");
                continue;
            }
            if ("{ticketid-reference}".equalsIgnoreCase(fullPlaceholder)) {
                replacer = StringFunctions.encodeHTML((String)replacer);
            }
            content = content.replace(fullPlaceholder, (CharSequence)replacer);
        }
        return content;
    }

    private boolean isValidHttpUrl(String text) {
        try {
            URL u = new URL(text);
            return u.getProtocol().matches("https?");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Nonnull
    private String getCurrentUserFieldValue(UserAccount supporter, String placeHolder) {
        if (placeHolder.equals(PLACEHOLDER_CUSTOM_CURRENTUSER_DISPLAYNAME)) {
            return supporter != null ? supporter.getDisplayName() : "";
        }
        String placeHolderWithOwnerPrefix = placeHolder.replace(PLACEHOLDER_PREFIX_CURRENTUSER, PLACEHOLDER_PREFIX_OWNER);
        TicketFieldDefinition def = this.findDefinition(placeHolderWithOwnerPrefix);
        if (def == null) {
            return "?" + placeHolder + "?";
        }
        MutableTicketAttributes attributes = new MutableTicketAttributes();
        MutableTicketData data = new MutableTicketData();
        data.put(Tickets.FIELD_OWNER_GUID, supporter.getID());
        TicketVOSingle dummy = TicketVOSingle.create(141, attributes, data);
        return this.nullToEmpty(def.getDisplayValue(dummy));
    }

    @Nonnull
    private String nullToEmpty(String displayValue) {
        if (displayValue == null) {
            return "";
        }
        return displayValue;
    }

    private TicketFieldDefinition findDefinition(String placeHolder) {
        List list = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        for (TicketFieldDefinition ticketFieldDefinition : list) {
            if (!ticketFieldDefinition.getKey().equals(placeHolder) || !ticketFieldDefinition.supportsText()) continue;
            return ticketFieldDefinition;
        }
        return null;
    }

    @Nonnull
    private String getTicketFieldValue(@Nullable TicketVO ticket, TicketFieldDefinition def) {
        if (ticket == null) {
            return "";
        }
        return this.nullToEmpty(def.getDisplayValue(ticket));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private String getCustomPlaceholderValue(String placeHolder, @Nullable TicketVO ticket, @Nullable Integer stepId, UserAccount currentUser) {
        Locale locale = ClientLocale.getThreadLocale();
        if (PLACEHOLDER_CUSTOM_REASTEPDATA.equalsIgnoreCase(placeHolder)) {
            Object replacer = "";
            if (stepId != null) {
                ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(stepId);
                ReaStepVO reaStep = TicketManager.getReader().getReaStep(stepId);
                if (reaStepText != null) {
                    String text = reaStepText.getText();
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
                    String date = dateFormat.format(new Date(reaStep.getStartDate()));
                    if (reaStepText.hasHtmlContent()) {
                        text = this.getInlinedHtml(text);
                        replacer = (String)replacer + Tickets.MSG.getMsg("autotext.emailheader", new Object[]{date, (String)(reaStep.getDisplayName() != null ? reaStep.getDisplayName() + "&nbsp;" : "") + "&lt;" + reaStep.getEmailSenderAddress() + "&gt;"});
                        replacer = (String)replacer + "<br>";
                        replacer = (String)replacer + "<div style=\"border-top-style:none;border-right-style:none;border-bottom-style:none;border-left-style:solid;border-left-color:blue;border-left-width:1.5pt;padding-top:0cm;padding-right:0cm;padding-bottom:0cm;padding-left:4pt;color:rgb(0,0,0);\">";
                        replacer = (String)replacer + text;
                        replacer = (String)replacer + "</div>";
                    } else {
                        replacer = (String)replacer + Tickets.MSG.getMsg("autotext.emailheader", new Object[]{date, (String)(reaStep.getDisplayName() != null ? reaStep.getDisplayName() + "&nbsp;" : "") + "&#60;" + reaStep.getEmailSenderAddress() + "&#62;"});
                        replacer = (String)replacer + "<br>";
                        Object result = "";
                        StringTokenizer t = new StringTokenizer(text, "\n", true);
                        while (t.hasMoreTokens()) {
                            String nextToken = t.nextToken();
                            if ("\n".equals(nextToken)) {
                                result = (String)result + nextToken;
                                continue;
                            }
                            result = (String)result + "> " + nextToken;
                        }
                        replacer = (String)replacer + HtmlConverter.text2html((String)result, null);
                    }
                }
            }
            return replacer;
        }
        if (PLACEHOLDER_CUSTOM_TICKETID_STRING.equals(placeHolder)) {
            if (ticket == null) {
                return "";
            }
            return Tickets.getTicketIDForEmailSubject(ticket.getID());
        }
        if (PLACEHOLDER_CUSTOM_TICKETID_INTEGER.equals(placeHolder)) {
            if (ticket == null) {
                return "";
            }
            return "" + ticket.getID();
        }
        if (PLACEHOLDER_TICKET_GUID.equals(placeHolder)) {
            if (ticket == null) {
                return "";
            }
            GUID guid = ticket.getAttribute(Tickets.ATTRIBUTE_TICKET_GUID);
            return guid == null ? "" : guid.toString();
        }
        if (placeHolder.endsWith(PLACEHOLDER_CUSTOM_USER_EMAIL)) {
            if (placeHolder.equalsIgnoreCase("currentuser.email")) {
                return currentUser != null ? (String)currentUser.getValue((UserField)UsersAndGroups.FIELD_EMAIL) : "";
            }
            if (placeHolder.equalsIgnoreCase("ticketowner.email")) {
                if (ticket == null) {
                    return "";
                }
                GUID ownerID = ticket.getOwnerID();
                if (ownerID == null) {
                    return "";
                }
                UserAccount userAccount = UserManager.getInstance().getUserAccount(ownerID);
                if (userAccount == null) {
                    return "Unknown user";
                }
                return (String)userAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
            }
        } else {
            if (placeHolder.equalsIgnoreCase(PLACEHOLDER_CUSTOM_OWNER_DISPLAYNAME)) {
                if (ticket == null) {
                    return "";
                }
                GUID ownerID = ticket.getOwnerID();
                if (ownerID == null) {
                    return "";
                }
                UserAccount userAccount = UserManager.getInstance().getUserAccount(ownerID);
                return userAccount != null ? userAccount.getDisplayName() : "Unknown user";
            }
            if (placeHolder.startsWith(PLACEHOLDER_PREFIX_DATETIME)) {
                if (placeHolder.endsWith(PLACEHOLDER_DATETIME_DATESHORT)) {
                    return DateFormat.getDateInstance(3, locale).format(this.getDate(ClientTimezone.getTimeZone()));
                }
                if (placeHolder.endsWith(PLACEHOLDER_DATETIME_TIMESHORT)) {
                    return DateFormat.getTimeInstance(3, locale).format(this.getDate(ClientTimezone.getTimeZone()));
                }
                if (placeHolder.endsWith(PLACEHOLDER_DATETIME_DATE)) {
                    return DateFormat.getDateInstance(2, locale).format(this.getDate(ClientTimezone.getTimeZone()));
                }
                if (placeHolder.endsWith(PLACEHOLDER_DATETIME_TIME)) {
                    return DateFormat.getTimeInstance(2, locale).format(this.getDate(ClientTimezone.getTimeZone()));
                }
            } else {
                @Nonnull List providers = DynamicExtensionManager.getInstance().get(AutoTextPlaceholderProvider.class);
                for (AutoTextPlaceholderProvider p : providers) {
                    String value = p.getCustomPlaceholderValue(placeHolder, ticket, stepId, currentUser);
                    if (value == null) continue;
                    return value;
                }
            }
        }
        return null;
    }

    Date getDate(TimeZone timezone) {
        Calendar instance = null;
        instance = timezone == null ? Calendar.getInstance() : Calendar.getInstance(timezone);
        return instance.getTime();
    }

    @Deprecated
    public static AutoTextManager getInstance() {
        return (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
    }

    private Set<UserGroupInfo> getGroupsAndParentGroups(UserGroupInfo group, UserGroupManager manager, Set<UserGroupInfo> allGroups) {
        UserGroupInfo parent;
        if (allGroups == null) {
            allGroups = new HashSet<UserGroupInfo>();
        }
        allGroups.add(group);
        if (group.getParentID() != null && (parent = manager.getGroup(group.getParentID())) != null) {
            allGroups.add(parent);
            allGroups.addAll(this.getGroupsAndParentGroups(parent, manager, allGroups));
        }
        return allGroups;
    }

    public List<AutoTextVO> getAvailableAutoTextsForUser(GUID userId) {
        List allAutoTexts = this.getAll(true);
        int userID = HDUsersAndGroups.getUserID(userId);
        UserAccount userAccount = UserManager.getInstance().getUserAccount(userId);
        UserGroupManager ugm = UserGroupManager.getInstance();
        Set groupsForUser = new HashSet();
        if (userAccount != null) {
            groupsForUser = ugm.getGroupsForUser(userAccount.getID());
        }
        HashSet allGroups = new HashSet();
        groupsForUser.stream().forEach(g -> allGroups.addAll(this.getGroupsAndParentGroups((UserGroupInfo)g, ugm, allGroups)));
        List availableAutoTextsDueMembership = allAutoTexts.stream().filter(at -> this.canAccessDueToAllowedMembers(userAccount, allGroups, (AutoTextVO)at)).collect(Collectors.toList());
        List availableAutoTextsDueOwnership = allAutoTexts.stream().filter(at -> at.getUserId() != null && at.getUserId() == userID && (at.getMemberships() == null || at.getMemberships().isEmpty())).collect(Collectors.toList());
        return Stream.concat(availableAutoTextsDueMembership.stream(), availableAutoTextsDueOwnership.stream()).distinct().collect(Collectors.toList());
    }

    public List<AutoTextVO> getConfigurableAutoTextsForUser(GUID userId, Enum<VisibilityFilter> filter) {
        int userID = HDUsersAndGroups.getUserID(userId);
        UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getUserAccount(userId);
        UserGroupManager ugm = UserGroupManager.getInstance();
        List<AutoTextVO> allAutoTexts = this.getAll(true);
        Set groupsForUser = new HashSet();
        if (userAccount != null) {
            groupsForUser = ugm.getGroupsForUser(userAccount.getID());
        }
        if (VisibilityFilter.IS_ADMIN.equals(filter)) {
            boolean isAdminGroup = groupsForUser.contains(UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ADMIN));
            if (userAccount == null || !userAccount.getAccountType().equals((Object)UserAccountType.Administrator) && !isAdminGroup) {
                return new ArrayList<AutoTextVO>();
            }
            return allAutoTexts;
        }
        List<AutoTextVO> availableAutoTextsDueOwnership = allAutoTexts.stream().filter(at -> at.getUserId() != null && at.getUserId() == userID).collect(Collectors.toList());
        if (VisibilityFilter.IS_OWNER.equals(filter)) {
            return availableAutoTextsDueOwnership;
        }
        HashSet allGroups = new HashSet();
        groupsForUser.stream().forEach(g -> allGroups.addAll(this.getGroupsAndParentGroups((UserGroupInfo)g, ugm, allGroups)));
        List availableAutoTextsDueMembership = allAutoTexts.stream().filter(at -> this.canAccessDueToAllowedMembers(userAccount, allGroups, (AutoTextVO)at)).collect(Collectors.toList());
        if (VisibilityFilter.HAS_PERMISSION.equals(filter)) {
            return Stream.concat(availableAutoTextsDueMembership.stream(), availableAutoTextsDueOwnership.stream()).distinct().collect(Collectors.toList());
        }
        return new ArrayList<AutoTextVO>();
    }

    private boolean canAccessDueToAllowedMembers(UserAccount userAccount, Set<UserGroupInfo> groupsForUser, AutoTextVO vo) {
        List<AutoTextMember> memberships = vo.getMemberships();
        if (memberships != null && memberships.size() > 0) {
            for (AutoTextMember member : memberships) {
                if (!(member.getType().equals((Object)com.inet.usersandgroups.api.ui.Type.user) ? userAccount.getID().equals((Object)member.getId()) : member.getType().equals((Object)com.inet.usersandgroups.api.ui.Type.group) && groupsForUser.stream().map(UserGroupInfo::getID).anyMatch(guid -> guid.equals((Object)member.getId())))) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getAutoTextGroups() {
        return this.getAll(true).stream().map(AutoTextVO::getGroupLabel).filter(Objects::nonNull).map(g -> g.trim()).distinct().sorted((a, b) -> {
            if (a.isEmpty()) {
                if (b.isEmpty()) {
                    return 0;
                }
                return 1;
            }
            if (b.isEmpty()) {
                return -1;
            }
            return a.compareToIgnoreCase((String)b);
        }).collect(Collectors.toList());
    }

    @Override
    public URL getIcon(int id, int size) {
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, String> getAllPossiblePlaceholders() {
        HashMap<String, String> result = new HashMap<String, String>();
        DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class).forEach(f -> {
            if (f.supportsText()) {
                result.put(f.getKey(), f.getDisplayName());
                if (f instanceof AbstractTicketFieldDefinitionForTicketOwner) {
                    String key = f.getKey().replace(PLACEHOLDER_PREFIX_OWNER, PLACEHOLDER_PREFIX_CURRENTUSER);
                    result.put(key, f.getDisplayName());
                }
            }
        });
        result.put(PLACEHOLDER_CUSTOM_REASTEPDATA, Tickets.MSG.getMsg("autotext.placeholder.reastep", new Object[0]));
        result.put(PLACEHOLDER_CUSTOM_TICKETID_STRING, Tickets.MSG.getMsg("autotext.placeholder.ticketIdString", new Object[0]));
        result.put(PLACEHOLDER_CUSTOM_TICKETID_INTEGER, Tickets.MSG.getMsg("autotext.placeholder.ticketIdInteger", new Object[0]));
        result.put(PLACEHOLDER_TICKET_GUID, Tickets.MSG.getMsg("autotext.placeholder.ticket.guid", new Object[0]));
        result.put(PLACEHOLDER_CUSTOM_CURRENTUSER_DISPLAYNAME, Tickets.MSG.getMsg("autotext.placeholder.currentuser.displayname", new Object[0]));
        result.put(PLACEHOLDER_CUSTOM_OWNER_DISPLAYNAME, Tickets.MSG.getMsg("autotext.placeholder.ticketowner.displayname", new Object[0]));
        result.put("currentuser.email", Tickets.MSG.getMsg("autotext.placeholder.email", new Object[0]));
        result.put("ticketowner.email", Tickets.MSG.getMsg("autotext.placeholder.email", new Object[0]));
        result.put("datetime.date", Tickets.MSG.getMsg("autotext.placeholder.date", new Object[0]));
        result.put("datetime.dateshort", Tickets.MSG.getMsg("autotext.placeholder.dateshort", new Object[0]));
        result.put("datetime.time", Tickets.MSG.getMsg("autotext.placeholder.time", new Object[0]));
        result.put("datetime.timeshort", Tickets.MSG.getMsg("autotext.placeholder.timeshort", new Object[0]));
        @Nonnull List autoTextPlaceholderProviders = DynamicExtensionManager.getInstance().get(AutoTextPlaceholderProvider.class);
        autoTextPlaceholderProviders.stream().map(AutoTextPlaceholderProvider::provideAdditionalAutoTextPlaceholders).filter(p -> p != null && !p.isEmpty()).flatMap(p -> p.stream()).forEach(placeholder -> placeholder.getEntries().forEach(e -> result.put(e.getKey(), e.getValue())));
        return result;
    }

    @Override
    protected void updateModelValueFromResultSet(AutoTextVO vo, ResultSet rs, int columnIndex, Field field) throws IllegalAccessException, SQLException {
        if (!field.getName().equalsIgnoreCase("memberships")) {
            super.updateModelValueFromResultSet(vo, rs, columnIndex, field);
            return;
        }
        ArrayList fromJson = null;
        try (InputStream binaryStream = rs.getBinaryStream(columnIndex);){
            String jsonStr;
            if (binaryStream != null && !StringFunctions.isEmpty((String)(jsonStr = IOFunctions.readString((InputStream)binaryStream, (Charset)StandardCharsets.UTF_8))) && !jsonStr.equals("null")) {
                try {
                    fromJson = (ArrayList)new Json().fromJson(jsonStr, ArrayList.class, new Type[]{AutoTextMember.class});
                }
                catch (JsonException ex) {
                    HDLogger.error((Object)ex);
                }
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        vo.setMemberships(fromJson);
    }

    @Override
    protected void updateResultSetValueFromModelValue(AutoTextVO vo, Field field, ResultSet rs, int columnIndex) throws IllegalAccessException, SQLException {
        if (!field.getName().equalsIgnoreCase("memberships")) {
            super.updateResultSetValueFromModelValue(vo, field, rs, columnIndex);
            return;
        }
        List<AutoTextMember> memberships = vo.getMemberships();
        byte[] jsonBytes = memberships == null ? null : new Json().toJson(memberships).getBytes(StandardCharsets.UTF_8);
        rs.updateObject(columnIndex, jsonBytes);
    }

    public HashMap<String, Boolean> getAllAutoTextNames(int userId) {
        HashMap<String, Boolean> names = new HashMap<String, Boolean>();
        List list = this.getAll(true);
        for (AutoTextVO autoTextVO : list) {
            names.put(autoTextVO.getLabel(), autoTextVO.getMemberships() != null && !autoTextVO.getMemberships().isEmpty() || autoTextVO.getUserId() != null && autoTextVO.getUserId() == userId);
        }
        return names;
    }

    private String getInlinedHtml(String htmlText) {
        InetHtmlDocument doc = new InetHtmlDocument();
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, (Object)InetHtmlConfiguration.getMailEditorConfig());
        doc.putProperty((Object)"IgnoreCharsetDirective", (Object)Boolean.TRUE);
        htmlText = htmlText.replace("<head>", "<head><style>p.hddefault { margin-top:0px; margin-bottom:0px; }</style>");
        try {
            doc.parse((Reader)new StringReader(htmlText), 0);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        doc.setDocumentProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, (Object)InetHtmlConfiguration.getMailEditorConfig());
        StringWriter out = new StringWriter();
        Element element = ElementUtils.getBodyElement((InetHtmlDocument)doc);
        InetHtmlWriter writer = new InetHtmlWriter((Writer)out, element);
        writer.setInlineMode(true);
        writer.setAllowStyleSpan(false);
        writer.setEmptyBlockFiller("<br>");
        writer.setWriteSelectedElementOnly(true);
        try {
            writer.write();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        String textContent = out.toString();
        String rootURL = SessionStore.getRootURL();
        if (rootURL != null) {
            if (textContent.indexOf("src=\"Attachment") != -1) {
                textContent = textContent.replace("src=\"Attachment", "src=\"" + rootURL + "Attachment");
            }
            if (textContent.indexOf("href=\"Attachment") != -1) {
                textContent = textContent.replace("href=\"Attachment", "href=\"" + rootURL + "Attachment");
            }
        }
        return textContent;
    }

    public void cleanUpAutoTextsOfUser(@Nonnull UserAccount userAccount) {
        List<AutoTextVO> allAutoTextsForUser = this.getConfigurableAutoTextsForUser(userAccount.getID(), VisibilityFilter.IS_OWNER);
        allAutoTextsForUser.forEach(at -> {
            try {
                this.update(AutoTextVO.of(at.getId(), null, at.getLabel(), at.getTyp(), at.getContentText(), at.getShortcut(), at.getGroupLabel(), at.getMemberships()));
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
        });
    }

    public static enum VisibilityFilter {
        IS_ADMIN,
        HAS_PERMISSION,
        IS_OWNER;

    }
}

