/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByFirstLetterSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldSortedIteratorDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.JoinFieldSortedIteratorDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionHDCore;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionWithHyperlink;
import com.inet.id.GUID;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.ui.fields.values.HyperlinkFieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Comparator;
import javax.annotation.Nullable;

@InternalApi
public class AbstractTicketFieldDefinitionForTicketOwner
extends TicketFieldDefinition
implements TicketFieldDefinitionHDCore,
TicketFieldDefinitionWithHyperlink {
    public static final String TICKETOWNER_PREFIX = "ticketowner.";
    protected UserFieldDefinition<?> fieldInstance;

    public AbstractTicketFieldDefinitionForTicketOwner(UserFieldDefinition<?> fieldInstance, int prio) {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET_OWNER, TICKETOWNER_PREFIX + fieldInstance.getFieldKey(), true, false, prio);
        this.fieldInstance = fieldInstance;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        GUID ownerID = ticket.getOwnerID();
        if (ownerID == null) {
            return null;
        }
        UserAccount userAccount = UserManager.getInstance().getUserAccount(ownerID);
        if (userAccount != null) {
            UserField userField = this.fieldInstance.getUserField();
            if (userField != null) {
                return this.getFormattedFieldValue(userAccount, userField);
            }
            return this.fieldInstance.getFieldValue(userAccount).getValue();
        }
        return null;
    }

    private <T> String getFormattedFieldValue(UserAccount userAccount, UserField<T> userField) {
        return userField.getFieldType().getDisplayValue(userAccount.getValue(userField));
    }

    @Override
    public String getLabel() {
        return this.fieldInstance.getLabel();
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByFirstLetterSortGroupInformation(this);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }

    @Override
    public FieldSortedIteratorDefinition getSortedDefinition() {
        return new JoinFieldSortedIteratorDefinition("ownerid", (IndexSearchEngine<GUID>)UserManager.getInstance().getSearchEngine(), this.fieldInstance.getFieldKey());
    }

    @Override
    public boolean isAvailable() {
        UserFieldDefinition userFieldDefinitionByKey = UsersAndGroups.getUserFieldDefinitionByKey((String)this.fieldInstance.getFieldKey());
        return userFieldDefinitionByKey != null && userFieldDefinitionByKey.isAvailable(null);
    }

    @Override
    public String getDescription() {
        return this.fieldInstance.getDescription();
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return null;
    }

    @Override
    public boolean isLinkField() {
        return "fieldtype_link".equals(this.fieldInstance.getDisplayType());
    }

    @Override
    public String getHyperlink(TicketVO ticket) {
        if ("fieldtype_link".equals(this.fieldInstance.getDisplayType())) {
            FieldValue fieldValue;
            GUID ownerID = ticket.getOwnerID();
            if (ownerID == null) {
                return null;
            }
            UserAccount userAccount = UserManager.getInstance().getUserAccount(ownerID);
            if (userAccount != null && (fieldValue = this.fieldInstance.getFieldValue(userAccount)) instanceof HyperlinkFieldValue) {
                return ((HyperlinkFieldValue)fieldValue).getHref();
            }
        }
        return null;
    }
}

