/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager;

import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.search.SearchTag;
import java.util.HashSet;
import java.util.Set;

public abstract class PluggableTicketSearchTag<VALUE> {
    private final SearchTag searchTag;
    private Set<PluggableTicketSearchTagValueChangeListener<VALUE>> valueChangeListeners = new HashSet<PluggableTicketSearchTagValueChangeListener<VALUE>>();

    public PluggableTicketSearchTag(SearchTag searchTag) {
        if (searchTag == null) {
            throw new IllegalArgumentException("searchTag must not be null");
        }
        this.searchTag = searchTag;
    }

    public final void addValueChangeListener(PluggableTicketSearchTagValueChangeListener<VALUE> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("value change listener must not be null");
        }
        this.valueChangeListeners.add(listener);
    }

    public final SearchTag getSearchTag() {
        return this.searchTag;
    }

    protected final Set<PluggableTicketSearchTagValueChangeListener<VALUE>> getValueChangeListeners() {
        if (this.valueChangeListeners.isEmpty()) {
            throw new IllegalStateException("no value change listener is registered");
        }
        return this.valueChangeListeners;
    }

    public abstract VALUE getValue(int var1);

    public VALUE getValue(TicketVO ticket) {
        return this.getValue(ticket.getID());
    }

    public static interface PluggableTicketSearchTagValueChangeListener<VALUE> {
        public void valueChanged(int var1, VALUE var2, VALUE var3);
    }
}

