/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext;

import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.model.ConfigSearchSuggestion;
import com.inet.helpdesk.config.autotext.LoadAutoTextUtil;
import com.inet.helpdesk.config.autotext.data.AutoTextEntry;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AutoTextConfigPage
implements ConfigPage {
    public String getPageKey() {
        return "configuration.autotext";
    }

    public String getParentKey() {
        return "configuration.templates";
    }

    public String getShortDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.autotext", new Object[0]);
    }

    public String getFullDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.autotext.fulldisplayname", new Object[0]);
    }

    public String getDescription() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.autotext.description", new Object[0]);
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/helpdesk/config/autotext/images/autotext_48.png");
    }

    public String getRelativeTemplateUrl() {
        return "weblib/configuration.autotext.html";
    }

    public boolean isAccessAllowed() {
        if (ConfigurationManager.isRecoveryMode() || ConfigurationManager.isHelpCenterMode()) {
            return false;
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return false;
        }
        if (HDUsersAndGroups.isSupporter(currentUserAccount)) {
            return true;
        }
        return SystemPermissionChecker.hasAnyPermission((UserAccount)currentUserAccount, (Permission[])new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION});
    }

    public String getHelpKey() {
        return "configuration.autotext";
    }

    public List<ConfigSearchSuggestion> getSearchSuggestions(String searchTerm, Map<String, String> properties) {
        ArrayList<ConfigSearchSuggestion> suggestions = new ArrayList<ConfigSearchSuggestion>();
        if (searchTerm != null && !searchTerm.isEmpty()) {
            String prop;
            String filter = "visible";
            if (properties != null && !StringFunctions.isEmpty((String)(prop = properties.get("filterAutoText")))) {
                filter = prop;
            }
            if (HelpdeskServerPlugin.CONFIG_PAGE_AUTOTEXT.getFullDisplayName().toLowerCase().contains(searchTerm.toLowerCase())) {
                suggestions.add(new ConfigSearchSuggestion(HelpdeskServerPlugin.CONFIG_PAGE_AUTOTEXT.getFullDisplayName(), "page/configuration.autotext/", HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.templates", new Object[0]), 20, true));
            }
            List<AutoTextEntry> autoTextEntries = LoadAutoTextUtil.getAutoTextEntries(filter, searchTerm);
            for (AutoTextEntry autoTextEntry : autoTextEntries) {
                if (autoTextEntry.getSortId() <= 0) continue;
                Object path = "page/configuration.autotext";
                path = (String)path + "/editautotext/" + autoTextEntry.getId();
                suggestions.add(new ConfigSearchSuggestion(autoTextEntry.getLabel(), (String)path, HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.autotext", new Object[0]), autoTextEntry.getSortId()));
            }
        }
        return suggestions;
    }
}

