/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultAlterDropCommand;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.DefaultSimpleCommand;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OracleAlterDropCommand
extends DefaultAlterDropCommand {
    private DatabaseInfos dbInfo;
    private Node tableName;
    private DefaultCommandSyntax syntax;

    protected OracleAlterDropCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        super(dbInfo, syntax, tableName);
        this.dbInfo = dbInfo;
        this.syntax = syntax;
        this.tableName = tableName;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        if (this.getSqlStatement() != null) {
            return super.addDataset(element, action);
        }
        super.addDataset(element, action);
        if (element.getName() == NodeFactory.TAG.index && element.getDiffSource() != null && "false".equals(element.getDiffSource().getParameter(IDatabaseInfos.INDEX_PARAM.non_unique.name())) && !"true".equals(element.getParameter("isprimarykey"))) {
            String tabName = ((ISchemaNode)((Object)this.tableName)).getSourceName(this.dbInfo);
            String name = element.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name());
            Object dropIndexSQL = "";
            if (this.syntax.useTableNameOnDropIndex()) {
                dropIndexSQL = "ALTER TABLE " + tabName + " ";
            }
            dropIndexSQL = (String)dropIndexSQL + "DROP INDEX " + (String)(this.dbInfo.getCurrentSchema() != null ? this.dbInfo.getQuote(this.dbInfo.getCurrentSchema()) + "." : "") + this.dbInfo.getQuote(name);
            ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
            String dropConstrainSQL = "ALTER TABLE " + tabName + " DROP CONSTRAINT " + name;
            commands.add(new DefaultSimpleCommand(dropConstrainSQL, this.dbInfo, true, IDatabaseCommand.TIME.dropreferences, false));
            commands.add(new DefaultSimpleCommand((String)dropIndexSQL, this.dbInfo, true, IDatabaseCommand.TIME.dropreferences, true));
            return commands;
        }
        return null;
    }
}

