/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITriggerCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DefaultCreateSequenceCommand
implements ITriggerCommand {
    private final DatabaseInfos dbInfo;
    private Node element;
    private String startvalueexpression;
    private static Logger logger = LogManager.getLogger((String)"DB Updater");

    public DefaultCreateSequenceCommand(DatabaseInfos dbInfo) {
        this.dbInfo = dbInfo;
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.createtriggers;
    }

    @Override
    public String getCommandKey() {
        if (this.element == null) {
            return Long.toString(System.identityHashCode(this));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE SEQUENCE ");
        buffer.append(this.dbInfo.getQuote(this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.name.name())));
        buffer.append(" INCREMENT BY ");
        buffer.append(this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.incrementby.name()));
        buffer.append(" MINVALUE ");
        buffer.append(this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.minvalue.name()));
        return buffer.toString();
    }

    @Override
    public String getSqlStatement() {
        if (this.element == null) {
            return Long.toString(System.identityHashCode(this));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE SEQUENCE ");
        buffer.append(this.dbInfo.getQuote(this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.name.name())));
        buffer.append(" START WITH ");
        buffer.append(this.getStartValue());
        buffer.append(" INCREMENT BY ");
        buffer.append(this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.incrementby.name()));
        buffer.append(" MINVALUE ");
        buffer.append(this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.minvalue.name()));
        String cache = this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.cache.name());
        int cacheSize = 0;
        try {
            if (cache != null) {
                cacheSize = Integer.parseInt(cache);
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Invalid cache size '" + cache + "', falling back to NOCACHE"));
        }
        if (cacheSize > 0) {
            buffer.append(" CACHE ").append(cacheSize);
        } else {
            buffer.append(" NOCACHE ");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getStartValue() {
        block23: {
            if (this.startvalueexpression == null || this.startvalueexpression.trim().length() == 0) {
                return this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.minvalue.name());
            }
            this.startvalueexpression = this.startvalueexpression.trim();
            if (!this.startvalueexpression.toUpperCase().startsWith("SELECT ")) {
                return this.startvalueexpression;
            }
            long incr = 1L;
            String incrVal = this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.incrementby.name());
            if (incrVal != null) {
                try {
                    incr = Long.parseLong(incrVal);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ResultSet rs = null;
            try {
                String firstVal;
                rs = this.dbInfo.getDBConnection().executeQuery(this.startvalueexpression);
                if (rs.next() && (firstVal = rs.getString(1)) != null) {
                    try {
                        long longval = Long.parseLong(firstVal);
                        String string = String.valueOf(longval += incr);
                        return string;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                break block23;
                {
                    catch (SQLException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return this.element.getRecentValue(IDatabaseInfos.SEQUENCE_PARAM.minvalue.name());
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        this.element = element;
        List<? extends Node> startchilds = element.getChildren(NodeFactory.TAG.startvalue);
        if (startchilds != null && startchilds.size() > 0) {
            Node startnode = startchilds.get(0);
            this.startvalueexpression = startnode.getContent();
        }
        return null;
    }
}

