/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.DatabaseInfosMySQL;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultInsertDataCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.Constructor;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.model.NodeIndex;
import com.inet.dbupdater.model.NodeReference;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Set;

public class DBReader {
    private final DatabaseInfos dbinfo;
    private final Constructor constructor;
    private Logger logger = LogManager.getLogger((String)"DB Updater");

    public DBReader(DatabaseInfos dbinfo, Constructor constructor) {
        this.dbinfo = dbinfo;
        this.constructor = constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTablesAndViews() throws SQLException {
        ArrayList<String> ignoredSchemas = new ArrayList<String>();
        ignoredSchemas.add("INFORMATION_SCHEMA");
        ignoredSchemas.add("SYS");
        ignoredSchemas.add("MASTER");
        ignoredSchemas.add("SYSTEM");
        ignoredSchemas.add("MYSQL");
        ResultSet tables = null;
        this.logger.debug((Object)"starting table and view reader");
        try {
            DatabaseMetaData metaData = this.dbinfo.getDBConnection().getConnection().getMetaData();
            String catalog = this.dbinfo.getDBConnection().getConnection().getCatalog();
            if (catalog == null || catalog.length() == 0) {
                catalog = this.dbinfo.getDBConnection().getDatabaseName();
            }
            Set<String> innoDBTables = this.dbinfo.getInnoDBTables();
            tables = metaData.getTables(catalog, this.dbinfo.getDefaultSchema(), null, new String[]{"TABLE", "VIEW"});
            while (tables.next()) {
                String cat = tables.getString("TABLE_CAT");
                String schema = tables.getString("TABLE_SCHEM");
                String name = tables.getString("TABLE_NAME");
                String type = tables.getString("TABLE_TYPE");
                if (name == null) {
                    this.logger.error((Object)"Table name is null.");
                    continue;
                }
                if (schema != null && ignoredSchemas.contains(schema.toUpperCase())) continue;
                switch (this.dbinfo.getTableType(name, type)) {
                    case 1: {
                        this.readTable(cat, schema, name, innoDBTables);
                        break;
                    }
                    case 2: {
                        this.logger.debug((Object)("VIEW: found view '" + name + "' in schema '" + schema + "'"));
                        try {
                            String sql = this.dbinfo.readView(cat, schema, name);
                            this.constructor.startElement(NodeFactory.TAG.view.name());
                            this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.VIEW_PARAM.name, name);
                            this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.VIEW_PARAM.schema, schema);
                            this.constructor.addText(sql);
                            this.constructor.endCurrentElement(NodeFactory.TAG.view.name());
                            break;
                        }
                        catch (SQLTimeoutException e) {
                            throw e;
                        }
                        catch (SQLException e) {
                            this.logger.error((Throwable)e);
                        }
                    }
                }
            }
        }
        finally {
            if (tables != null) {
                try {
                    tables.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
    }

    public void readTable(String cat, String schema, String name, Set<String> innoDBTables) {
        this.logger.debug((Object)("TABLE: found table '" + name + "' in schema '" + (schema != null ? schema : cat) + "'"));
        this.constructor.startElement(NodeFactory.TAG.table.name());
        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.TABLE_PARAM.name, name);
        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.TABLE_PARAM.schema, schema);
        this.readTableColumns(cat, schema, name);
        this.readTableIndexes(cat, schema, name);
        this.readTableReferences(cat, schema, name);
        Node currTable = this.constructor.getCurrentNode();
        if (innoDBTables != null && innoDBTables.contains(name)) {
            currTable.readParameter("engine", "innodb");
        }
        this.constructor.endCurrentElement(NodeFactory.TAG.table.name());
        if (currTable.getAllChildren().size() == 0) {
            Node currDatabase = this.constructor.getCurrentNode();
            currDatabase.removeChild(currTable);
            this.logger.warn((Object)("Removed empty table '" + name + "' from model."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTableIndexes(String cat, String schema, String name) {
        ResultSet indexes = null;
        try {
            DatabaseMetaData metaData = this.dbinfo.getDBConnection().getConnection().getMetaData();
            indexes = metaData.getIndexInfo(cat, schema, name, false, false);
            while (indexes.next()) {
                int typeNum;
                String indexName = indexes.getString("INDEX_NAME");
                if (indexName == null) continue;
                this.constructor.startElement(NodeFactory.TAG.index.name());
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.INDEX_PARAM.column_name, indexes.getString("COLUMN_NAME"));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.INDEX_PARAM.non_unique, String.valueOf(indexes.getBoolean("NON_UNIQUE")));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.INDEX_PARAM.index_name, indexName);
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.INDEX_PARAM.ordinal_position, String.valueOf(indexes.getInt("ORDINAL_POSITION")));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.INDEX_PARAM.isprimarykey, String.valueOf(this.dbinfo.isPrimaryKey(cat, schema, name, indexName)));
                Object indexType = indexes.getObject("TYPE");
                if (indexType instanceof Number && (typeNum = ((Number)indexType).intValue()) < NodeIndex.TYPE.values().length) {
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.INDEX_PARAM.type, NodeIndex.TYPE.values()[typeNum].name());
                }
                this.constructor.endCurrentElement(NodeFactory.TAG.index.name());
            }
        }
        catch (SQLException e) {
            this.logger.error((Throwable)e);
            this.constructor.closeUpToLevel(NodeFactory.TAG.table);
        }
        finally {
            if (indexes != null) {
                try {
                    indexes.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTableReferences(String cat, String schema, String name) {
        ResultSet references = null;
        try {
            references = this.dbinfo.getForeignKeys(cat, schema, name);
            while (references.next()) {
                this.constructor.startElement(NodeFactory.TAG.reference.name());
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.REFERENCE_PARAM.key_seq, String.valueOf(references.getInt("KEY_SEQ")));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.REFERENCE_PARAM.pktable_name, references.getString("PKTABLE_NAME"));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.REFERENCE_PARAM.pkcolumn_name, references.getString("PKCOLUMN_NAME"));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.REFERENCE_PARAM.fk_name, references.getString("FK_NAME"));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.REFERENCE_PARAM.fkcolumn_name, references.getString("FKCOLUMN_NAME"));
                try {
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.REFERENCE_PARAM.ondelete, NodeReference.onChange.values()[references.getInt("DELETE_RULE")].name());
                }
                catch (Exception e) {
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.REFERENCE_PARAM.ondelete, NodeReference.onChange.noaction.name());
                }
                if (!"oracle".equalsIgnoreCase(this.dbinfo.getDBMSTypeName())) {
                    try {
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.REFERENCE_PARAM.onupdate, NodeReference.onChange.values()[references.getInt("UPDATE_RULE")].name());
                    }
                    catch (Exception e) {
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.REFERENCE_PARAM.onupdate, NodeReference.onChange.noaction.name());
                    }
                }
                this.constructor.endCurrentElement(NodeFactory.TAG.reference.name());
            }
        }
        catch (SQLException e) {
            this.logger.error((Throwable)e);
            this.constructor.closeUpToLevel(NodeFactory.TAG.table);
        }
        finally {
            if (references != null) {
                try {
                    references.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTableColumns(String cat, String schema, String name) {
        ResultSet columns = null;
        try {
            Object tName = this.dbinfo.getQuoteIdentiferIfNeeded(name);
            if (schema != null && !((String)tName).startsWith(schema + ".")) {
                tName = schema + "." + (String)tName;
            }
            ResultSet rsSrc = this.dbinfo.getDBConnection().executeQuery("Select * From " + (String)tName + " Where 1 = 0");
            ResultSetMetaData rsmd = rsSrc.getMetaData();
            DatabaseMetaData metaData = this.dbinfo.getDBConnection().getConnection().getMetaData();
            columns = metaData.getColumns(cat, schema, name, null);
            int columnIdx = 0;
            while (columns.next()) {
                ++columnIdx;
                String colName = columns.getString("COLUMN_NAME");
                int datatype = columns.getInt("DATA_TYPE");
                String typeName = columns.getString("TYPE_NAME");
                int size = columns.getInt("COLUMN_SIZE");
                int scale = columns.getInt("DECIMAL_DIGITS");
                String column_default = columns.getString("COLUMN_DEF");
                this.constructor.startElement(NodeFactory.TAG.column.name());
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.COLUMN_PARAM.column_name, colName);
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.COLUMN_PARAM.data_type, String.valueOf(datatype));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.COLUMN_PARAM.type_name, typeName);
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.COLUMN_PARAM.column_size, String.valueOf(size));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.COLUMN_PARAM.decimal_digits, String.valueOf(scale));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.COLUMN_PARAM.isautoincrement, String.valueOf(rsmd.isAutoIncrement(columnIdx)));
                this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.COLUMN_PARAM.isnotnullable, String.valueOf(this.dbinfo.isNotNullable(columns.getInt("NULLABLE"), rsmd.isNullable(columnIdx), datatype)));
                if (!(column_default == null || this.dbinfo.isQuoteableDataType(datatype) && column_default.length() <= 0 || (column_default = this.dbinfo.translateDefault(column_default, datatype)).length() <= 0)) {
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.COLUMN_PARAM.column_def, column_default);
                }
                this.constructor.endCurrentElement(NodeFactory.TAG.column.name());
            }
        }
        catch (SQLException e) {
            this.logger.error((Throwable)e);
            this.constructor.closeUpToLevel(NodeFactory.TAG.table);
        }
        finally {
            if (columns != null) {
                try {
                    columns.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readProceduresAndFunction() {
        ResultSet procedures = null;
        this.logger.debug((Object)"starting procedure and function reader");
        try {
            DatabaseMetaData metaData = this.dbinfo.getDBConnection().getConnection().getMetaData();
            procedures = metaData.getProcedures(null, this.dbinfo.getDefaultSchema(), "%");
            while (procedures.next()) {
                try {
                    String cat = procedures.getString("PROCEDURE_CAT");
                    String schema = procedures.getString("PROCEDURE_SCHEM");
                    String name = this.dbinfo.getSimpleName(procedures.getString("PROCEDURE_NAME"));
                    String remarks = procedures.getString("REMARKS");
                    int type = procedures.getInt("PROCEDURE_TYPE");
                    if (!this.dbinfo.isUserEntry(name)) continue;
                    if (this.dbinfo.isProcedure(type, name)) {
                        this.logger.debug((Object)("PROCEDURE: found procedure '" + name + "' in schema '" + schema + "'"));
                        this.constructor.startElement(NodeFactory.TAG.procedure.name());
                        try {
                            String readProcedure = this.dbinfo.readProcedure(cat, schema, name);
                            this.constructor.addText(readProcedure);
                        }
                        catch (SQLException sqle) {
                            this.logger.warn((Object)("PROCEDURE '" + name + "' has no content."));
                        }
                    } else {
                        this.logger.debug((Object)("FUNCTION: found function '" + name + "' in schema '" + schema + "'"));
                        this.constructor.startElement(NodeFactory.TAG.function.name());
                        try {
                            String readFunction = this.dbinfo.readFunction(cat, schema, name);
                            this.constructor.addText(readFunction);
                        }
                        catch (SQLException sqle) {
                            this.logger.warn((Object)("FUNCTION '" + name + "' has no content."));
                        }
                    }
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_HEAD_PARAM.name, name);
                    if (remarks != null) {
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_HEAD_PARAM.remarks, remarks);
                    }
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_HEAD_PARAM.type, String.valueOf(type));
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_HEAD_PARAM.schema, schema);
                    this.readProcedureAndFunctionColumns(cat, schema, name);
                    this.constructor.endCurrentElement(null);
                }
                catch (Throwable e) {
                    this.logger.error(e);
                    this.constructor.closeUpToLevel(NodeFactory.TAG.database);
                }
            }
        }
        catch (Throwable e) {
            this.logger.error(e);
        }
        finally {
            if (procedures != null) {
                try {
                    procedures.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcedureAndFunctionColumns(String cat, String schema, String name) {
        ResultSet procedurecols = null;
        try {
            DatabaseMetaData metaData = this.dbinfo.getDBConnection().getConnection().getMetaData();
            procedurecols = metaData.getProcedureColumns(cat, schema, name, "%");
            while (procedurecols.next()) {
                try {
                    String colname = this.dbinfo.getSimpleName(procedurecols.getString("COLUMN_NAME"));
                    int coltype = procedurecols.getInt("COLUMN_TYPE");
                    int datatype = procedurecols.getInt("DATA_TYPE");
                    String typename = procedurecols.getString("TYPE_NAME");
                    int precision = procedurecols.getInt("PRECISION");
                    int scale = procedurecols.getInt("SCALE");
                    int radix = procedurecols.getInt("RADIX");
                    boolean nullable = procedurecols.getBoolean("NULLABLE");
                    if (coltype == 5) continue;
                    this.constructor.startElement(NodeFactory.TAG.column.name());
                    if (colname != null) {
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.column_name, colname);
                    }
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.column_type, String.valueOf(coltype));
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.data_type, String.valueOf(datatype));
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.type_name, typename);
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.precision, String.valueOf(precision));
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.scale, String.valueOf(scale));
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.radix, String.valueOf(radix));
                    this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.FUNCTION_COLUMN_PARAM.nullable, String.valueOf(nullable));
                    this.constructor.endCurrentElement(NodeFactory.TAG.column.name());
                }
                catch (Throwable e) {
                    this.logger.error(e);
                    this.constructor.closeUpToLevel(NodeFactory.TAG.database);
                }
            }
        }
        catch (Throwable e) {
            this.logger.error(e);
        }
        finally {
            if (procedurecols != null) {
                try {
                    procedurecols.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTriggers() {
        block19: {
            ResultSet triggers = null;
            this.logger.debug((Object)"starting trigger reader");
            try {
                triggers = this.dbinfo.getTriggers();
                if (triggers == null) break block19;
                while (triggers.next()) {
                    try {
                        String trigger = triggers.getString("Trigger");
                        String event = triggers.getString("Event");
                        String table = triggers.getString("Table");
                        String statement = triggers.getString("Statement");
                        String timing = triggers.getString("Timing");
                        String schema = null;
                        try {
                            if (!(this.dbinfo instanceof DatabaseInfosMySQL)) {
                                schema = triggers.getString("Schema");
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.logger.debug((Object)("TRIGGER: found trigger '" + trigger + "' in schema '" + schema + "'"));
                        this.constructor.startElement(NodeFactory.TAG.trigger.name());
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.TRIGGER_PARAM.name, trigger);
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.TRIGGER_PARAM.event, event);
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.TRIGGER_PARAM.table, table);
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.TRIGGER_PARAM.timing, timing);
                        if (schema != null) {
                            this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.TRIGGER_PARAM.schema, schema);
                        }
                        this.constructor.addText(statement);
                        this.constructor.endCurrentElement(NodeFactory.TAG.trigger.name());
                    }
                    catch (Throwable e) {
                        this.logger.error(e);
                        this.constructor.closeUpToLevel(NodeFactory.TAG.database);
                    }
                }
            }
            catch (Throwable e) {
                this.logger.error(e);
            }
            finally {
                if (triggers != null) {
                    try {
                        triggers.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSequences() {
        ResultSet sequences = null;
        this.logger.debug((Object)"starting sequence reader");
        try {
            sequences = this.dbinfo.getSequences();
            if (sequences == null) {
                this.logger.info((Object)"Sequences not available.");
                return;
            }
            if (sequences != null) {
                while (sequences.next()) {
                    try {
                        String sequence = sequences.getString("sequence_name");
                        String minval = sequences.getString("min_value");
                        String incrementby = sequences.getString("increment_by");
                        this.logger.debug((Object)("SEQUENCES: found sequence '" + sequence + "'"));
                        this.constructor.startElement(NodeFactory.TAG.sequence.name());
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.SEQUENCE_PARAM.name, sequence);
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.SEQUENCE_PARAM.minvalue, minval);
                        this.constructor.setParameterToCurrentElement((Object)IDatabaseInfos.SEQUENCE_PARAM.incrementby, incrementby);
                        this.constructor.endCurrentElement(NodeFactory.TAG.sequence.name());
                    }
                    catch (Throwable e) {
                        this.logger.error(e);
                        this.constructor.closeUpToLevel(NodeFactory.TAG.database);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.error(e);
        }
        finally {
            if (sequences != null) {
                try {
                    sequences.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDatasets(String elementname) {
        ResultSet tables = null;
        this.logger.debug((Object)"starting dataset reader");
        try {
            DatabaseMetaData metaData = this.dbinfo.getDBConnection().getConnection().getMetaData();
            String catalog = this.dbinfo.getDBConnection().getConnection().getCatalog();
            if (catalog == null || catalog.length() == 0) {
                catalog = this.dbinfo.getDBConnection().getDatabaseName();
            }
            tables = metaData.getTables(catalog, this.dbinfo.getDefaultSchema(), elementname, new String[]{"TABLE", "VIEW"});
            while (tables.next()) {
                try {
                    String cat = tables.getString("TABLE_CAT");
                    String schema = tables.getString("TABLE_SCHEM");
                    String name = tables.getString("TABLE_NAME");
                    if (name == null) {
                        this.logger.error((Object)"Table name is null.");
                        continue;
                    }
                    this.constructor.addText(this.readAllDatasets(cat, schema, name).toString());
                }
                catch (Throwable e) {
                    this.constructor.closeUpToLevel(NodeFactory.TAG.data);
                    this.logger.error(e);
                }
            }
        }
        catch (Throwable e) {
            this.logger.error(e);
            this.constructor.closeUpToLevel(NodeFactory.TAG.data);
        }
        finally {
            if (tables != null) {
                try {
                    tables.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer readAllDatasets(String cat, String schema, String name) {
        StringBuffer buffer = new StringBuffer();
        ArrayList columnmaps = null;
        ResultSet columns = null;
        ResultSet data = null;
        try {
            buffer.append("DELETE FROM " + this.dbinfo.getQuoteIdentiferIfNeeded(name) + ";");
            buffer.append("\n");
            data = this.dbinfo.getDBConnection().executeQuery("Select * From " + this.dbinfo.getQuoteIdentiferIfNeeded(name));
            DatabaseMetaData metaData = this.dbinfo.getDBConnection().getConnection().getMetaData();
            long count = 0L;
            while (data.next()) {
                if (columnmaps == null) {
                    columnmaps = new ArrayList();
                    this.logger.debug((Object)"DATA: Reading column data");
                    columns = metaData.getColumns(cat, schema, name, null);
                    while (columns.next()) {
                        AttributeMap<String> map = new AttributeMap<String>();
                        String colName = columns.getString("COLUMN_NAME");
                        int datatype = columns.getInt("DATA_TYPE");
                        String typeName = columns.getString("TYPE_NAME");
                        int size = columns.getInt("COLUMN_SIZE");
                        int scale = columns.getInt("DECIMAL_DIGITS");
                        map.put("COLUMN_NAME", colName);
                        map.put("DATA_TYPE", String.valueOf(datatype));
                        map.put("TYPE_NAME", String.valueOf(typeName));
                        map.put("COLUMN_SIZE", String.valueOf(size));
                        map.put("DECIMAL_DIGITS", String.valueOf(scale));
                        columnmaps.add(map);
                    }
                    columns.close();
                }
                this.logger.debug((Object)("DATA: adding dataset " + ++count));
                DefaultInsertDataCommand cmd = new DefaultInsertDataCommand(this.dbinfo, name);
                for (int i = 0; i < columnmaps.size(); ++i) {
                    cmd.addColumn((AttributeMap)columnmaps.get(i), data.getObject(i + 1));
                }
                buffer.append(cmd.getSqlStatement());
                buffer.append("\n");
            }
        }
        catch (SQLException e) {
            this.logger.error((Throwable)e);
        }
        finally {
            if (columns != null) {
                try {
                    columns.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
            if (data != null) {
                try {
                    data.close();
                }
                catch (SQLException e) {
                    this.logger.error((Throwable)e);
                }
            }
        }
        return buffer;
    }
}

