/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.filter;

import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.id.GUID;
import com.inet.search.SearchResultEntry;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.filter.UserOrGroupFilter;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Iterator;
import srv.HdLicenseObserver;

public class NamedUserFilter
implements UserOrGroupFilter {
    public String getExtensionName() {
        return "nameduseronly";
    }

    public int getPriority() {
        return 300;
    }

    public String getSearchPrefix() {
        return "supporter:named ";
    }

    public Type getFilterType() {
        return Type.user;
    }

    public void filterEntries(Iterator<SearchResultEntry<GUID>> iterator, Type type) {
        UserManager manager = UserManager.getRecoveryEnabledInstance();
        while (iterator.hasNext()) {
            UserAccount userAccount;
            SearchResultEntry<GUID> entry = iterator.next();
            if (type == Type.user && (userAccount = manager.getUserAccount((GUID)entry.getId())).getAccountType() == UserAccountType.Standard) continue;
            iterator.remove();
        }
    }

    public String getDisplayName() {
        return HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.filter.nameduseronly", new Object[0]);
    }

    public boolean isApplicable() {
        return HdLicenseObserver.getNamedUserLicenseCount() > 0;
    }
}

