/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.standardviews;

import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.id.GUID;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import java.net.URL;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UnreadTicketViewDefinition
implements TicketViewFactory {
    public static final String KEY = "unreadtickets";
    private final SubViewGroupingDefinition subViewGrouping;

    public UnreadTicketViewDefinition() {
        this(null);
    }

    UnreadTicketViewDefinition(@Nullable SubViewGroupingDefinition subViewGrouping) {
        this.subViewGrouping = subViewGrouping;
    }

    @Override
    public SubViewGroupingDefinition getSubViewGrouping() {
        return this.subViewGrouping;
    }

    @Override
    @Nonnull
    public String getID() {
        return KEY;
    }

    @Override
    @Nonnull
    public String getCategoryKey() {
        return "globalviews";
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        return HelpDeskServer.class.getResource("images/ticketview/unreadticket.png");
    }

    @Override
    public SearchCommand createSearchCommand(@Nonnull GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
        SearchCommand command = new SearchCommand(new SearchExpression[]{GlobalSearchViewDefinition.getGlobalSearchExpressionForAllVisibleTickets(accountID, locale, true)});
        if (this.subViewGrouping != null) {
            this.subViewGrouping.appendMarker(command);
        }
        return command;
    }
}

