/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.userfunctions;

import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportingFieldFunctions
implements UserDefinedFunction {
    private static MemoryStoreMap<UserAccount, Map<String, String>> mapTranslation = new MemoryStoreMap();
    private static MemoryStoreMap<UserAccount, List<String>> mapVisiblity = new MemoryStoreMap();

    private static void initVisibilities(UserAccount currentUserAccount) {
        if (mapVisiblity.containsKey((Object)currentUserAccount)) {
            return;
        }
        mapVisiblity.setTimeout(30, false);
        try (UserAccountScope scope = UserAccountScope.create((GUID)currentUserAccount.getID());){
            List<TicketFieldDefinition> ticketFieldDefinitions = Tickets.getFieldsVisibleForUser();
            ArrayList visibleCols = new ArrayList();
            ticketFieldDefinitions.forEach(col -> visibleCols.add(col.getKey()));
            mapVisiblity.put((Object)currentUserAccount, visibleCols);
        }
    }

    public static boolean isFieldVisible(String column) {
        if (column == null) {
            return false;
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        ReportingFieldFunctions.initVisibilities(currentUserAccount);
        return ((List)mapVisiblity.get((Object)currentUserAccount)).contains(column);
    }

    private static void initTranslations(UserAccount currentUserAccount) {
        if (mapTranslation.containsKey((Object)currentUserAccount)) {
            return;
        }
        mapTranslation.setTimeout(30, false);
        List ticketFieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        HashMap translations = new HashMap();
        ticketFieldDefinitions.forEach(col -> translations.put(col.getKey(), col.getDisplayName()));
        mapTranslation.put((Object)currentUserAccount, translations);
    }

    public static String getFieldTranslation(String column) {
        if (column == null) {
            return "";
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        ReportingFieldFunctions.initTranslations(currentUserAccount);
        return (String)((Map)mapTranslation.get((Object)currentUserAccount)).get(column);
    }

    public static String getReaStepEditor(int userId) {
        if (ReportingFieldFunctions.isSupporterNameDisplayable()) {
            UserAccount userAccount = HDUsersAndGroups.getUserAccount(userId);
            if (userAccount != null) {
                return userAccount.getDisplayName();
            }
            return "unknownUser";
        }
        return "";
    }

    public static boolean isSupporterNameDisplayable() {
        try {
            ServerValuesConnector serverValuesConnector = (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
            boolean supporterNameDisplayable = serverValuesConnector.isSupporterNameDisplayable(ContextType.enduser);
            return supporterNameDisplayable;
        }
        catch (ServerDataException e) {
            HDLogger.error(e);
            return false;
        }
    }
}

