/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.valueprovider;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.model.general.Localization;
import com.inet.helpdesk.shared.model.Field;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;

public class StaticValueProvider {
    private final Field refField;
    private int yourId;
    private static final ConfigValue<Boolean> MAIL_AUTORISIERUNG_USER = new ConfigValue(HDConfigKeys.MAIL_AUTORISIERUNG_USER);

    public StaticValueProvider(Field refField) {
        this.refField = refField;
    }

    public String getFieldKey() {
        return this.refField.name();
    }

    public ArrayList<Entry> getData(UserAccount account, boolean emptyValue) throws ServerDataException {
        Localization bundle = ((LocalizationBundle)ServerPluginManager.getInstance().getSingleInstance(LocalizationBundle.class)).getInstance(ClientLocale.getThreadLocale());
        ArrayList<Entry> result = new ArrayList<Entry>();
        switch (this.refField) {
            case TICKETDATA_AUTOMAILING: {
                result.add(new Entry(this.yourId, 0, bundle.getTranslation("AutomailNo")));
                result.add(new Entry(this.yourId, 1, bundle.getTranslation("AutomailYes")));
                break;
            }
            default: {
                return null;
            }
        }
        return result;
    }

    public Entry getDefaultValue(UserAccount account) throws ServerDataException {
        ArrayList<Entry> data = this.getData(account, false);
        switch (this.refField) {
            case TICKETDATA_AUTOMAILING: {
                if (((Boolean)MAIL_AUTORISIERUNG_USER.get()).booleanValue()) {
                    return data != null && data.size() > 1 ? data.get(1) : null;
                }
                return data != null && data.size() > 0 ? data.get(0) : null;
            }
        }
        return null;
    }
}

