/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.userfilter;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.data.userfilter.UserFilter;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.function.Supplier;

@Deprecated
public class SupporterUserFilter
implements UserFilter {
    private boolean onlySupporter;
    private boolean onlyDispatcher;
    private boolean onlyNamed;

    public SupporterUserFilter(String tagValue) {
        this.onlySupporter = tagValue.equalsIgnoreCase("supporter") || tagValue.isEmpty();
        this.onlyDispatcher = tagValue.equalsIgnoreCase("dispatcher");
        this.onlyNamed = tagValue.equalsIgnoreCase("named");
    }

    @Override
    public int score(UserAccount userAccount) {
        Supplier<Boolean> isSupporter = () -> HDUsersAndGroups.isResourceMember(userAccount) || SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.DISPATCHER, HdPermissions.TICKET_RESOURCES_READ});
        Supplier<Boolean> isDispatcher = () -> SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.DISPATCHER});
        Supplier<Boolean> isNamedUser = () -> HDUsersAndGroups.isNamedUser(userAccount);
        if (this.onlySupporter) {
            return isSupporter.get() != false ? 1 : 0;
        }
        if (this.onlyDispatcher) {
            return isDispatcher.get() != false ? 1 : 0;
        }
        if (this.onlyNamed) {
            return isNamedUser.get() != false ? 1 : 0;
        }
        return isSupporter.get() != false || isDispatcher.get() != false ? 0 : 1;
    }
}

