/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.userfilter;

import com.inet.helpdesk.data.userfilter.UserFilter;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.usersandgroups.api.user.UserAccount;
import java.text.Normalizer;

public class SearchUserFilter
implements UserFilter {
    private String[] searchString;
    private boolean trailingSpaces;
    private final Field[] fieldsToCheck;
    private String bestMatch;
    private boolean useUserNameFallback = true;

    public SearchUserFilter(String searchString, Field ... fieldsToCheck) {
        this.fieldsToCheck = fieldsToCheck;
        searchString = this.removeNonASCII(searchString);
        this.searchString = searchString.split("\\s+");
        this.trailingSpaces = searchString.endsWith(" ");
        for (Field f : fieldsToCheck) {
            if (f != Field.USERDATA_USERNAME) continue;
            this.useUserNameFallback = false;
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int score(UserAccount userAccount) {
        user = UserModelConverter.convertUserAccount(userAccount);
        this.bestMatch = null;
        score = 0;
        fallbackActive = this.useUserNameFallback != false && user.getDisplayName().equals(user.getUserName()) != false;
        localFieldsToCheck = this.fieldsToCheck;
        if (fallbackActive) {
            localFieldsToCheck = new Field[this.fieldsToCheck.length + 1];
            System.arraycopy(this.fieldsToCheck, 0, localFieldsToCheck, 0, this.fieldsToCheck.length);
            localFieldsToCheck[localFieldsToCheck.length - 1] = Field.USERDATA_USERNAME;
        }
        scoreByField = new int[localFieldsToCheck.length];
        for (i = 0; i < this.searchString.length; ++i) {
            word = this.searchString[i];
            completeMatch = this.trailingSpaces != false || i < this.searchString.length - 1;
            subScore = 0;
            j = 0;
            while (j < localFieldsToCheck.length) {
                data = user.getValue(localFieldsToCheck[j], localFieldsToCheck[j].getClassType());
                fieldScore = 0;
                if (data instanceof String) {
                    fieldScore = this.addScore((String)data, word, completeMatch);
                } else if (data instanceof String[]) {
                    for (String part : (String[])data) {
                        fieldScore = Math.max(this.addScore(part, word, completeMatch), fieldScore);
                    }
                } else if (data instanceof Integer) {
                    try {
                        if ((Integer)data != Integer.parseInt(word)) ** GOTO lbl34
                        fieldScore = 3;
                    }
                    catch (NumberFormatException var14_16) {
                        // empty catch block
                    }
                }
lbl34:
                // 7 sources

                subScore = Math.max(subScore, fieldScore);
                v0 = j++;
                scoreByField[v0] = scoreByField[v0] + fieldScore;
            }
            if (subScore == 0) {
                return 0;
            }
            score += subScore;
        }
        maxScore = -1;
        maxScoreField = null;
        for (i = 0; i < localFieldsToCheck.length; ++i) {
            if (scoreByField[i] <= maxScore || localFieldsToCheck[i] == Field.USERDATA_FIRSTNAME || localFieldsToCheck[i] == Field.USERDATA_LASTNAME || fallbackActive && localFieldsToCheck[i] == Field.USERDATA_USERNAME || user.getValue(localFieldsToCheck[i], localFieldsToCheck[i].getClassType()) == null) continue;
            maxScore = scoreByField[i];
            maxScoreField = localFieldsToCheck[i];
        }
        if (maxScoreField != null) {
            data = user.getValue(maxScoreField, maxScoreField.getClassType());
            this.bestMatch = SearchUserFilter.getFieldValueAsString(data);
        }
        return score;
    }

    private static String getFieldValueAsString(Object data) {
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof String[]) {
            return String.join((CharSequence)"; ", (String[])data);
        }
        return null;
    }

    public String getBestMatch() {
        return this.bestMatch;
    }

    private int addScore(String fieldToCheck, String word, boolean completeMatch) {
        if (fieldToCheck == null) {
            return 0;
        }
        if ((fieldToCheck = this.removeNonASCII(fieldToCheck)).length() < word.length()) {
            return 0;
        }
        int index = fieldToCheck.indexOf(word);
        if (index < 0) {
            return 0;
        }
        if (index == 0) {
            if (completeMatch) {
                if (word.length() == fieldToCheck.length()) {
                    return 3;
                }
                index = fieldToCheck.indexOf(64);
                if (index == word.length()) {
                    return 3;
                }
            }
            return 2;
        }
        return 1;
    }

    private String removeNonASCII(String word) {
        word = Normalizer.normalize(word, Normalizer.Form.NFD);
        word = word.toUpperCase().toLowerCase();
        StringBuilder b = new StringBuilder(word.length());
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (c >= '\u0080') continue;
            b.append(c);
        }
        return b.toString();
    }
}

