/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import java.util.Hashtable;

public class MimeTypeUtilities {
    private static Hashtable<String, String> fileMimeTyp;

    public static String getMimeTyp(String extension) {
        String retval;
        if (fileMimeTyp == null) {
            MimeTypeUtilities.loadMimeTyps();
        }
        if ((retval = fileMimeTyp.get(extension)) != null) {
            return retval;
        }
        return "application/x-unknown";
    }

    private static void loadMimeTyps() {
        fileMimeTyp = new Hashtable();
        fileMimeTyp.put("bmp", "image/bmp");
        fileMimeTyp.put("c", "text/plain");
        fileMimeTyp.put("class", "application/octet-stream");
        fileMimeTyp.put("doc", "application/doc");
        fileMimeTyp.put("docx", "application/doc");
        fileMimeTyp.put("dot", "application/doc");
        fileMimeTyp.put("dot", "application/doc");
        fileMimeTyp.put("exe", "application/octet-stream");
        fileMimeTyp.put("gif", "image/gif");
        fileMimeTyp.put("gz", "application/gz");
        fileMimeTyp.put("html", "text/html");
        fileMimeTyp.put("htm", "text/html");
        fileMimeTyp.put("h", "text/plain");
        fileMimeTyp.put("ini", "application/ini");
        fileMimeTyp.put("inf", "application/inf");
        fileMimeTyp.put("jar", "application/x-unknown");
        fileMimeTyp.put("java", "application/java");
        fileMimeTyp.put("jpg", "image/jpeg");
        fileMimeTyp.put("jpeg", "image/jpeg");
        fileMimeTyp.put("log", "application/log");
        fileMimeTyp.put("mim", "application/mim");
        fileMimeTyp.put("pcx", "application/pcx");
        fileMimeTyp.put("pdf", "application/pdf");
        fileMimeTyp.put("png", "image/png");
        fileMimeTyp.put("ppt", "application/ppt");
        fileMimeTyp.put("properties", "text/plain");
        fileMimeTyp.put("rpt", "application/rpt");
        fileMimeTyp.put("rtf", "application/rtf");
        fileMimeTyp.put("sql", "text/plain");
        fileMimeTyp.put("tar", "application/x-tar");
        fileMimeTyp.put("tif", "image/tif");
        fileMimeTyp.put("tiff", "image/tiff");
        fileMimeTyp.put("txt", "text/plain");
        fileMimeTyp.put("vsd", "application/vsd");
        fileMimeTyp.put("xls", "application/xls");
        fileMimeTyp.put("xlsx", "application/xls");
        fileMimeTyp.put("xlt", "application/xls");
        fileMimeTyp.put("xml", "application/xml");
        fileMimeTyp.put("zip", "application/x-zip-compressed");
    }
}

