/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.lib.json.Json;
import com.inet.logging.EventLog;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public enum AutoTextEventLog {
    AutoTextAdded,
    AutoTextChanged,
    AutoTextDeleted;

    private static final EventLog<AutoTextEventLog> EVENT_LOG;

    public void log(AutoTextVO autotext) {
        this.log(autotext, null);
    }

    public void log(AutoTextVO autotext, @Nullable String oldName) {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        String msg = Tickets.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[]{autotext.getLabel()});
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("Name", autotext.getLabel());
        if (oldName != null && !Objects.equals(oldName, autotext.getLabel())) {
            data.put("Old name", oldName);
            msg = Tickets.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name() + ".rename", new Object[]{autotext.getLabel(), oldName});
        }
        data.put("ID", String.valueOf(autotext.getId()));
        EVENT_LOG.log((Enum)this, userAccount, msg, new Json().toJson(data), new Object[]{autotext.getLabel()});
    }

    static {
        EVENT_LOG = EventLog.register((String)"helpdesktemplate");
    }
}

