/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.reporting.server.datasource;

import com.inet.classloader.I18nMessages;
import com.inet.field.Field;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.datasource.DataViewConditions;
import com.inet.search.command.AndSearchExpression;
import java.util.Map;
import java.util.function.Function;

public interface ITicketDataSourceConfiguration {
    public static final String PROMPT_TICKET_SEARCH_CONDITIONS = "TicketSearchPhrase";
    public static final String SPROC_TICKET_BY_ID = "TicketById";
    public static final String SPROC_TICKETS_ADHOC = "TicketAdhoc";
    public static final String COLUMN_TICKET_OWNER_ID = "ticketownerid";
    public static final String COLUMN_TICKET_TEXT = "ticketText";
    public static final String COLUMN_TICKET_TEXT_ISHTML = "ticketTextIsHtml";
    public static final String COLUMN_TICKET_PRIO_VALUE = "priorityidValue";
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.reporting.server.i18n.Translations", ITicketDataSourceConfiguration.class);

    public static AndSearchExpression buildSearchPhraseForTicketTable(DataViewConditions filter, String tableName, Map<String, DataSourceUtils.JoinTokenInfo> joinTokenInfo) {
        Function<String, Field> hasSearchtag = column -> {
            TicketField field = Tickets.getFieldByKey(column);
            if (field != null) {
                return field;
            }
            TicketAttribute att = Tickets.getAttributeByKey(column);
            if (att != null) {
                return att;
            }
            if ("ticketid".equals(column)) {
                return Tickets.ATTRIBUTE_TICKET_ID;
            }
            return null;
        };
        AndSearchExpression expression = DataSourceUtils.buildSearchPhraseExpression((DataViewConditions)filter, (String)tableName, hasSearchtag, TicketManager.getReader().getSearchEngine(), joinTokenInfo);
        return expression;
    }
}

