/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.Translator;
import com.inet.lib.json.Json;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;

@JsonData
public class TriggerListConfigProperty
extends ItemListConfigProperty {
    public static final String TRIGGER_MAIL_NEW_IN = "MAIL_NEW_IN";
    public static final String TRIGGER_MAIL_IN = "MAIL_IN";
    public static final String TRIGGER_MAIL_OUT = "MAIL_OUT";
    public static final String TRIGGER_STATUS_CHANGE = "STATUS_CHANGE";
    public static final String TRIGGER_ITIL_CHANGE = "ITIL_CHANGE";
    public static final String TRIGGER_NEW_USER_TICKET = "NEW_USER_TICKET";
    private static final String ACTION_VALIDATE_TRIGGER = "helpdesk.trigger.validate";
    static final String[] ORDERED_TRIGGERS = new String[]{"MAIL_NEW_IN", "MAIL_IN", "MAIL_OUT", "STATUS_CHANGE", "ITIL_CHANGE", "NEW_USER_TICKET"};

    public TriggerListConfigProperty(ConfigStructureSettings settings, @Nonnull Translator translator) {
        super(0, HDConfigKeys.JAVASCRIPT_TRIGGERS.getKey(), "JAVASCRIPT_TRIGGERS", TriggerListConfigProperty.getObjectListValue(settings, translator), null, new ConfigRowAction[]{TriggerListConfigProperty.getRowAction(translator)});
        this.setDeleteDisabledCondition(ConfigCondition.TRUE);
    }

    static Object getObjectListValue(ConfigStructureSettings settings, @Nonnull Translator translator) {
        ArrayList triggers;
        ArrayList changedValueRaw = (ArrayList)settings.getChangedValue(HDConfigKeys.JAVASCRIPT_TRIGGERS.getKey(), ArrayList.class);
        if (changedValueRaw != null) {
            return changedValueRaw;
        }
        String triggerValue = settings.getValue(HDConfigKeys.JAVASCRIPT_TRIGGERS);
        if (triggerValue == null || triggerValue.equals("{}")) {
            triggers = new ArrayList();
            for (String triggerName : ORDERED_TRIGGERS) {
                HashMap<String, String> entry = new HashMap<String, String>();
                entry.put("name", triggerName);
                entry.put("locName", translator.translate("TRIGGER_" + triggerName + ".label"));
                entry.put("locDetails", translator.translate("TRIGGER_" + triggerName + ".details"));
                entry.put("content", "");
                triggers.add(entry);
            }
        } else {
            triggers = (ArrayList)new Json().fromJson(triggerValue, ArrayList.class);
            for (HashMap t : triggers) {
                if (t.get("name") == null) continue;
                t.put("locName", translator.translate("TRIGGER_" + (String)t.get("name") + ".label"));
                t.put("locDetails", translator.translate("TRIGGER_" + (String)t.get("name") + ".details"));
            }
        }
        return triggers;
    }

    private static ConfigRowAction getRowAction(@Nonnull Translator translator) {
        ConfigCategory category = new ConfigCategory(0, "trigger.edit", translator.translate("JavascriptTrigger"), "ticket.settings.triggers");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "trigger.edit.group", "", new ConfigAction(ACTION_VALIDATE_TRIGGER, translator.translate("ValidateTrigger"))));
        HashMap properties = new HashMap();
        ArrayList<ConfigProperty> propertyList = new ArrayList<ConfigProperty>();
        properties.put("trigger.edit.group", propertyList);
        propertyList.add(TriggerListConfigProperty.propWith("Hidden", "TriggerName", "name", ""));
        propertyList.add(TriggerListConfigProperty.propWith("KeyLabel", translator.translate("trigger.name"), "locName", ""));
        propertyList.add(TriggerListConfigProperty.propWith("KeyLabel", translator.translate("trigger.details"), "locDetails", ""));
        propertyList.add(TriggerListConfigProperty.propWith("Label", translator.translate("trigger.limits"), "trigger.limits", ""));
        propertyList.add(TriggerListConfigProperty.propWith("MultiLineCode", translator.translate("TriggerContent"), "content", ""));
        ConfigRowAction result = new ConfigRowAction(null, null, category, propertyGroups, properties, new ArrayList());
        result.setAddMultipleEntriesAllowed(false);
        return result;
    }

    private static ConfigProperty propWith(@Nonnull String type, String label, @Nonnull String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

