/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.components;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class MinutenFeld
extends Format {
    private static final long serialVersionUID = 1L;
    public static final String EINHEIT = " h";

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number && ((Number)obj).intValue() > 0) {
            int stunden = ((Number)obj).intValue() / 60;
            int minuten = ((Number)obj).intValue() % 60;
            if (stunden < 10) {
                toAppendTo.append('0');
            }
            toAppendTo.append(stunden).append(':');
            if (minuten < 10) {
                toAppendTo.append('0');
            }
            toAppendTo.append(minuten).append(EINHEIT);
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        Integer min = null;
        try {
            int index;
            if (source.endsWith(EINHEIT)) {
                source = source.substring(0, source.length() - 2);
            }
            if ((index = source.indexOf(58)) > -1) {
                int stunde = 0;
                int minute = 0;
                if (index > 0) {
                    stunde = Integer.parseInt(source.substring(0, index));
                }
                if (index < source.length() - 1) {
                    minute = Integer.parseInt(source.substring(index + 1));
                }
                stunde = stunde > 0 ? (stunde *= 60) : 0;
                if (minute < 0) {
                    minute = 0;
                }
                min = new Integer(stunde + minute);
            } else if (source.length() > 0) {
                min = new Integer(source);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return min;
    }
}

