/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.modules;

import com.inet.dbupdater.databases.DatabaseInfoFactory;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.modules.IPatcherModul;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleFactory {
    private Map<Integer, List<IPatcherModul>> modules = new HashMap<Integer, List<IPatcherModul>>();
    private static Logger logger = LogManager.getLogger((String)"DB Updater");

    public void addModul(String dbms, IPatcherModul modul) {
        if (modul == null) {
            return;
        }
        Integer id = DatabaseInfoFactory.getDatabaseType(dbms);
        List<IPatcherModul> list = this.modules.get(id);
        if (list == null) {
            list = new ArrayList<IPatcherModul>();
            this.modules.put(id, list);
        }
        Class<?> modulClass = modul.getClass();
        for (IPatcherModul m : list) {
            if (m.getClass() != modulClass) continue;
            return;
        }
        logger.debug((Object)("Loaded module '" + modul.getClass().getName() + "' for DBMS '" + (dbms != null ? dbms : "GENERIC'")));
        list.add(modul);
    }

    public void addModul(String dbms, String classname) {
        try {
            Class<?> clazz = Class.forName(classname);
            Object instance = clazz.newInstance();
            if (instance instanceof IPatcherModul) {
                this.addModul(dbms, (IPatcherModul)instance);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public List<? extends IPatcherModul> getModulsForDBMS(String dbms) {
        ArrayList<IPatcherModul> modulList = new ArrayList<IPatcherModul>();
        Integer id = DatabaseInfoFactory.getDatabaseType(dbms);
        List<IPatcherModul> module = this.modules.get(id);
        if (module != null) {
            modulList.addAll(module);
        }
        if ((module = this.modules.get(-1)) != null) {
            modulList.addAll(module);
        }
        return modulList;
    }

    public void scanModel(Node model) {
        List<? extends Node> list;
        if (model == null) {
            return;
        }
        if (model.getName() == NodeFactory.TAG.database) {
            this.loadModulesForDatabase(model);
        }
        if (model.getName() == NodeFactory.TAG.dbupdater && (list = model.getChildren(NodeFactory.TAG.database)) != null) {
            for (Node node : list) {
                this.loadModulesForDatabase(node);
            }
        }
    }

    private void loadModulesForDatabase(Node dbNode) {
        if (dbNode == null || dbNode.getName() != NodeFactory.TAG.database) {
            return;
        }
        String dbms = dbNode.getParameter(IDatabaseInfos.DATABASE_PARAM.productname.name());
        List<? extends Node> dbModules = dbNode.getChildren(NodeFactory.TAG.modules);
        if (dbModules != null && dbms != null) {
            for (Node node : dbModules) {
                List<String> content = node.getContentLines();
                if (content == null) continue;
                for (String className : content) {
                    this.addModul(dbms, className);
                }
            }
        }
    }
}

