/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.classloader.LoaderUtils;
import com.inet.dbupdater.databases.DatabaseInfoFactory;
import com.inet.dbupdater.model.ConstructorSAX;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.SuppressFBWarnings;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    private static final Logger logger = LogManager.getLogger((String)"DB Updater");
    private int dbConstant = -1;

    public Parser(String targetDBMS) {
        this.dbConstant = DatabaseInfoFactory.getDatabaseType(targetDBMS);
    }

    public Node parse(File file) throws SAXException, IOException {
        return this.parse(new FileInputStream(file));
    }

    @SuppressFBWarnings(value={"XXE_SAXPARSER"}, justification="API can only be called with admin permissions")
    public Node parse(InputStream in) throws SAXException, IOException {
        SAXParserFactory factory = LoaderUtils.newSaxParserFactory();
        try {
            SAXParser saxParser = factory.newSAXParser();
            ConstructorSAX constructor = new ConstructorSAX(new NodeFactory(), this.dbConstant);
            InputSource is = new InputSource(in);
            is.setEncoding("UTF-8");
            saxParser.parse(is, (DefaultHandler)constructor);
            return constructor.getRoot();
        }
        catch (ParserConfigurationException e) {
            logger.error((Throwable)e);
            return null;
        }
    }
}

