/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.BaseAlterColumnCommand;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.List;

public class MySQLAlterColumnCommand
extends BaseAlterColumnCommand {
    private DatabaseInfos dbInfo;
    private final Node name;
    private final String prefix;
    private String statement;
    private boolean isAutoIncrementChange = false;

    public MySQLAlterColumnCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        super(dbInfo);
        this.name = tableName;
        this.dbInfo = dbInfo;
        this.prefix = "ALTER TABLE " + ((ISchemaNode)((Object)tableName)).getSourceName(dbInfo) + " ";
    }

    @Override
    public int execute() throws SQLException {
        if (this.isAutoIncrementChange) {
            try {
                this.dbInfo.getDBConnection().execute("SET FOREIGN_KEY_CHECKS=0");
                int n = this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
                return n;
            }
            finally {
                this.dbInfo.getDBConnection().execute("SET FOREIGN_KEY_CHECKS=1");
            }
        }
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public String getSqlStatement() {
        return this.statement;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        if (this.statement != null) {
            return false;
        }
        if (action != ICommandFactory.COMMAND_TYPE.alter) {
            return false;
        }
        NodeFactory.TAG type = element.getName();
        return type == NodeFactory.TAG.column;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.alterstructure;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        boolean isAutoIncrementChange;
        AttributeMap<String> attributes = element.getAttributeMap();
        String name = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_name);
        if (name == null) {
            throw new IllegalStateException("Cannot alter an unnamed column in table '" + String.valueOf(this.name) + "'");
        }
        String isautoincrement = element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.isautoincrement.name());
        String data_type = element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.data_type.name());
        String decimal_digits = element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.decimal_digits.name());
        String column_size = element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.column_size.name());
        String type_name = element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.type_name.name());
        String column_def = element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.column_def.name());
        String isnotnullable = element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.isnotnullable.name());
        String colName = this.dbInfo.getQuote(element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.column_name.name()));
        boolean bl = isAutoIncrementChange = action == ICommandFactory.COMMAND_TYPE.alter && isautoincrement != null && "false".equalsIgnoreCase(isautoincrement);
        if (data_type != null || isAutoIncrementChange) {
            int iData_Type = 0;
            int iSize = 0;
            int iScale = 0;
            try {
                iData_Type = Integer.parseInt(data_type);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                iSize = Integer.parseInt(column_size);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                iScale = Integer.parseInt(decimal_digits);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                iData_Type = Integer.parseInt(data_type);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String dataType = this.dbInfo.getDestDataType(iData_Type, iSize, iScale, type_name, "true".equals(isautoincrement));
            StringBuilder b = new StringBuilder();
            b.append(this.prefix);
            b.append(" MODIFY COLUMN ");
            b.append(colName).append(" ");
            b.append(dataType).append(" ");
            b.append("true".equals(isnotnullable) ? "NOT NULL" : "NULL").append(" ");
            if (column_def != null && !"#removed#".equals(column_def)) {
                if (this.dbInfo.isQuoteableDataType(iData_Type)) {
                    b.append("DEFAULT ").append(this.dbInfo.getQuotedValue(column_def.toString(), iData_Type)).append(" ");
                } else {
                    String defaultString = column_def.toString();
                    if (defaultString.length() > 0) {
                        b.append("DEFAULT ").append(this.dbInfo.getQuotedValue(defaultString, iData_Type)).append(" ");
                    }
                }
            }
            this.statement = b.toString();
            if (isAutoIncrementChange) {
                this.isAutoIncrementChange = true;
            }
        }
        return null;
    }
}

