/*
 * Decompiled with CFR 0.152.
 */
package com.inet.protocol.data;

import com.inet.html.utils.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class DataURLConnection
extends URLConnection {
    private InputStream input;
    private String contentType;

    protected DataURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        String encoding;
        if (this.connected) {
            return;
        }
        String data = this.url.getFile();
        int idx = data.indexOf(44);
        if (idx < 0) {
            throw new IOException("Wrong URL format. Missing a comma in '" + this.url + "'\nsee at http://www.ietf.org/rfc/rfc2397.txt for details.");
        }
        this.contentType = idx == 0 ? "text/plain" : data.substring(0, idx);
        data = data.substring(idx + 1);
        idx = this.contentType.indexOf(59);
        if (idx >= 0 && "base64".equalsIgnoreCase(encoding = this.contentType.substring(idx + 1))) {
            byte[] decodedData = Base64.decode(data);
            this.input = new ByteArrayInputStream(decodedData);
            this.contentType = this.contentType.substring(0, idx);
            this.connected = true;
            return;
        }
        this.input = new ByteArrayInputStream(data.getBytes("ISO-8859-1"));
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.input;
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ("content-type".equalsIgnoreCase(name)) {
            return this.contentType;
        }
        return super.getHeaderField(name);
    }
}

