/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.views.ControlView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.Layout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

public class ControlLayout
extends Layout {
    private ControlView view;
    private int width;
    private Rectangle span = new Rectangle();

    public ControlLayout(ControlView view) {
        super(view);
        this.view = view;
    }

    @Override
    public void layoutWidth() {
        JComponent control = this.view.getControlPanel();
        this.width = !this.view.getWidthUnit().isAuto() || control == null ? this.adjustWidth() : control.getPreferredSize().width;
        if (!(control instanceof JButton) && control != null && this.width > control.getMaximumSize().width) {
            this.width = control.getMaximumSize().width;
        }
        this.setCurrentWidth(this.width);
        this.view.setContentWidth(this.width - this.view.getBox().getLeftBorderPadding() - this.view.getBox().getRightBorderPadding());
    }

    @Override
    public Rectangle layout(boolean hard) {
        int height = this.adjustHeight();
        if (height < 0) {
            height = this.getPreferredHeight();
            JComponent control = this.view.getControlPanel();
            if (control != null && height > control.getMaximumSize().height) {
                height = control.getMaximumSize().height;
            }
        }
        int paddingBorderX = this.view.getBox().getLeftBorderPadding() + this.view.getBox().getRightBorderPadding();
        int paddingBordery = this.view.getBox().getTopBorderPadding() + this.view.getBox().getBottomBorderPadding();
        this.view.setSizeContent(this.width - paddingBorderX, height - paddingBordery);
        this.span.setBounds(0, 0, this.width, height);
        return this.span;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        return null;
    }

    @Override
    public void preLayout() {
        JComponent control = this.view.getControlPanel();
        if (control != null) {
            Dimension dim = control.getMinimumSize();
            Dimension max = control.getMaximumSize();
            if (this.preferredWidth > 0) {
                max.width = this.preferredWidth;
            }
            if (this.getPreferredHeight() > 0) {
                max.height = this.getPreferredHeight();
            }
            this.minimumHeight = dim.height;
            this.minimumWidth = dim.width;
            this.setPreferredHeight(Math.max(dim.height, max.height));
            this.preferredWidth = Math.max(dim.width, max.width);
        }
        this.setPreLayouted();
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        return 0;
    }

    public void setPreferredSize(int width, int height) {
        this.preferredWidth = width;
        this.setPreferredHeight(height);
    }

    @Override
    public void predictWidth(int width) {
        this.view.setSizeContent(width, this.view.getContentHeight());
    }

    @Override
    public void layoutVerticalAlign(int align, int baselineOffset) {
    }

    @Override
    public ViewPositionInfo getViewForPosition(Point position, Rectangle a) {
        return null;
    }

    @Override
    public Rectangle getSpan() {
        return this.span;
    }

    @Override
    protected void calculateCollapsedMargins() {
    }
}

