/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.CssDocument;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.MultiIntegerValue;
import com.inet.html.utils.ColorUtils;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.TableView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.List;
import javax.swing.text.Element;

public class TableBoxPainter
extends BoxPainter {
    private boolean isCollapseMode = false;
    private boolean leftIsTableBorder = false;
    private boolean rightIsTableBorder = false;
    private boolean topIsTableBorder = false;
    private boolean bottomIsTableBorder = false;
    private Insets paddingDefined;
    private Insets paintInsets;

    public TableBoxPainter(BoxView view) {
        super(view);
        StyleResolver r;
        this.paddingDefined = view.getDocument() instanceof CssDocument ? new Insets((r = ((CssDocument)view.getDocument()).getStyleResolver()).getAttributeValueNonInherit(this.getView().getElement(), AttributeFinder.PADDING_TOP) != null ? 1 : 0, r.getAttributeValueNonInherit(this.getView().getElement(), AttributeFinder.PADDING_LEFT) != null ? 1 : 0, r.getAttributeValueNonInherit(this.getView().getElement(), AttributeFinder.PADDING_BOTTOM) != null ? 1 : 0, r.getAttributeValueNonInherit(this.getView().getElement(), AttributeFinder.PADDING_RIGHT) != null ? 1 : 0) : new Insets(StyleResolver.getAttributeValue(this.getView().getElement(), AttributeFinder.PADDING_TOP) != null ? 1 : 0, StyleResolver.getAttributeValue(this.getView().getElement(), AttributeFinder.PADDING_LEFT) != null ? 1 : 0, StyleResolver.getAttributeValue(this.getView().getElement(), AttributeFinder.PADDING_BOTTOM) != null ? 1 : 0, StyleResolver.getAttributeValue(this.getView().getElement(), AttributeFinder.PADDING_RIGHT) != null ? 1 : 0);
        this.paintInsets = (Insets)this.getBorderInsets().clone();
        if (view.getParent() instanceof TableView) {
            TableView parentTable = (TableView)view.getParent();
            Element table = view.getParent().getElement();
            MultiIntegerValue cellPadding = StyleResolver.getAttributeValue(table, AttributeFinder.CELL_PADDING);
            if (cellPadding != null) {
                List<IntegerValue> paddings = cellPadding.getValues();
                int left = 0;
                int right = 0;
                int top = 0;
                int bottom = 0;
                switch (paddings.size()) {
                    case 1: {
                        top = bottom = paddings.get(0).getInt();
                        right = bottom;
                        left = bottom;
                        break;
                    }
                    case 2: {
                        left = right = paddings.get(0).getInt();
                        top = bottom = paddings.get(1).getInt();
                        break;
                    }
                    case 4: {
                        left = paddings.get(0).getInt();
                        right = paddings.get(1).getInt();
                        top = paddings.get(2).getInt();
                        bottom = paddings.get(3).getInt();
                    }
                }
                if (this.paddingDefined.left != 1) {
                    this.setPadding().left = left;
                }
                if (this.paddingDefined.right != 1) {
                    this.setPadding().right = right;
                }
                if (this.paddingDefined.top != 1) {
                    this.setPadding().top = top;
                }
                if (this.paddingDefined.bottom != 1) {
                    this.setPadding().bottom = bottom;
                }
            }
            if (parentTable.getHTMLBorderValue() > 0 && this.paintInsets.left == 0 && this.paintInsets.right == 0 && this.paintInsets.top == 0 && this.paintInsets.bottom == 0) {
                boolean singleLine;
                this.paintInsets.set(1, 1, 1, 1);
                this.setBorderInsets(new Insets(1, 1, 1, 1));
                this.setBorderStyles(new Insets(7, 7, 7, 7));
                boolean bl = singleLine = parentTable.getLayout().isBorderCollapse() && parentTable.getHTMLBorderValue() == 1;
                if (this.getBorderTopColor() == null) {
                    this.setBorderTopColor(new ColorValue(ColorUtils.get3DDark()));
                }
                if (this.getBorderLeftColor() == null) {
                    this.setBorderLeftColor(new ColorValue(ColorUtils.get3DDark()));
                }
                if (this.getBorderBottomColor() == null) {
                    this.setBorderBottomColor(new ColorValue(singleLine ? ColorUtils.get3DDark() : ColorUtils.get3DLight()));
                }
                if (this.getBorderRightColor() == null) {
                    this.setBorderRightColor(new ColorValue(singleLine ? ColorUtils.get3DDark() : ColorUtils.get3DLight()));
                }
            }
        }
    }

    public Insets getPaintInsets() {
        return this.paintInsets;
    }

    public void paintBorders(Graphics g, int x, int y, int width, int height) {
        Area lineArea;
        Polygon lineClip;
        int intLineWidth;
        int style;
        Element elem = this.getView().getElement();
        Shape clip = g.getClip();
        Area clipArea = null;
        boolean clipSet = false;
        if (this.isCollapseMode) {
            int diffTop = this.topIsTableBorder ? 0 : (int)Math.ceil((float)this.paintInsets.top / 2.0f);
            int diffBottom = this.bottomIsTableBorder ? 0 : this.paintInsets.bottom / 2;
            int diffLeft = this.leftIsTableBorder ? 0 : (int)Math.ceil((float)this.paintInsets.left / 2.0f);
            int diffRight = this.rightIsTableBorder ? 0 : this.paintInsets.right / 2;
            x -= diffLeft;
            y -= diffTop;
            width += diffLeft + diffRight;
            height += diffTop + diffBottom;
            if (clip != null) {
                Rectangle newClip = new Rectangle(x, y, width, height).intersection(clip.getBounds());
                clipArea = new Area(newClip);
            }
        } else if (clip != null) {
            clipArea = new Area(clip);
        }
        if (this.paintInsets.top > 0 && !this.isInVisibleStyle(this.getBorderStyles().top)) {
            ColorValue colorValue = this.getBorderTopColor();
            if (colorValue == null) {
                colorValue = AttributeFinder.COLOR.getAttributeValue(this.getView());
            }
            g.setColor(colorValue.getValue());
            style = this.getBorderStyles().top;
            intLineWidth = this.paintInsets.top;
            float lineWidth = intLineWidth;
            lineClip = new Polygon();
            lineClip.addPoint(x, y);
            lineClip.addPoint(x + width, y);
            lineClip.addPoint(x + width - this.paintInsets.right, y + intLineWidth);
            lineClip.addPoint(x + this.paintInsets.left, y + intLineWidth);
            lineArea = new Area(lineClip);
            if (clipArea != null) {
                lineArea.intersect(clipArea);
            }
            g.setClip(lineArea);
            clipSet = true;
            if (style == 8) {
                TableBoxPainter.drawBorderLine((Graphics2D)g, x, (float)y + (lineWidth /= 3.0f) * 2.5f, width, 0.0f, style, lineWidth * 1.01f);
            }
            TableBoxPainter.drawBorderLine((Graphics2D)g, x, (float)y + lineWidth * 0.5f, width, 0.0f, style, lineWidth * 1.01f);
        }
        if (this.paintInsets.left > 0 && !this.isInVisibleStyle(this.getBorderStyles().left)) {
            ColorValue colorValue = this.getBorderLeftColor();
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(elem, AttributeFinder.COLOR);
            }
            g.setColor(colorValue.getValue());
            style = this.getBorderStyles().left;
            intLineWidth = this.paintInsets.left;
            float lineWidth = intLineWidth;
            lineClip = new Polygon();
            lineClip.addPoint(x, y);
            lineClip.addPoint(x, y + height);
            lineClip.addPoint(x + intLineWidth, y + height - this.paintInsets.bottom);
            lineClip.addPoint(x + intLineWidth, y + this.paintInsets.top);
            lineArea = new Area(lineClip);
            if (clipArea != null) {
                lineArea.intersect(clipArea);
            }
            g.setClip(lineArea);
            clipSet = true;
            if (style == 8) {
                TableBoxPainter.drawBorderLine((Graphics2D)g, (float)x + (lineWidth /= 3.0f) * 2.5f, y, 0.0f, height, style, lineWidth * 1.01f);
            }
            TableBoxPainter.drawBorderLine((Graphics2D)g, (float)x + lineWidth * 0.5f, y, 0.0f, height, style, lineWidth * 1.01f);
        }
        if (this.paintInsets.bottom > 0 && !this.isInVisibleStyle(this.getBorderStyles().bottom)) {
            ColorValue colorValue = this.getBorderBottomColor();
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(elem, AttributeFinder.COLOR);
            }
            g.setColor(colorValue.getValue());
            style = this.getBorderStyles().bottom;
            intLineWidth = this.paintInsets.bottom;
            float lineWidth = intLineWidth;
            lineClip = new Polygon();
            lineClip.addPoint(x, y + height);
            lineClip.addPoint(x + width, y + height);
            lineClip.addPoint(x + width - this.paintInsets.right, y + height - intLineWidth);
            lineClip.addPoint(x + this.paintInsets.left, y + height - intLineWidth);
            lineArea = new Area(lineClip);
            if (clipArea != null) {
                lineArea.intersect(clipArea);
            }
            g.setClip(lineArea);
            clipSet = true;
            if (style == 8) {
                TableBoxPainter.drawBorderLine((Graphics2D)g, x, (float)(y + height) - (lineWidth /= 3.0f) * 2.5f, width, 0.0f, style, lineWidth * 1.01f);
            }
            TableBoxPainter.drawBorderLine((Graphics2D)g, x, (float)(y + height) - lineWidth * 0.5f, width, 0.0f, style, lineWidth * 1.01f);
        }
        if (this.paintInsets.right > 0 && !this.isInVisibleStyle(this.getBorderStyles().right)) {
            ColorValue colorValue = this.getView().getBorderRightColor();
            if (colorValue == null) {
                colorValue = StyleResolver.getAttributeValue(elem, AttributeFinder.COLOR);
            }
            g.setColor(colorValue.getValue());
            style = this.getBorderStyles().right;
            intLineWidth = this.paintInsets.right;
            float lineWidth = intLineWidth;
            lineClip = new Polygon();
            lineClip.addPoint(x + width, y);
            lineClip.addPoint(x + width, y + height);
            lineClip.addPoint(x + width - intLineWidth, y + height - this.paintInsets.bottom);
            lineClip.addPoint(x + width - intLineWidth, y + this.paintInsets.top);
            lineArea = new Area(lineClip);
            if (clipArea != null) {
                lineArea.intersect(clipArea);
            }
            g.setClip(lineArea);
            clipSet = true;
            if (style == 8) {
                TableBoxPainter.drawBorderLine((Graphics2D)g, (float)(x + width) - (lineWidth /= 3.0f) * 2.5f, y, 0.0f, height, style, lineWidth * 1.01f);
            }
            TableBoxPainter.drawBorderLine((Graphics2D)g, (float)(x + width) - lineWidth * 0.5f, y, 0.0f, height, style, lineWidth * 1.01f);
        }
        if (clipSet) {
            g.setClip(clip);
        }
    }

    @Override
    public void paint(Graphics g, int x, int y, int width, int height, int paintMode, BoxView paintRef) {
    }

    public void setCollapseMode(boolean isCollapseMode) {
        this.isCollapseMode = isCollapseMode;
    }

    public Insets getPaddingDefined() {
        return this.paddingDefined;
    }

    public void setLeftIsTableBorder(boolean leftIsTableBorder) {
        this.leftIsTableBorder = leftIsTableBorder;
    }

    public void setRightIsTableBorder(boolean rightIsTableBorder) {
        this.rightIsTableBorder = rightIsTableBorder;
    }

    public void setTopIsTableBorder(boolean topIsTableBorder) {
        this.topIsTableBorder = topIsTableBorder;
    }

    public void setBottomIsTableBorder(boolean bottomIsTableBorder) {
        this.bottomIsTableBorder = bottomIsTableBorder;
    }
}

