/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.CssDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.FontFamily;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.TextDecoration;
import com.inet.html.utils.DOMUtils;
import com.inet.html.utils.Logger;
import com.inet.html.utils.ViewUtils;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentPainter;
import com.inet.html.views.IBoxPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ContentView
extends BoxView
implements Cloneable {
    private Font font;
    private BoxPainter[] painters;
    private boolean useSymbolTransform = false;
    private Color underLineColor;
    private Color overLineColor;
    private Color throughLineColor;
    private short letterSpacing;
    private char[] symbolContent = null;
    private String symbolContentString = null;
    private Color textColor;
    private boolean isBreakable = false;
    private int cjkType = 0;
    public static final int CJK_TYPE_NONE = 0;
    public static final int CJK_TYPE_PUNCTUATION = 1;
    public static final int CJK_TYPE_CHARACTER = 2;
    private ContentPainter painter;
    private int baseline;

    public ContentView(Element elem) {
        super(elem);
        this.painter = new ContentPainter(this);
    }

    public ContentView(Element elem, ViewPainter painter) {
        super(elem, painter);
        this.painter = new ContentPainter(this);
    }

    public ContentView(Element elem, ViewPainter painter, ContentPainter contentPainter) {
        super(elem, painter);
        this.painter = contentPainter;
        contentPainter.setView(this);
    }

    @Override
    public void setParent(View parent) {
        LengthUnit spacingValue;
        Element parentElement;
        if (this.getParent() != null && this.getParent() == parent) {
            return;
        }
        super.setParent(parent);
        if (parent == null) {
            this.font = null;
            this.painters = null;
            this.overLineColor = null;
            this.underLineColor = null;
            this.throughLineColor = null;
            this.painter.reset();
            return;
        }
        Element node = this.getElement();
        if (!((CssDocument)this.getDocument()).readStylesOfVirtualTags() && node.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT) {
            node = node.getParentElement();
        }
        if ((parentElement = parent.getElement()).getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) {
            parentElement = parentElement.getParentElement();
        }
        ArrayList<IBoxPainter> painterList = null;
        while (node != parentElement && node != null) {
            TextDecoration dec;
            IBoxPainter boxPainter = BoxPainter.createBoxPainter((BoxView)parent, this, node);
            if (boxPainter.isRelevant()) {
                if (painterList == null) {
                    painterList = new ArrayList<IBoxPainter>();
                }
                painterList.add(boxPainter);
            }
            if ((dec = StyleResolver.getAttributeValue(node, AttributeFinder.TEXT_DECORATION)) != null && dec.getDecoration() != 0) {
                ColorValue colorValue = StyleResolver.getAttributeValue(node, AttributeFinder.COLOR);
                Color color = colorValue != null ? colorValue.getValue() : null;
                int decoration = dec.getDecoration();
                if ((decoration & 4) != 0) {
                    Color color2 = this.throughLineColor = this.throughLineColor == null ? color : this.throughLineColor;
                }
                if ((decoration & 1) != 0) {
                    Color color3 = this.underLineColor = this.underLineColor == null ? color : this.underLineColor;
                }
                if ((decoration & 2) != 0) {
                    this.overLineColor = this.overLineColor == null ? color : this.overLineColor;
                }
            }
            node = node.getParentElement();
        }
        TextDecoration dec = StyleResolver.getAttributeValue(parentElement, AttributeFinder.TEXT_DECORATION);
        if (dec != null && dec.getDecoration() != 0) {
            ColorValue colorValue = StyleResolver.getAttributeValue(parentElement, AttributeFinder.COLOR);
            Color color = colorValue != null ? colorValue.getValue() : null;
            int decoration = dec.getDecoration();
            if ((decoration & 4) != 0) {
                Color color4 = this.throughLineColor = this.throughLineColor == null ? color : this.throughLineColor;
            }
            if ((decoration & 1) != 0) {
                Color color5 = this.underLineColor = this.underLineColor == null ? color : this.underLineColor;
            }
            if ((decoration & 2) != 0) {
                Color color6 = this.overLineColor = this.overLineColor == null ? color : this.overLineColor;
            }
        }
        if (painterList != null && painterList.size() > 0) {
            this.painters = new BoxPainter[painterList.size()];
            painterList.toArray(this.painters);
        }
        if ((spacingValue = StyleResolver.getAttributeValue(parentElement, AttributeFinder.LETTER_SPACING)) != null) {
            this.letterSpacing = (short)spacingValue.calculateValue(0.0f, this);
            if (this.letterSpacing != 0) {
                HashMap<TextAttribute, Float> map = new HashMap<TextAttribute, Float>();
                map.put(TextAttribute.TRACKING, Float.valueOf((float)this.letterSpacing / this.font.getSize2D()));
                this.font = this.font.deriveFont(map);
            }
        }
    }

    @Override
    protected void setPropertiesFromAttributes(boolean inline) {
        FontFamily obj;
        if (this.getParent() == null) {
            return;
        }
        super.setPropertiesFromAttributes(true);
        if (this.font == null) {
            this.font = this.getRenderContext().getFont(this, false);
        }
        if ((obj = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.FONT_FAMILY)) != null) {
            this.useSymbolTransform = obj.isSymbolic() && this.getRenderContext().isFontFallbackAllowed();
        }
        this.getContentPainter().sync();
        ColorValue colorValue = AttributeFinder.COLOR.getAttributeValue(this);
        this.textColor = colorValue != null ? colorValue.getValue() : Color.BLACK;
    }

    @Override
    protected void setBlockProperties() {
    }

    @Override
    public void setSize(float newWidth, float newHeight) {
    }

    @Override
    public void setSizeContent(float newWidth, float newHeight) {
    }

    public boolean isUseSymbolTransform() {
        return this.useSymbolTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public View createFragment(int start, int end) {
        try {
            ContentView v = (ContentView)this.clone();
            v.setStartAndEndOffset(start, end);
            if (this.getRenderContext().isRefreshFontRequiredOnSplit()) {
                v.font = this.getRenderContext().getFont(v, false);
            }
            try {
                String text = v.getText();
                if (text == null) return v;
                if (!v.useSymbolTransform) {
                    if (v.font.canDisplayUpTo(text) < 0) return v;
                    if (!this.getRenderContext().isFontFallbackAllowed()) return v;
                }
                char[] symbolText = FontFamily.translateSymbolic(text.toCharArray());
                if (v.useSymbolTransform && v.font.canDisplayUpTo(symbolText, 0, symbolText.length) < 0) {
                    v.symbolContent = symbolText;
                    ContentView contentView = v;
                    return contentView;
                }
                Font newFont = this.getRenderContext().getFont(v, true);
                if (newFont != null) {
                    v.font = newFont;
                    v.symbolContent = null;
                    ContentView contentView = v;
                    return contentView;
                }
                if (!v.useSymbolTransform && v.font.canDisplayUpTo(symbolText, 0, symbolText.length) < 0) {
                    v.symbolContent = symbolText;
                    ContentView contentView = v;
                    return contentView;
                }
                v.symbolContent = symbolText;
                newFont = this.getRenderContext().getFont(v, true);
                if (newFont != null) {
                    v.font = newFont;
                    return v;
                }
                v.symbolContent = null;
                return v;
            }
            catch (BadLocationException e) {
                if (!Logger.doesLog(1)) return v;
                Logger.error(e);
                return v;
            }
            finally {
                v.setPropertiesFromAttributes(true);
                v.performPreLayout();
            }
        }
        catch (CloneNotSupportedException ex) {
            if (!Logger.doesLog(1)) return this;
            Logger.error(ex);
            return this;
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        switch (axis) {
            case 0: {
                return this.getContentWidth();
            }
            case 2: {
                return this.baseline;
            }
        }
        return this.getContentHeight();
    }

    @Override
    public void performPreLayout() {
        if (this.getStatus() != 2) {
            return;
        }
        this.getContentPainter().sync();
        this.baseline = this.getContentPainter().getAscent();
        float width = this.getContentPainter().getSpan();
        int height = this.getContentPainter().getHeight();
        super.setSizeContent(width, height);
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (axis == 0) {
            if (this.getCJKType() == 2) {
                return this.getTextLength() > 0 ? this.getContentPainter().getCharOffsets()[1] : 0.0f;
            }
            return this.getPreferredSpan(axis);
        }
        return super.getMinimumSpan(axis);
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        return this.getContentPainter().modelToView(pos, b, a);
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        return this.getContentPainter().viewToModel(x, y, a, biasReturn);
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        if (this.getVisibility() != 0) {
            return;
        }
        Rectangle rect = (Rectangle)allocation;
        if (g.getClip() != null && !g.getClip().intersects(rect)) {
            return;
        }
        if (this.isCanceledByPainter(g, allocation)) {
            return;
        }
        try {
            if (this.painters != null && this.painters.length > 0) {
                for (int i = this.painters.length - 1; i >= 0; --i) {
                    BoxPainter painter = this.painters[i];
                    rect.y -= painter.getTopBorderPadding();
                    rect.height += painter.getTopBorderPadding() + painter.getBottomBorderPadding();
                    painter.paint(g, rect, i == 0 ? this.getTopPainterType() : 2, this);
                    rect.y += painter.getTopBorderPadding();
                    rect.height -= painter.getTopBorderPadding() + painter.getBottomBorderPadding();
                }
            }
            JEditorPane textContainer = this.getRenderContext().getTextContainer();
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            int hlStart = -1;
            int hlEnd = -1;
            if (!this.isMarker() && (hlStart = this.getRenderContext().getSelectionStart()) == (hlEnd = this.getRenderContext().getSelectionEnd())) {
                hlStart = -1;
                hlEnd = -1;
            }
            Color selectionColor = null;
            if (textContainer != null && !this.isMarker()) {
                Highlighter highlighter = textContainer.getHighlighter();
                if (highlighter instanceof LayeredHighlighter) {
                    ((LayeredHighlighter)highlighter).paintLayeredHighlights(g, start, end, allocation, textContainer, this);
                }
                selectionColor = textContainer.getSelectedTextColor();
            }
            String text = this.getText();
            int yOffset = (int)this.getPreferredSpan(2);
            if (text != null) {
                g.setFont(this.font);
                Shape oldclip = null;
                if (hlStart < end && hlEnd >= start && selectionColor != null && this.getRenderContext().paintSelection() && selectionColor.getRGB() != this.textColor.getRGB()) {
                    oldclip = g.getClip();
                    float[] charOffsets = this.getContentPainter().getCharOffsets();
                    int textLen = this.getTextLength();
                    int gap1Offset = start < hlStart ? hlStart - start : 0;
                    int gap2Offset = end > hlEnd ? hlEnd - start : textLen;
                    float gap1Pos = charOffsets[gap1Offset];
                    float gap2Pos = charOffsets[gap2Offset];
                    Rectangle rLeft = null;
                    Rectangle rHighlight = null;
                    Rectangle rRight = null;
                    rHighlight = new Rectangle(rect.x + Math.round(Math.min(gap1Pos, gap2Pos)), rect.y, Math.round(Math.abs(gap2Pos - gap1Pos)), rect.height);
                    if (oldclip != null) {
                        rHighlight = rHighlight.intersection(oldclip.getBounds());
                    }
                    if (gap1Offset > 0) {
                        rLeft = new Rectangle(rect.x, rect.y, Math.round(Math.min(gap2Pos, gap1Pos)), rect.height);
                        if (oldclip != null) {
                            rLeft = rLeft.intersection(oldclip.getBounds());
                        }
                    }
                    if (gap2Offset < textLen) {
                        int offset = Math.round(Math.max(gap1Pos, gap2Pos));
                        rRight = new Rectangle(rect.x + offset, rect.y, (int)(charOffsets[textLen] - (float)offset), rect.height);
                        if (oldclip != null) {
                            rRight = rRight.intersection(oldclip.getBounds());
                        }
                    }
                    g.setColor(selectionColor);
                    g.setClip(rHighlight);
                    if (hlStart > start || hlEnd < end) {
                        this.drawTextDecorations(g, yOffset + rect.y, rHighlight.x, rHighlight.width, selectionColor);
                    }
                    this.getContentPainter().paint(g, rect, 0, text.length(), yOffset);
                    if (rLeft != null && rRight != null) {
                        g.setColor(this.textColor);
                        g.setClip(rLeft);
                        this.getContentPainter().paint(g, allocation, 0, text.length(), yOffset);
                        if (this.getRenderContext().paintSelection()) {
                            this.drawTextDecorations(g, rect.y + yOffset, rLeft.x, rLeft.width, null);
                        }
                        g.setClip(rRight);
                    } else {
                        g.setClip(rLeft != null ? rLeft : rRight);
                    }
                }
                if (oldclip == null || hlStart > start || hlEnd < end) {
                    g.setColor(this.textColor);
                    this.getContentPainter().paint(g, allocation, 0, text.length(), yOffset);
                    Rectangle bounds = oldclip != null ? g.getClipBounds() : allocation.getBounds();
                    this.drawTextDecorations(g, rect.y + yOffset, bounds.x, bounds.width, null);
                }
                if (hlStart <= start && hlEnd >= end && selectionColor != null && this.getRenderContext().paintSelection()) {
                    this.drawTextDecorations(g, rect.y + yOffset, rect.x, rect.width, selectionColor);
                }
                if (oldclip != null) {
                    g.setClip(oldclip);
                }
            } else if (hlStart <= start && hlEnd >= end && selectionColor != null && this.getRenderContext().paintSelection()) {
                this.drawTextDecorations(g, rect.y + yOffset, rect.x, rect.width, selectionColor);
            } else {
                this.drawTextDecorations(g, rect.y + yOffset, rect.x, rect.width, null);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace(System.err);
        }
    }

    public int getTextLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    private void drawTextDecorations(Graphics g, int yOffset, float startX, float lineWidth, Color override) {
        if (!(this.overLineColor == null && this.underLineColor == null && this.throughLineColor == null || this.getTopPainterType() != 2 && this.getTopPainterType() != 0)) {
            float topY;
            float height;
            float ascent;
            LineMetrics metrics = this.font.getLineMetrics(" ", this.getRenderContext().getFontRenderContext());
            if (this.overLineColor != null) {
                ascent = metrics.getAscent();
                height = metrics.getUnderlineThickness();
                topY = (float)yOffset - ascent;
                g.setColor(override == null ? this.overLineColor : override);
                BoxPainter.drawBorderLine((Graphics2D)g, startX, topY, lineWidth, 0.0f, 7, height);
            }
            if (this.throughLineColor != null) {
                ascent = metrics.getAscent();
                height = metrics.getStrikethroughThickness();
                topY = (float)yOffset + metrics.getStrikethroughOffset();
                g.setColor(override == null ? this.throughLineColor : override);
                BoxPainter.drawBorderLine((Graphics2D)g, startX, topY, lineWidth, 0.0f, 7, height);
            }
            if (this.underLineColor != null) {
                height = metrics.getUnderlineThickness();
                topY = (float)yOffset + metrics.getUnderlineOffset();
                g.setColor(override == null ? this.underLineColor : override);
                BoxPainter.drawBorderLine((Graphics2D)g, startX, topY, lineWidth, 0.0f, 7, height);
            }
        }
    }

    protected int getTopPainterType() {
        return 2;
    }

    protected String getText() throws BadLocationException {
        if (this.symbolContent == null) {
            Document doc = this.getDocument();
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            return doc.getText(start, end - start);
        }
        if (this.symbolContentString == null) {
            this.symbolContentString = new String(this.symbolContent);
        }
        return this.symbolContentString;
    }

    protected Segment getSegment() throws BadLocationException {
        if (this.symbolContent == null) {
            Document doc = this.getDocument();
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            Segment segment = new Segment();
            doc.getText(start, end - start, segment);
            return segment;
        }
        return new Segment(this.symbolContent, 0, this.symbolContent.length);
    }

    @Override
    public int getLeftInset() {
        return 0;
    }

    @Override
    public boolean isBlock() {
        return false;
    }

    @Override
    public int getRightInset() {
        return 0;
    }

    @Override
    public int getTopInset() {
        return 0;
    }

    @Override
    public int getBottomInset() {
        return 0;
    }

    @Override
    public Insets getMargins() {
        return this.getBox().getMargins();
    }

    public String paramString() {
        return "Content(" + (this.getElement() != null ? this.getElement().toString() : "No Element").trim() + ") " + this.getStartOffset() + "," + this.getEndOffset();
    }

    @Override
    public Rectangle performLayout(boolean hard) {
        return null;
    }

    @Override
    public void performLayoutWidth() {
    }

    @Override
    public void performLayoutVAlign(int baseline) {
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, f);
        if (Logger.doesLog(4)) {
            Logger.debug("ContentView:insertUpdate");
        }
        int start = ViewUtils.getOffset(e);
        int end = start + ViewUtils.getLength(e);
        int contentStart = this.getStartOffset();
        int contentEnd = this.getEndOffset();
        if (Logger.doesLog(4) && (start >= contentStart && start < contentEnd || end > contentStart && end < contentEnd)) {
            Logger.debug("Change in View " + this);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        ContentView view = (ContentView)super.clone();
        view.symbolContent = null;
        view.symbolContentString = null;
        view.changeOnlyParent(this.getParent());
        if (this.getPainter() != null) {
            view.setPainter((ViewPainter)this.getPainter().clone());
        }
        view.painter = this.painter.copy(view);
        return view;
    }

    @Override
    public boolean isBreakable() {
        return this.isBreak() || this.isBreakable && !this.isNativePre();
    }

    public void setBreakable(boolean isBreakable) {
        this.isBreakable = isBreakable;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void setIsNativeLTR(boolean isLTR) {
        super.setIsNativeLTR(isLTR);
        if (!isLTR) {
            this.getContentPainter().setReversed();
            try {
                int i;
                Segment seg = this.getSegment();
                boolean hasMirrored = false;
                for (i = seg.getBeginIndex(); i < seg.getEndIndex(); ++i) {
                    if (!Character.isMirrored(seg.array[i])) continue;
                    hasMirrored = true;
                    break;
                }
                if (hasMirrored) {
                    this.symbolContent = new char[seg.getEndIndex() - seg.getBeginIndex()];
                    if (hasMirrored) {
                        for (i = seg.getBeginIndex(); i < seg.getEndIndex(); ++i) {
                            this.symbolContent[i - seg.getBeginIndex()] = ViewUtils.getMirroredCharacter(seg.array[i]);
                        }
                    }
                    this.symbolContentString = null;
                }
            }
            catch (BadLocationException e) {
                Logger.error(e);
            }
        }
    }

    public String toString() {
        try {
            return "Content(" + this.getStartOffset() + ":" + this.getEndOffset() + "): " + this.getText();
        }
        catch (BadLocationException e) {
            return "Content: " + this.getStartOffset() + ":" + this.getEndOffset();
        }
    }

    public ContentPainter getContentPainter() {
        return this.painter;
    }

    public int getCJKType() {
        return this.cjkType;
    }

    public void setCJKType(int cjkType) {
        this.cjkType = cjkType;
    }

    @Override
    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createBoxPainter(this, this.getElement());
    }

    public short getLetterSpacing() {
        return this.letterSpacing;
    }

    protected boolean isNativePre() {
        switch (this.getWhiteSpace()) {
            case 0: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getVisibleDOM(Rectangle2D clip, DOMUtils.ResultMap result) {
        if (this.getPainter() != null && this.getPainter().wasPainted()) {
            return false;
        }
        int h = this.getOuterHeight();
        boolean partial = false;
        if (clip.getHeight() < 0.0 || clip.getMinY() > (double)h || clip.getMaxY() < (double)h) {
            if (!Boolean.TRUE.equals(result.getProperty(DOMUtils.ClippingProperty.FirstLineRendered))) {
                partial = true;
                result.setLastVisibleContentLocation(-clip.getY() + clip.getHeight());
                result.setFirstClippedContentLocation(-clip.getY() + clip.getHeight());
            } else {
                if (result.isSet(DOMUtils.ClippingProperty.WholeContentOnly)) {
                    result.setFirstClippedContentLocation(-clip.getY());
                    return false;
                }
                partial = true;
                result.setLastVisibleContentLocation(-clip.getY() + clip.getHeight());
                result.setFirstClippedContentLocation(-clip.getY());
            }
        } else {
            result.setLastVisibleContentLocation(-clip.getY() + (double)h);
        }
        DOMUtils.DOMVisibilityResult res = (DOMUtils.DOMVisibilityResult)result.get(this.getElement());
        if (res == null) {
            res = new DOMUtils.DOMVisibilityResult();
            result.put(this.getElement(), res);
        }
        res.addVisibleArea(this, partial);
        return true;
    }
}

