/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.ViewPainter;
import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.ListPositionValue;
import com.inet.html.utils.DOMUtils;
import com.inet.html.views.ContentView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;

public class BulletView
extends ContentView {
    private int height = 16;
    private int width = 8;
    private int offset = 0;
    private final int listType;
    private Color textColor;
    private static final Stroke CIRCLE_STROKE = new BasicStroke(1.0f, 1, 1);

    public BulletView(Element elem, int listType) {
        super(elem);
        this.listType = listType;
    }

    public BulletView(Element elem, int listType, ViewPainter painter) {
        super(elem, painter);
        this.listType = listType;
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent == null) {
            return;
        }
        super.performPreLayout();
        float parentSize = super.getPreferredSpan(1);
        this.height = (int)parentSize;
        float currentFontSize = this.getFontSize();
        if ((float)this.height < parentSize) {
            this.height = (int)currentFontSize;
        }
        this.width = (int)Math.ceil((double)this.height / 4.0);
        ListPositionValue listPosition = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.LIST_STYLE_POSITION);
        if (listPosition != null && listPosition.getType() == 1) {
            this.offset += this.width;
        }
        this.setContentWidth(this.width + this.offset);
        ColorValue colorValue = AttributeFinder.COLOR.getAttributeValue(this);
        this.textColor = colorValue != null ? colorValue.getValue() : Color.BLACK;
        this.setSizeContent(this.width + this.offset, this.height);
    }

    @Override
    public Rectangle performLayout(boolean hard) {
        return null;
    }

    @Override
    public void performLayoutVAlign(int baseline) {
    }

    @Override
    public void performLayoutWidth() {
    }

    @Override
    public void performPreLayout() {
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (axis == 0) {
            return this.width + this.offset;
        }
        if (axis == 2) {
            return super.getPreferredSpan(axis);
        }
        return super.getPreferredSpan(axis);
    }

    @Override
    public float getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public boolean isMarker() {
        return true;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Rectangle rect = (Rectangle)allocation;
        if (g.getClip() != null && !g.getClip().intersects(rect)) {
            return;
        }
        if (this.isCanceledByPainter(g, allocation)) {
            return;
        }
        int x = rect.x;
        int baseline = (int)this.getPreferredSpan(2);
        int yOffset = baseline - (int)Math.ceil((double)this.getContentPainter().getAscent() / 2.25);
        if (yOffset > baseline - this.width) {
            yOffset = baseline - this.width;
        }
        int y = rect.y + Math.min(yOffset, yOffset);
        g.setColor(this.textColor);
        boolean isG2D = false;
        Object oldAAValue = null;
        if (g instanceof Graphics2D) {
            oldAAValue = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setStroke(CIRCLE_STROKE);
            isG2D = true;
        }
        switch (this.listType) {
            case 2: {
                g.fillRect(x, y, this.width, this.width);
                break;
            }
            case 1: {
                g.drawOval(x, y, this.width, this.width);
                break;
            }
            default: {
                g.fillOval(x, y, this.width, this.width);
            }
        }
        if (isG2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAValue != null ? oldAAValue : RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        return null;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        return -1;
    }

    @Override
    protected String getText() throws BadLocationException {
        return null;
    }

    @Override
    public boolean getVisibleDOM(Rectangle2D clip, DOMUtils.ResultMap result) {
        return clip.getMaxY() > 0.0;
    }
}

