/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.CssDocument;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlFactory;
import com.inet.html.ViewPainter;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.Styles;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.event.AttributeUndoableEdit;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.BackgroundPosition;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ListPositionValue;
import com.inet.html.parser.converter.ListStyleType;
import com.inet.html.parser.converter.TransformValue;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.utils.DOMUtils;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.JWebEngineLicense;
import com.inet.html.utils.Logger;
import com.inet.html.utils.ViewUtils;
import com.inet.html.views.BoxView;
import com.inet.html.views.ContentView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.InlineView;
import com.inet.html.views.layouts.BlockLayout;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.InlineLayout;
import com.inet.html.views.layouts.Layout;
import com.inet.html.views.layouts.NoLayout;
import com.inet.html.views.layouts.StackManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class BlockView
extends BoxView
implements Cloneable,
ILayouted {
    private static final BoxView[] EMPTY_VIEWS = new BoxView[0];
    private static final ArrayList<Element> VIEW_REBUILT = new ArrayList(0);
    private Layout layout;
    private int viewCount;
    private BoxView[] views = EMPTY_VIEWS;
    private AtomicInteger listValue;
    private StackManager floatManager;
    private LengthUnit textIndent;
    private Insets collapsedMargins = new Insets(0, 0, 0, 0);
    private HTML.Tag tag;
    private Rectangle span;
    private static boolean userMarker = true;
    private static Image backgroundImage = null;
    private static final int IMG_WIDTH = 600;
    private static final int IMG_HEIGHT = 130;
    private static final ElementComparator ELEM_COMPARE = new ElementComparator();
    private boolean isBodyDependentRelative = false;
    private boolean hasTransform = false;
    private boolean isQuirks = false;

    public BlockView(Element elem) {
        super(elem);
        if (userMarker && backgroundImage == null) {
            this.renderBGImage();
        }
        this.setTag(elem);
    }

    public BlockView(Element elem, ViewPainter painter) {
        super(elem, painter);
        if (userMarker && backgroundImage == null) {
            this.renderBGImage();
        }
        this.setTag(elem);
    }

    private void setTag(Element elem) {
        if (elem != null) {
            Document document;
            Object attribute = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (attribute instanceof HTML.Tag) {
                this.tag = (HTML.Tag)((Object)attribute);
            }
            if ((document = elem.getDocument()) instanceof InetHtmlDocument) {
                this.isQuirks = ((InetHtmlDocument)document).getDocType().isLooseType();
            }
        }
    }

    public AtomicInteger getListValue() {
        if (this.listValue != null) {
            return this.listValue;
        }
        IntegerValue listStart = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.START);
        this.listValue = listStart != null ? new AtomicInteger(listStart.getInt()) : new AtomicInteger(1);
        return this.listValue;
    }

    @Override
    public void setParent(View parent) {
        ViewFactory factory;
        LengthUnit parentHeight;
        if (this.getParent() != null && this.getParent() == parent) {
            return;
        }
        if (parent == null) {
            if (this.isPositionRoot() && this.floatManager != null) {
                this.floatManager.clear();
            }
            this.layout = null;
            this.removeAll();
            if (this.isBodyDependentRelative) {
                this.getRenderContext().registerRelativeHeight(false);
            }
            super.setParent(null);
            return;
        }
        super.setParent(parent);
        if (this.getHeightUnit() != null && this.getHeightUnit().getType() == 1 && this.getDisplay() != 2 && parent instanceof ILayouted && ((parentHeight = ((BoxView)parent).getHeightUnit()) == null || parentHeight.isAuto())) {
            this.getRenderContext().registerRelativeHeight(true);
            this.isBodyDependentRelative = true;
        }
        if (this.tag == HTML.Tag.BODY) {
            this.getRenderContext().setBodyHeightFixed(this.getHeightUnit() != null && !this.getHeightUnit().isAuto() && this.getHeightUnit().getType() != 1);
        }
        if (InetHtmlDocument.isReady()) {
            userMarker = false;
            backgroundImage = null;
        }
        if ((factory = this.getViewFactory()) == null || this.getViewCount() > 1 || this.getViewCount() > 0 && !((BoxView)this.getView(0)).isMarker()) {
            for (int i = 0; i < this.getViewCount(); ++i) {
                if (Logger.doesLog(1) && this.getView(i) == null) {
                    Logger.error("SubView " + i + " is null in view " + this.getElement());
                }
                this.getView(i).setParent(this);
            }
            this.layout = new NoLayout(this);
            return;
        }
        Element elem = this.getElement();
        int n = elem.getElementCount();
        if (n > 0) {
            View[] newViews;
            ArrayList<BoxView> inlineBoxes = new ArrayList<BoxView>();
            ArrayList<BoxView> blocks = new ArrayList<BoxView>(n);
            BoxView marker = null;
            boolean isInsideMarker = false;
            if (this.getDisplay() == 4) {
                int listStyle = 18;
                ListStyleType listStyleValue = StyleResolver.getAttributeValue(elem, AttributeFinder.LIST_STYLE_TYPE);
                if (listStyleValue != null) {
                    listStyle = listStyleValue.getType();
                }
                UriValue image = StyleResolver.getAttributeValue(elem, AttributeFinder.LIST_STYLE_IMAGE);
                if (listStyle != 18 || image != null && !image.isNone()) {
                    ListPositionValue markerPos;
                    AtomicInteger parentListValue = ((BlockView)parent).getListValue();
                    IntegerValue currentValue = StyleResolver.getAttributeValue(elem, AttributeFinder.VALUE);
                    if (currentValue != null) {
                        parentListValue.set(currentValue.getInt());
                    }
                    isInsideMarker = (markerPos = StyleResolver.getAttributeValue(elem, AttributeFinder.LIST_STYLE_POSITION)) != null && markerPos.getType() == 1;
                    marker = ((InetHtmlFactory)this.getViewFactory()).createListItem(this, parentListValue.getAndIncrement());
                    marker.setRoot(this.getHTMLRoot());
                }
            }
            if (this.getViewCount() > 1 && ((BoxView)this.getView(0)).isMarker()) {
                marker = (BoxView)this.getView(0);
                this.remove(0);
                isInsideMarker = true;
            }
            for (int i = 0; i < n; ++i) {
                this.addContentViews(elem.getElement(i), inlineBoxes, blocks, false);
            }
            if (blocks.size() > 0) {
                this.checkIfAnonymousBlockNeeded(inlineBoxes, blocks);
                if (marker != null) {
                    if (isInsideMarker && blocks.size() > 0 && blocks.get(0).getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) {
                        blocks.get(0).insert(0, marker);
                    } else {
                        blocks.add(0, marker);
                    }
                }
                this.layout = new BlockLayout(this);
                newViews = new View[blocks.size()];
                blocks.toArray(newViews);
            } else {
                if (marker != null) {
                    inlineBoxes.add(0, marker);
                }
                this.layout = new InlineLayout(this);
                newViews = new View[inlineBoxes.size()];
                inlineBoxes.toArray(newViews);
            }
            this.replace(this.getViewCount(), 0, newViews);
        } else if (this.layout == null) {
            this.layout = new NoLayout(this);
        }
    }

    @Override
    Insets getBaseInsets(int type, int reference, Element refElement) {
        Insets insets = super.getBaseInsets(type, reference, refElement);
        if (this.isQuirks && type == 2 && this.tag != null && refElement == this.getElement()) {
            block0 : switch (this.tag) {
                case P: 
                case DL: 
                case BLOCKQUOTE: 
                case H1: 
                case H2: 
                case H3: 
                case H4: 
                case H5: 
                case H6: 
                case LI: 
                case PRE: 
                case UL: 
                case MENU: 
                case DIR: 
                case OL: {
                    if (!(this.getParent() instanceof BlockView)) break;
                    BlockView blockParent = (BlockView)this.getParent();
                    if (blockParent.tag == null) break;
                    switch (blockParent.tag) {
                        case BODY: 
                        case TH: 
                        case TD: {
                            if (blockParent.getViewCount() > 0) {
                                LengthUnit currentMargin;
                                Styles defaultStyles;
                                Object defaultMargin;
                                if (blockParent.getView(0) == this && (defaultMargin = (defaultStyles = ((InetHtmlDocument)this.getElement().getDocument()).getStyleSheet("DEFAULT")).getDefaultSet((Object)this.tag).getAttribute((Object)TemporaryStyle.Attribute.MARGIN_TOP)) == (currentMargin = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_TOP))) {
                                    insets.top = 0;
                                }
                                if (blockParent.getView(blockParent.getViewCount() - 1) == this && (this.tag == HTML.Tag.P || this.getElement().getElementCount() == 0 || this.getElement().getElement(0).getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.CONTENT)) {
                                    defaultStyles = ((InetHtmlDocument)this.getElement().getDocument()).getStyleSheet("DEFAULT");
                                    defaultMargin = defaultStyles.getDefaultSet((Object)this.tag).getAttribute((Object)TemporaryStyle.Attribute.MARGIN_BOTTOM);
                                    if (defaultMargin != (currentMargin = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_BOTTOM))) break block0;
                                    insets.bottom = 0;
                                    break;
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
        return insets;
    }

    @Override
    public void updateRelativeValues(int parentWidth) {
        if (this.hasRelativeMargin()) {
            Insets prev = (Insets)this.getBox().getMargins().clone();
            Insets margins = this.getBaseInsets(2, parentWidth, this.getElement());
            prev.top -= this.collapsedMargins.top;
            prev.bottom -= this.collapsedMargins.bottom;
            this.collapsedMargins.set(margins.top - prev.top, margins.left, margins.bottom - prev.bottom, margins.right);
            this.getBox().setMargins(margins);
        }
        if (this.hasRelativePadding()) {
            this.getBox().setPadding(this.getBaseInsets(1, parentWidth, this.getElement()));
        }
    }

    private void addContentViews(Element elem, ArrayList<BoxView> inlineBoxes, ArrayList<BoxView> blocks, boolean setRealtive) {
        AttributeSet attrs = elem.getAttributes();
        Object tag = attrs.getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.SCRIPT) {
            return;
        }
        if (tag == HTML.Tag.CONTENT && elem.getStartOffset() >= elem.getEndOffset()) {
            return;
        }
        ViewFactory viewFactory = this.getViewFactory();
        BoxView child = (BoxView)viewFactory.create(elem);
        if (child == null) {
            return;
        }
        if (child.isBlock() && child.isInFlow()) {
            this.checkIfAnonymousBlockNeeded(inlineBoxes, blocks);
            if (setRealtive) {
                child.setPosition((byte)1);
            }
            blocks.add(child);
        } else if (child instanceof InlineView) {
            int n = elem.getElementCount();
            for (int i = 0; i < n; ++i) {
                this.addContentViews(elem.getElement(i), inlineBoxes, blocks, setRealtive || child.getPosition() == 1);
            }
        } else {
            if (this.tag == HTML.Tag.IMPLIED && !child.isInFlow() && !child.isFloating()) {
                return;
            }
            if (setRealtive) {
                child.setPosition((byte)1);
            }
            inlineBoxes.add(child);
        }
    }

    private boolean checkIfAnonymousBlockNeeded(ArrayList<BoxView> inlineBoxes, ArrayList<BoxView> blocks) {
        int n = inlineBoxes.size();
        if (n > 0) {
            BoxView inline;
            Document document = this.getDocument();
            if (!(document instanceof CssDocument)) {
                return false;
            }
            boolean allFloats = true;
            for (BoxView inline2 : inlineBoxes) {
                if (!inline2.isInFlow() || ElementUtils.isEndMarker(inline2.getElement())) continue;
                allFloats = false;
                break;
            }
            if (allFloats) {
                for (BoxView inline2 : inlineBoxes) {
                    if (ElementUtils.isEndMarker(inline2.getElement())) continue;
                    blocks.add(inline2);
                }
                inlineBoxes.clear();
                return false;
            }
            if (n == 1 && ElementUtils.isEndMarker((inline = inlineBoxes.get(0)).getElement())) {
                inlineBoxes.clear();
                return false;
            }
            AbstractDocument.BranchElement elem = ((CssDocument)document).createAnnonymousElement(this.getElement());
            BlockView anonymousBlock = (BlockView)((InetHtmlFactory)this.getViewFactory()).create(elem, 3);
            ArrayList<Element> children = new ArrayList<Element>();
            ArrayList<BoxView> childViews = new ArrayList<BoxView>();
            ArrayList<BoxView> positioned = new ArrayList<BoxView>();
            for (int i = 0; i < n; ++i) {
                BoxView v = inlineBoxes.get(i);
                if (v.isMarker()) continue;
                if (!v.isInFlow() && !v.isFloating()) {
                    if (children.size() == 0) {
                        blocks.add(v);
                        continue;
                    }
                    positioned.add(v);
                    continue;
                }
                children.add(v.getElement());
                childViews.add(v);
            }
            elem.replace(0, 0, children.toArray(new Element[children.size()]));
            anonymousBlock.layout = new InlineLayout(anonymousBlock);
            anonymousBlock.moveViewsToAnonymousBlock(this, childViews.toArray(new BoxView[childViews.size()]));
            inlineBoxes.clear();
            blocks.add(anonymousBlock);
            blocks.addAll(positioned);
            return true;
        }
        return false;
    }

    private void moveViewsToAnonymousBlock(View parent, BoxView[] newViews) {
        super.setParent(parent);
        for (BoxView view : this.views) {
            view.setParent(null);
        }
        for (BoxView view : this.views = newViews) {
            view.setParent(this);
        }
        this.viewCount = this.views.length;
    }

    @Override
    public int getViewCount() {
        if (this.views == null) {
            return 0;
        }
        return this.viewCount;
    }

    @Override
    public View getView(int n) {
        if (this.views == null) {
            return null;
        }
        return this.views[n];
    }

    public View[] getChildViews() {
        return this.views;
    }

    @Override
    public void replace(int offset, int count, View[] newViews) {
        this.replace(offset, count, newViews, null);
    }

    public void replace(int offset, int count, View[] newViews, boolean[] keepViewArray) {
        if (count == 0 && (newViews == null || newViews.length == 0)) {
            return;
        }
        if (newViews == null) {
            newViews = EMPTY_VIEWS;
        }
        for (int i = offset; i < offset + count; ++i) {
            if (i >= this.views.length) {
                count = this.views.length - offset;
                break;
            }
            if (this.views[i].getParent() != this) continue;
            if (keepViewArray == null || !keepViewArray[i]) {
                this.views[i].setParent(null);
            }
            this.views[i] = null;
        }
        int delta = newViews.length - count;
        int src = offset + count;
        int nmove = this.viewCount - src;
        int dest = src + delta;
        if (this.viewCount + delta >= this.views.length) {
            int newLength = Math.max(2 * this.views.length, this.viewCount + delta);
            BoxView[] newChildren = new BoxView[newLength];
            System.arraycopy(this.views, 0, newChildren, 0, offset);
            System.arraycopy(newViews, 0, newChildren, offset, newViews.length);
            System.arraycopy(this.views, src, newChildren, dest, nmove);
            this.views = newChildren;
        } else {
            System.arraycopy(this.views, src, this.views, dest, nmove);
            System.arraycopy(newViews, 0, this.views, offset, newViews.length);
        }
        this.viewCount += delta;
        for (int i = 0; i < newViews.length; ++i) {
            newViews[i].setParent(this);
        }
    }

    protected BlockView clone() {
        try {
            BlockView v = (BlockView)super.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public View createFragment(int start, int end) {
        int idx2;
        int n = this.viewCount;
        if (n == 0 || start >= end || start == this.getStartOffset() && end == this.getEndOffset()) {
            return this;
        }
        int idx1 = this.getViewIndex(start);
        if (idx1 < 0) {
            return this;
        }
        int n2 = idx2 = end == this.getEndOffset() ? n - 1 : this.getViewIndex(end);
        if (idx2 < 0) {
            return this;
        }
        View v1 = this.getView(idx1);
        View v2 = null;
        int count = idx2 - idx1 + 1;
        if (count == 1) {
            if (!(v1.getStartOffset() >= start && v1.getEndOffset() <= end || (v1 = v1.createFragment(start, end)).getStartOffset() >= start && v1.getEndOffset() <= end)) {
                return this;
            }
        } else {
            if (v1.getStartOffset() < start && (v1 = v1.createFragment(start, v1.getEndOffset())).getStartOffset() < start) {
                return this;
            }
            v2 = this.getView(idx2);
            if (v2.getEndOffset() > end && (v2 = v2.createFragment(v2.getStartOffset(), end)).getEndOffset() > end) {
                return this;
            }
        }
        BlockView v = this.clone();
        v.viewCount = count;
        v.views = new BoxView[count];
        BoxView[] fragmentViews = v.views;
        System.arraycopy(this.views, idx1, fragmentViews, 0, count);
        fragmentViews[0] = (BoxView)v1;
        if (v2 != null) {
            fragmentViews[count - 1] = (BoxView)v2;
        }
        for (int i = 0; i < fragmentViews.length; ++i) {
            fragmentViews[i].setParent(v);
        }
        v.setStartAndEndOffset(start, end);
        return v;
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (this.layout != null) {
            return this.layout.getCurrentSpan(axis);
        }
        return 0.0f;
    }

    @Override
    public float getMinimumSpan(int axis) {
        return this.layout != null ? this.layout.getMinimumSpan(axis) : 0.0f;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Shape result = this.layout != null ? this.layout.modelToView(pos, a, b) : null;
        AffineTransform at = this.getTransform(a.getBounds(), false, false);
        if (at != null) {
            if (result instanceof Rectangle) {
                Rectangle r = (Rectangle)result;
                if (r.width == 0) {
                    r.width = 1;
                }
            }
            Area area = new Area(result);
            result = area.createTransformedArea(at);
        }
        return result;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        AffineTransform at = this.getTransform(null, true, true);
        if (at != null) {
            Rectangle bounds = a.getBounds();
            Point2D c = this.getTransformCenter();
            float dx = (float)(c.getX() + (double)bounds.x);
            float dy = (float)(c.getY() + (double)bounds.y);
            Point2D.Float p = new Point2D.Float(x - dx, y - dy);
            at.transform(p, p);
            x = (float)p.getX() + dx;
            y = (float)p.getY() + dy;
        }
        return this.layout.viewToModel(x, y, a, biasReturn);
    }

    @Override
    public Shape getChildAllocation(int index, Shape a) {
        Point p;
        StackManager m;
        if (!this.layout.isPreLayouted()) {
            return a;
        }
        View v = this.getView(index);
        if (this.layout != null) {
            for (Layout.PositionInfo pos : this.layout.getChildren()) {
                if (pos.view != v) continue;
                Rectangle rect = (Rectangle)a;
                rect.setLocation(pos.x, pos.y);
                rect.setSize(pos.view.getOuterWidth(), pos.view.getOuterHeight());
                return a;
            }
        }
        if ((m = this.getPositionManager(false)) != null && (p = m.getPositionInfo((BoxView)v)) != null) {
            Point ref = this.getLeftUpperCorner(this);
            Rectangle rect = (Rectangle)a;
            rect.x = p.x - ref.x;
            rect.y = p.y - ref.y;
            rect.width = ((BoxView)v).getOuterWidth();
            rect.height = ((BoxView)v).getOuterHeight();
        }
        return a;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        AffineTransform at;
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.layout == null) {
            return;
        }
        if (this.isCanceledByPainter(g, allocation)) {
            return;
        }
        Rectangle rect = allocation.getBounds();
        Rectangle clip = g.getClipBounds();
        Rectangle origClip = null;
        boolean origClipSet = false;
        if (this.getOverflow() == 2) {
            origClipSet = true;
            if (clip != null) {
                origClip = clip.getBounds();
                g.setClip(rect.intersection(clip));
            } else {
                g.setClip(rect);
            }
        }
        if ((at = this.getTransform(rect, false, false)) != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.transform(at);
            if (at.getScaleX() != (double)((int)at.getScaleX()) || at.getShearX() != (double)((int)at.getShearX())) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g = g2;
        }
        int x = rect.x + this.getLeftInset();
        int y = rect.y + this.getTopInset() + this.getContentVerticalOffset();
        boolean requiresCheck = false;
        boolean intersects = true;
        if (clip != null) {
            int clipX = clip.x;
            int clipY = clip.y;
            clip.translate(-rect.x, -rect.y);
            requiresCheck = !clip.contains(this.span);
            intersects = clip.intersects(this.span);
            clip.setLocation(clipX, clipY);
        }
        if (intersects) {
            super.paint(g, allocation);
            if (userMarker) {
                Rectangle inner = new Rectangle(rect);
                Insets border = this.getBox().getBorderInsets();
                inner.translate(border.left, border.top);
                inner.setSize(inner.width - border.left - border.right, inner.height - border.top - border.bottom);
                this.paintBackground(g, inner);
            }
        }
        if (this.floatManager != null) {
            this.floatManager.paint(g, allocation, 0);
        }
        for (Layout.PositionInfo pos : this.layout.getChildren()) {
            if (!pos.paintInFlow) continue;
            rect.x = pos.x + x;
            rect.y = pos.y + y;
            rect.width = pos.view.getOuterWidth();
            rect.height = pos.view.getOuterHeight();
            if (requiresCheck) {
                Rectangle span = rect;
                if (pos.isLayouted) {
                    span = pos.view.getSpan().getBounds();
                    span.x += rect.x;
                    span.y += rect.y;
                }
                if (at != null) {
                    Area a = new Area(rect);
                    a.transform(at);
                    span = a.getBounds();
                }
                if (clip != null && !clip.intersects(span)) continue;
            }
            pos.view.paint(g, rect);
        }
        if (this.floatManager != null) {
            this.floatManager.paint(g, allocation, 1);
            this.floatManager.paint(g, allocation, 3);
        }
        if (at != null) {
            g.dispose();
        }
        if (origClipSet) {
            g.setClip(origClip);
        }
    }

    private AffineTransform getTransform(Rectangle rect, boolean inverse, boolean raw) {
        if (!this.hasTransform) {
            return null;
        }
        TransformValue t = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.TRANSFORM);
        if (t == null || t.isNone()) {
            return null;
        }
        AffineTransform t2 = t.getTransform(inverse);
        if (t2.isIdentity()) {
            return null;
        }
        if (raw) {
            return t2;
        }
        AffineTransform at = new AffineTransform();
        Point2D c = this.getTransformCenter();
        double dX = c.getX() + (double)rect.x;
        double dY = c.getY() + (double)rect.y;
        if (inverse) {
            Point2D.Double p = new Point2D.Double(-dX, -dY);
            at.translate(-t2.getTranslateX(), -t2.getTranslateY());
            t2.transform(p, p);
            at.translate(dX + p.getX(), dY + p.getY());
            at.concatenate(t2);
        } else {
            Point2D.Double p = new Point2D.Double(dX, dY);
            t2.transform(p, p);
            at.translate(dX - p.getX() + t2.getTranslateX(), dY - p.getY() + t2.getTranslateY());
            at.concatenate(t2);
        }
        return at;
    }

    private Point2D getTransformCenter() {
        BackgroundPosition o = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.TRANSFORM_ORIGIN);
        if (o == null) {
            return new Point2D.Double((double)this.getOuterWidth() / 2.0, (double)this.getOuterHeight() / 2.0);
        }
        return new Point2D.Double(o.getPercentX().calculateValue(this.getOuterWidth(), this), o.getPercentY().calculateValue(this.getOuterHeight(), this));
    }

    public Point getLeftUpperCorner(BoxView child) {
        if (child == this) {
            if (this.isPositionRoot()) {
                return new Point(this.getLeftInset(), this.getTopInset());
            }
            if (this.getParent() instanceof BlockView) {
                return ((BlockView)this.getParent()).getLeftUpperCorner(child);
            }
            return new Point(this.getBox().getTotalLeftGain(), this.getBox().getTotalTopGain());
        }
        Point p = null;
        if (!child.isInFlow()) {
            if (this.isPositionRoot() && this.floatManager != null) {
                p = this.floatManager.getPositionInfo(child);
                if (p != null) {
                    return p;
                }
            } else if (this.getParent() instanceof BlockView) {
                return ((BlockView)this.getParent()).getLeftUpperCorner(child);
            }
        }
        p = !this.isPositionRoot() && this.getParent() instanceof BlockView ? ((BlockView)this.getParent()).getLeftUpperCorner(this) : new Point(this.getLeftInset(), this.getTopInset());
        if (child == this) {
            return p;
        }
        Layout.PositionInfo pos = this.getLayout().getChildPosition(child);
        if (pos != null) {
            p.x += pos.x + child.getLeftInset();
            p.y += pos.y + child.getTopInset();
        }
        return p;
    }

    public boolean isPositionRoot() {
        return this.isFloating() || this.getPosition() > 0 || this.isTableCell() || this.getOverflow() != 1 || this.isAtomicInlineLevelBox();
    }

    public boolean isAtomicInlineLevelBox() {
        switch (this.getDisplay()) {
            case 2: 
            case 9: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getElement() != null ? this.getElement().toString() : "No Element";
    }

    public StackManager getPositionManager(boolean create) {
        if (this.floatManager != null) {
            return this.floatManager;
        }
        if (this.isPositionRoot()) {
            if (!create) {
                return null;
            }
            this.floatManager = new StackManager(this);
            return this.floatManager;
        }
        View v = this.getParent();
        if (v != null && v instanceof BlockView) {
            return ((BlockView)v).getPositionManager(create);
        }
        return null;
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public void performPreLayout() {
        super.performPreLayout();
        if (this.layout != null && this.getStatus() == 2) {
            this.layout.preLayout();
        }
        this.setStatusLocal(1);
        this.setStatus(1);
    }

    @Override
    public Rectangle performLayout(boolean hard) {
        if (this.layout != null && (hard || this.getStatus() != 0)) {
            AffineTransform t;
            block8: {
                if (this.floatManager != null && this.floatManager.hasViews()) {
                    hard = true;
                    this.floatManager.clear();
                }
                this.span = this.layout.layout(hard);
                try {
                    this.setSizeContent(this.layout.getCurrentWidth(), this.layout.getCurrentHeight());
                }
                catch (NullPointerException npe) {
                    if (!Logger.doesLog(2)) break block8;
                    Logger.warning("Error layouting Blockview");
                }
            }
            if (!(this instanceof HtmlRootView)) {
                this.toExternalBox(this.span);
            }
            if (this.floatManager != null && this.floatManager.hasViews()) {
                this.floatManager.notifyBlockFinished(hard);
                LengthUnit height = this.getHeightUnit();
                if (height == null || height.isAuto()) {
                    Rectangle spanStack = this.floatManager.getSpan();
                    Layout.union(this.span, spanStack);
                }
            }
            if ((t = this.getTransform(null, false, true)) != null) {
                Area area = new Area(this.span);
                Point2D c = this.getTransformCenter();
                area.transform(AffineTransform.getTranslateInstance(-c.getX(), -c.getX()));
                area.transform(t);
                area.transform(AffineTransform.getTranslateInstance(c.getX(), c.getX()));
                this.span = area.getBounds();
            }
        }
        this.setStatusLocal(0);
        return this.span != null ? this.span : new Rectangle();
    }

    public void toExternalBox(Rectangle span) {
        if (this.getOverflow() == 2) {
            span.setBounds(0, 0, this.getOuterWidth(), this.getOuterHeight());
        } else {
            IBoxPainter box = this.getBox();
            int left = box.getLeftBorderPadding();
            int top = box.getTopBorderPadding();
            span.translate(left, top);
            Layout.union(span, 0, 0, this.getContentWidth(), this.getContentHeight());
        }
    }

    @Override
    public void performLayoutWidth() {
        if (this.layout != null) {
            int before = this.layout.getCurrentWidth();
            this.layout.layoutWidth();
            if (before != this.layout.getCurrentWidth()) {
                this.setStatus(1);
            }
        }
    }

    @Override
    public void predictWidth(int width) {
        if (this.layout != null) {
            this.layout.predictWidth(width);
        }
    }

    @Override
    public int getContentHeight() {
        if (this.floatManager != null) {
            return this.getCompleteHight();
        }
        return super.getContentHeight();
    }

    @Override
    public int getOuterHeight() {
        if (this.floatManager != null) {
            int add = this.getTopInset() + this.getBottomInset();
            return this.getCompleteHight() + add;
        }
        return super.getOuterHeight();
    }

    @Override
    public int getCompleteHight() {
        int floatHeight;
        int height = super.getContentHeight();
        if (this.floatManager != null && this.getOverflow() != 2 && (this.getHeightUnit() == null || this.getHeightUnit().isAuto()) && (floatHeight = this.floatManager.getBottomPosition(this)) > height) {
            height = floatHeight;
        }
        return height;
    }

    @Override
    public void performLayoutVAlign(int baseline) {
        this.layout.layoutVerticalAlign((int)this.getAlignment(1), baseline);
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (Logger.doesLog(4)) {
            Logger.debug("BlockView(" + this.toString().trim() + "):insertUpdate(" + e.getChange(this.getElement()) + ")");
        }
        boolean hadChanges = false;
        List<Element> newElements = this.checkStructuralUpdate(e);
        if (newElements != VIEW_REBUILT) {
            int i;
            hadChanges = newElements != null;
            int start = ViewUtils.getOffset(e);
            int end = start + ViewUtils.getLength(e);
            int n = i = this.isListItemWithMarker() ? 1 : 0;
            while (i < this.getViewCount()) {
                View v = this.getView(i);
                if (!(v instanceof ContentView)) {
                    int contentStart = v.getStartOffset();
                    int contentEnd = v.getEndOffset();
                    if (!(start > contentEnd || end < contentStart || newElements != null && this.isNewView(newElements, v.getElement()))) {
                        v.insertUpdate(e, a, f);
                    }
                }
                ++i;
            }
            if (hadChanges) {
                this.checkMarkerUpdate();
            }
            hadChanges |= this.contentUpdate(e, f, true, newElements);
        } else {
            hadChanges = true;
        }
        if (hadChanges) {
            this.setStatus(2);
        }
    }

    private boolean isNewView(List<Element> newElements, Element toCheck) {
        for (Element newElem : newElements) {
            if (newElem == toCheck) {
                return true;
            }
            if (toCheck.getStartOffset() < newElem.getStartOffset() || toCheck.getEndOffset() > newElem.getEndOffset() || !ElementUtils.isRelated(toCheck, newElem)) continue;
            return true;
        }
        return false;
    }

    private List<Element> checkStructuralUpdate(DocumentEvent e) {
        if (this.getElement().getDocument() instanceof InetHtmlDocument) {
            return this.checkStructuralUpdateSPECIAL(e);
        }
        return this.checkStructuralUpdateUNI(e);
    }

    private List<Element> checkStructuralUpdateUNI(DocumentEvent e) {
        boolean structureChange = false;
        ArrayList<Object> changes = null;
        if (e instanceof InetHtmlDocument.ExtendedDocuementEvent && ((InetHtmlDocument.ExtendedDocuementEvent)e).hasEditsFor(this.getElement())) {
            InetHtmlDocument.ExtendedDocuementEvent event = (InetHtmlDocument.ExtendedDocuementEvent)e;
            changes = event.getEditsFor(this.getElement());
            structureChange = true;
        } else {
            DocumentEvent.ElementChange change = e.getChange(this.getElement());
            changes = new ArrayList<DocumentEvent.ElementChange>();
            changes.add(change);
            structureChange = change != null;
        }
        int n = this.getViewCount();
        if (!structureChange) {
            View lastView;
            if (n > 0 && this.getView(n - 1) != null && (lastView = this.getView(n - 1)) != null && lastView.getEndOffset() != this.getElement().getEndOffset()) {
                if (Logger.doesLog(2)) {
                    Logger.warning("Update found by index check.");
                }
                changes = null;
                structureChange = true;
            }
            if (n > 0 && this.getView(0) != null && (lastView = this.getView(0)) != null && lastView.getStartOffset() != this.getElement().getStartOffset()) {
                if (Logger.doesLog(2)) {
                    Logger.warning("Update found by index check.");
                }
                changes = null;
                structureChange = true;
            }
        }
        if (structureChange) {
            int i;
            Element base = this.getElement();
            ArrayList<Element> modelElements = new ArrayList<Element>(base.getElementCount());
            ArrayList<Element> viewElements = new ArrayList<Element>(this.getViewCount());
            ArrayList<Element> viewElementsOrig = new ArrayList<Element>(this.getViewCount());
            Element last = null;
            for (i = 0; i < this.getViewCount(); ++i) {
                Element elem;
                View v = this.getView(i);
                Element element = elem = v != null ? v.getElement() : null;
                if (elem == null || elem == last) continue;
                viewElementsOrig.add(elem);
                this.insert(elem, viewElements);
                last = elem;
            }
            last = null;
            for (i = 0; i < base.getElementCount(); ++i) {
                Element elem = base.getElement(i);
                if (elem == null || elem == last) continue;
                this.insert(elem, modelElements);
                last = elem;
            }
            int addSize = Math.max(2, modelElements.size() - viewElements.size());
            int remSize = Math.max(2, viewElements.size() - modelElements.size());
            List<Element> remElements = new ArrayList<Element>(remSize);
            ArrayList<Element> newElements = new ArrayList<Element>(addSize);
            for (Element viewElement : viewElements) {
                if (Collections.binarySearch(modelElements, viewElement, ELEM_COMPARE) >= 0) continue;
                this.insert(viewElement, remElements);
            }
            for (Element modelElement : modelElements) {
                if (Collections.binarySearch(viewElements, modelElement, ELEM_COMPARE) >= 0 || modelElement.isLeaf() && modelElement.getStartOffset() >= modelElement.getEndOffset()) continue;
                this.insert(modelElement, newElements);
            }
            Iterator lastAdded = null;
            for (int i2 = 0; i2 < this.getViewCount(); ++i2) {
                Iterator elem;
                View v = this.getView(i2);
                Iterator iterator = elem = v != null ? v.getElement() : null;
                if (elem == null || v == null || v.getStartOffset() >= elem.getStartOffset() && v.getEndOffset() <= elem.getEndOffset() || elem == lastAdded) continue;
                this.insert((Element)((Object)elem), remElements);
                this.insert((Element)((Object)elem), (List<Element>)newElements);
                lastAdded = elem;
            }
            int start = ViewUtils.getOffset(e);
            int end = start + ViewUtils.getLength(e);
            for (Element element : modelElements) {
                if (element.getEndOffset() <= start || element.getStartOffset() >= end) continue;
                if (Collections.binarySearch(viewElements, element, ELEM_COMPARE) >= 0) {
                    this.insert(element, remElements);
                }
                this.insert(element, newElements);
            }
            if (changes != null) {
                for (DocumentEvent.ElementChange elementChange : changes) {
                    Element[] adds = elementChange.getChildrenAdded();
                    Element[] rems = elementChange.getChildrenRemoved();
                    if (adds != null && adds.length > 0) {
                        for (Element add : adds) {
                            this.insert(add, newElements);
                            if (Collections.binarySearch(viewElements, add, ELEM_COMPARE) < 0) continue;
                            this.insert(add, remElements);
                        }
                    }
                    if (rems == null || rems.length <= 0) continue;
                    for (Element rem : rems) {
                        if (Collections.binarySearch(viewElements, rem, ELEM_COMPARE) < 0) continue;
                        this.insert(rem, remElements);
                    }
                }
            }
            if (newElements.size() == 0 && remElements.size() == 0) {
                return null;
            }
            if (newElements.size() == 0) {
                int lastEnd = ((Element)newElements.get(0)).getEndOffset();
                ArrayList<Element> arrayList = new ArrayList<Element>(newElements.size());
                Iterator i3 = newElements.iterator();
                arrayList.add((Element)i3.next());
                while (i3.hasNext()) {
                    Element elem = (Element)i3.next();
                    int currentStart = elem.getStartOffset();
                    int elemIndex = 0;
                    while (currentStart > lastEnd) {
                        Element mE = (Element)modelElements.get(elemIndex);
                        ++elemIndex;
                        if (mE.getStartOffset() == lastEnd && mE.getEndOffset() <= currentStart) {
                            this.insert(mE, arrayList);
                            this.insert(mE, remElements);
                            lastEnd = mE.getEndOffset();
                            continue;
                        }
                        if (elemIndex != modelElements.size() || currentStart <= lastEnd) continue;
                        this.rebuildView();
                        return VIEW_REBUILT;
                    }
                    lastEnd = elem.getEndOffset();
                    arrayList.add(elem);
                }
                newElements = arrayList;
            }
            try {
                int startIndex = -1;
                if (newElements.size() > 0) {
                    startIndex = base.getElementIndex(((Element)newElements.get(0)).getEndOffset() - 1);
                }
                if (!this.replace(startIndex, remElements = this.toOrigOrder(remElements, viewElementsOrig), newElements)) {
                    this.rebuildView();
                    return VIEW_REBUILT;
                }
            }
            catch (Throwable ex) {
                if (Logger.doesLog(2)) {
                    Logger.warning("Update view failed. Falling back... rebuilding view.");
                    Logger.debug("Cause: " + ex.getClass().getName() + ": " + ex.getMessage());
                    Logger.error(ex);
                }
                this.rebuildView();
                return VIEW_REBUILT;
            }
            return newElements;
        }
        return null;
    }

    private List<Element> toOrigOrder(List<Element> toSort, List<Element> order) {
        if (toSort == null || toSort.size() <= 1) {
            Logger.debug("EMPTY");
            return toSort;
        }
        if (toSort.size() == order.size() && toSort.equals(order)) {
            Logger.debug("EQUAL");
            return toSort;
        }
        if (Collections.indexOfSubList(order, toSort) >= 0) {
            Logger.warning("SUBSET");
            return toSort;
        }
        Logger.error("SORT");
        int refSize = toSort.size();
        ArrayList<Element> sorted = new ArrayList<Element>(toSort.size());
        for (Element orig : order) {
            if (!toSort.contains(orig)) continue;
            sorted.add(orig);
            if (sorted.size() != refSize) continue;
            return sorted;
        }
        return sorted;
    }

    private void insert(Element elem, List<Element> list) {
        int pos = Collections.binarySearch(list, elem, ELEM_COMPARE);
        if (pos < 0) {
            int insertPos = -(pos + 1);
            list.add(insertPos, elem);
        }
    }

    private ArrayList<Element> checkStructuralUpdateSPECIAL(DocumentEvent e) {
        List<DocumentEvent.ElementChange> changes = this.getChanges(e);
        if (changes == null) {
            return null;
        }
        ArrayList<Element> newElements = new ArrayList<Element>();
        block2: for (DocumentEvent.ElementChange change : changes) {
            Object[] childrenAdded = change.getChildrenAdded();
            if (childrenAdded != null && childrenAdded.length == 0 && change.getChildrenRemoved().length == 0) continue;
            if (Logger.doesLog(4)) {
                Logger.debug("Index: " + change.getIndex());
                Logger.debug("+" + Arrays.toString(childrenAdded));
                Logger.debug("-" + Arrays.toString(change.getChildrenRemoved()));
            }
            int startIndex = -1;
            if (change.getChildrenRemoved().length == 0) {
                startIndex = change.getIndex();
            }
            Element current = change.getElement();
            for (Element newElem : newElements) {
                if (!ElementUtils.isRelated(current, newElem)) continue;
                continue block2;
            }
            if (childrenAdded != null && childrenAdded.length > 0) {
                for (Object newElem : childrenAdded) {
                    newElements.add((Element)newElem);
                }
            }
            try {
                if (this.replace(startIndex, Arrays.asList(change.getChildrenRemoved()), Arrays.asList(childrenAdded))) continue;
                this.rebuildView();
                return VIEW_REBUILT;
            }
            catch (Throwable ex) {
                if (Logger.doesLog(2)) {
                    Logger.warning("Update view failed. Falling back... rebuilding view.");
                }
                this.rebuildView();
                return VIEW_REBUILT;
            }
        }
        return newElements;
    }

    public List<DocumentEvent.ElementChange> getChanges(DocumentEvent e) {
        List<DocumentEvent.ElementChange> changes = null;
        changes = this.getChangesForElement(e, this.getElement());
        if (changes == null) {
            Element toCheck;
            Element stop = this.getParent().getElement();
            if (stop == null || toCheck == null || stop == toCheck) {
                return null;
            }
            for (toCheck = this.getElement().getParentElement(); toCheck != stop && toCheck != null; toCheck = toCheck.getParentElement()) {
                List<DocumentEvent.ElementChange> newChanges = this.getChangesForElement(e, this.getElement());
                if (changes != null) continue;
                changes = newChanges;
            }
        }
        return changes;
    }

    public List<DocumentEvent.ElementChange> getChangesForElement(DocumentEvent e, Element element) {
        ArrayList<DocumentEvent.ElementChange> changes;
        if (e instanceof InetHtmlDocument.ExtendedDocuementEvent) {
            changes = ((InetHtmlDocument.ExtendedDocuementEvent)e).getEditsFor(element);
            if (changes == null) {
                return null;
            }
            boolean hasChanges = false;
            for (DocumentEvent.ElementChange c : changes) {
                if (!(c instanceof AbstractDocument.ElementEdit)) continue;
                hasChanges = true;
                break;
            }
            if (!hasChanges) {
                return null;
            }
        } else {
            DocumentEvent.ElementChange change = e.getChange(element);
            if (!(change instanceof AbstractDocument.ElementEdit)) {
                return null;
            }
            changes = new ArrayList();
            changes.add(change);
        }
        return changes;
    }

    private boolean contentUpdate(DocumentEvent e, ViewFactory f, boolean isInsert, List<Element> newElements) {
        int j;
        int start = ViewUtils.getOffset(e);
        int end = start + (isInsert ? ViewUtils.getLength(e) : 0);
        ArrayList<Element> affectedElements = null;
        ArrayList<Integer> startRemove = null;
        ArrayList<Integer> endRemove = null;
        Element lastElement = null;
        int n = j = this.isListItemWithMarker() ? 1 : 0;
        while (j < this.getViewCount()) {
            BoxView view = (BoxView)this.getView(j);
            Element viewElem = view.getElement();
            int contentStart = viewElem.getStartOffset();
            int contentEnd = viewElem.getEndOffset();
            if (lastElement != viewElem && lastElement != null && endRemove != null) {
                endRemove.add(j);
                lastElement = null;
            }
            if (newElements == null || !newElements.contains(viewElem)) {
                boolean match = true;
                match = isInsert ? (match &= start <= contentEnd && end >= contentStart) : (match &= start >= contentStart && start <= contentEnd);
                if (match &= view instanceof ContentView) {
                    if (affectedElements == null || startRemove == null) {
                        affectedElements = new ArrayList<Element>();
                        startRemove = new ArrayList<Integer>();
                        endRemove = new ArrayList<Integer>();
                    }
                    if (lastElement != viewElem) {
                        affectedElements.add(viewElem);
                        startRemove.add(j);
                        lastElement = viewElem;
                    }
                }
            }
            ++j;
        }
        if (startRemove != null && endRemove != null && startRemove.size() != endRemove.size()) {
            endRemove.add(this.getViewCount());
        }
        if (affectedElements != null) {
            int stepBack = 0;
            for (int i = 0; i < affectedElements.size(); ++i) {
                View[] newViews;
                ArrayList<BoxView> inlineBoxes = new ArrayList<BoxView>();
                ArrayList<BoxView> blocks = new ArrayList<BoxView>();
                Element element = (Element)affectedElements.get(i);
                start = (Integer)startRemove.get(i);
                int len = (Integer)endRemove.get(i) - start;
                start -= stepBack;
                stepBack += len;
                if (!element.isLeaf()) {
                    this.replace(start, len, new View[0]);
                    continue;
                }
                this.addContentViews(element, inlineBoxes, blocks, false);
                if (blocks.size() > 0) {
                    newViews = new View[blocks.size()];
                    blocks.toArray(newViews);
                } else {
                    newViews = new View[inlineBoxes.size()];
                    inlineBoxes.toArray(newViews);
                }
                try {
                    List<BoxView> views = InlineLayout.reflow(Arrays.asList(newViews).iterator(), this, this.getRenderContext().allowTabs(), null);
                    stepBack -= views.size();
                    this.replace(start, len, views.toArray(new View[views.size()]));
                    continue;
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace(System.err);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        boolean hasChanges = false;
        List<Element> newElements = this.checkStructuralUpdate(e);
        if (newElements != VIEW_REBUILT) {
            int i;
            hasChanges = newElements != null;
            int start = ViewUtils.getOffset(e);
            int end = start + ViewUtils.getLength(e);
            int n = i = this.isListItemWithMarker() ? 1 : 0;
            while (i < this.getViewCount()) {
                View v = this.getView(i);
                if (!(v instanceof ContentView || newElements != null && newElements.contains(v.getElement()))) {
                    int contentStart = v.getStartOffset();
                    int contentEnd = v.getEndOffset();
                    if (contentStart <= end && contentEnd >= start) {
                        v.removeUpdate(e, a, f);
                    }
                }
                ++i;
            }
            if (hasChanges) {
                this.checkMarkerUpdate();
            }
            hasChanges |= this.contentUpdate(e, f, true, newElements);
        } else {
            hasChanges = true;
        }
        if (hasChanges) {
            this.setStatus(2);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        List<Element> newElements;
        if (Logger.doesLog(4)) {
            Logger.debug("BlockView(" + this.toString().trim() + "):changeUpdate(" + e.getChange(this.getElement()) + ")");
        }
        boolean hasChanges = false;
        Element elem = this.getElement();
        if (elem.getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) {
            elem = elem.getParentElement();
        }
        int start = ViewUtils.getOffset(e);
        int end = start + ViewUtils.getLength(e);
        DocumentEvent.ElementChange change = e.getChange(elem);
        if (change != null && change instanceof AttributeUndoableEdit) {
            this.setPropertiesFromAttributes(false);
            hasChanges = true;
            for (int i = 0; i < this.getViewCount(); ++i) {
                View v = this.getView(i);
                Object name = v.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (name == HTML.Tag.IMPLIED) {
                    ((BoxView)v).setPropertiesFromAttributes(false);
                    continue;
                }
                Element element = v.getElement();
                if (element == null || !element.isLeaf() || element.getStartOffset() > end || element.getEndOffset() <= start) continue;
                v.setParent(null);
                v.setParent(this);
            }
        }
        if ((newElements = this.checkStructuralUpdate(e)) != VIEW_REBUILT) {
            hasChanges |= newElements != null;
            for (int i = 0; i < this.getViewCount(); ++i) {
                View v = this.getView(i);
                if (v.getStartOffset() > end || v.getEndOffset() < start || newElements != null && newElements.contains(v.getElement())) continue;
                v.changedUpdate(e, a, f);
            }
            if (hasChanges) {
                this.checkMarkerUpdate();
            }
        } else {
            hasChanges = true;
        }
        if (hasChanges) {
            this.setStatus(2);
        }
    }

    private void checkMarkerUpdate() {
        Object tag = this.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.UL || tag == HTML.Tag.OL) {
            this.updateListMarkers();
        }
    }

    public void updateListMarkers() {
        int counter = 0;
        IntegerValue listStart = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.START);
        if (listStart != null) {
            counter = listStart.getInt() - 1;
        }
        InetHtmlFactory viewFactory = (InetHtmlFactory)this.getViewFactory();
        for (int i = 0; i < this.getViewCount(); ++i) {
            BoxView view = (BoxView)this.getView(i);
            if (!view.isListItemWithMarker()) continue;
            ++counter;
            UriValue type = StyleResolver.getAttributeValue(view.getElement(), AttributeFinder.LIST_STYLE_IMAGE);
            if (type != null) continue;
            IntegerValue currentValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.VALUE);
            if (currentValue != null) {
                counter = currentValue.getInt();
            }
            BoxView marker = viewFactory.createListItem(view, counter);
            if (view instanceof BlockView && view.getViewCount() > 0) {
                BoxView oldMarker = (BoxView)view.getView(0);
                BlockView block = (BlockView)view;
                List<Layout.PositionInfo> children = block.getLayout().getChildren();
                if (children.size() > 0) {
                    Layout.PositionInfo pos0 = children.get(0);
                    if (pos0.view == oldMarker) {
                        pos0.view = marker;
                    }
                }
            }
            view.replace(0, 1, new View[]{marker});
            if (this.getStatus() >= 1) continue;
            view.setStatusLocal(1);
        }
    }

    public boolean replace(int elementIndex, List<Element> oldElements, List<Element> newElements) {
        int start = elementIndex;
        int end = elementIndex;
        if (oldElements != null && oldElements.size() > 0) {
            Element first = oldElements.get(0);
            Element last = oldElements.get(0);
            for (Element removeElem : oldElements) {
                if (removeElem == null) continue;
                int remStart = removeElem.getStartOffset();
                if (remStart >= 0 && remStart < first.getStartOffset()) {
                    first = removeElem;
                }
                if (removeElem.getEndOffset() < last.getEndOffset()) continue;
                last = removeElem;
            }
            start = Integer.MAX_VALUE;
            end = -1;
            for (int i = 0; i < this.getViewCount(); ++i) {
                View v = this.getView(i);
                if (v.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) {
                    if (ViewUtils.isRelated(v, first) && i < start) {
                        return false;
                    }
                    if (!ViewUtils.isRelated(v, last) || i + 1 <= end) continue;
                    return false;
                }
                if (ViewUtils.isRelated(v, first)) {
                    start = Math.min(i, start);
                    end = Math.max(i, end);
                }
                if (!ViewUtils.isRelated(v, last)) continue;
                start = Math.min(i, start);
                end = Math.max(i, end);
            }
            if (end >= start) {
                ++end;
            }
        } else {
            Element reference = newElements.get(0);
            View targetView = null;
            if (elementIndex > 0 || reference.getParentElement() != this.getElement()) {
                int i;
                boolean found = false;
                int n = i = this.isListItemWithMarker() ? 1 : 0;
                while (i < this.getViewCount()) {
                    View view = this.getView(i);
                    Element thisElem = view.getElement();
                    start = i;
                    end = i;
                    if (thisElem.getEndOffset() > reference.getStartOffset() || view.getElement() instanceof InetHtmlDocument.ImpliedElement && thisElem.getEndOffset() >= reference.getStartOffset()) {
                        found = true;
                        targetView = view;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    ++start;
                    ++end;
                }
            }
            if (targetView != null && targetView.getElement() instanceof InetHtmlDocument.ImpliedElement) {
                return ((BlockView)targetView).replace(elementIndex, oldElements, newElements);
            }
        }
        if (end - start >= 0 && end >= 0 && start >= 0) {
            if (this.isListItemWithMarker() && start == 0) {
                ++start;
                ++end;
            }
            if (Logger.doesLog(4) && end > start) {
                Object[] rem = new View[end - start];
                for (int i = start; i < end; ++i) {
                    rem[i - start] = this.getView(i);
                }
                try {
                    if (Logger.doesLog(4)) {
                        Logger.debug("Removing Views from '" + this.toString() + "': " + Arrays.toString(rem));
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            this.replace(start, end - start, new View[0]);
            if (this.hasOnlyImplieds() && newElements.size() == 0) {
                this.unpackImplieds();
                return true;
            }
            ArrayList<BoxView> newViews = null;
            ArrayList<BoxView> inlineBoxes = new ArrayList<BoxView>();
            ArrayList<BoxView> blocks = new ArrayList<BoxView>();
            boolean createdImplieds = false;
            if (newElements != null && newElements.size() > 0) {
                for (Element newElem : newElements) {
                    this.addContentViews(newElem, inlineBoxes, blocks, false);
                }
                if (blocks.size() > 0) {
                    createdImplieds |= this.checkIfAnonymousBlockNeeded(inlineBoxes, blocks);
                    if (!(this.layout instanceof BlockLayout)) {
                        for (int i = 0; i < this.getViewCount(); ++i) {
                            BoxView v = (BoxView)this.getView(i);
                            if (v.isBlock()) continue;
                            return false;
                        }
                        this.layout = new BlockLayout(this);
                        this.setStatusLocal(2);
                    }
                    newViews = blocks;
                } else if (this.layout instanceof BlockLayout) {
                    createdImplieds |= this.checkIfAnonymousBlockNeeded(inlineBoxes, blocks);
                    newViews = blocks;
                } else {
                    newViews = inlineBoxes;
                }
            }
            if (newViews != null && newViews.size() > 0) {
                if (Logger.doesLog(4)) {
                    Logger.debug("Adding Views to '" + this.toString() + "': " + Arrays.toString(newViews.toArray()));
                }
                List<BoxView> finalViews = null;
                try {
                    finalViews = this.layout instanceof InlineLayout ? InlineLayout.reflow(newViews.iterator(), this, this.getRenderContext().allowTabs(), null) : newViews;
                    this.replace(start, 0, finalViews.toArray(new View[finalViews.size()]));
                }
                catch (BadLocationException e1) {
                    if (Logger.doesLog(1)) {
                        Logger.error(e1);
                    }
                    finalViews = new ArrayList();
                }
                if (this.hasOnlyImplieds() && newElements != null && newElements.size() == 0) {
                    this.unpackImplieds();
                    return true;
                }
                for (View view : finalViews) {
                    ((BoxView)view).performPreLayout();
                }
                if (createdImplieds) {
                    this.mergeImplieds(newViews.size(), start);
                }
            }
            return true;
        }
        return false;
    }

    private void mergeImplieds(int length, int startIndex) {
        View prevView = startIndex > 0 ? this.getView(startIndex - 1) : null;
        int offset = 0;
        for (int index = 0; index <= length; ++index) {
            View current = this.getView(startIndex + index - offset);
            if (current != null && prevView != null && current.getElement() instanceof InetHtmlDocument.ImpliedElement && prevView.getElement() instanceof InetHtmlDocument.ImpliedElement) {
                int i;
                View[] inlines = new View[current.getViewCount()];
                Element[] nodes = new Element[current.getElement().getElementCount()];
                for (i = 0; i < current.getViewCount(); ++i) {
                    inlines[i] = current.getView(i);
                }
                for (i = 0; i < nodes.length; ++i) {
                    nodes[i] = current.getElement().getElement(i);
                }
                ((InetHtmlDocument.ImpliedElement)prevView.getElement()).replace(prevView.getElement().getElementCount(), 0, nodes);
                prevView.replace(prevView.getViewCount(), 0, inlines);
                this.replace(startIndex + index - offset, 1, new View[0]);
                ++offset;
                continue;
            }
            prevView = current;
        }
    }

    private boolean hasOnlyImplieds() {
        for (int i = 0; i < this.getViewCount(); ++i) {
            BoxView v = (BoxView)this.getView(i);
            if (v.isMarker()) continue;
            if (!v.isBlock()) {
                return false;
            }
            if (v.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) continue;
            return false;
        }
        return true;
    }

    private void unpackImplieds() {
        for (int i = 0; i < this.getViewCount(); ++i) {
            BoxView v = (BoxView)this.getView(i);
            if (!v.isBlock() || v.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute) == HTML.Tag.IMPLIED) continue;
            View[] children = ViewUtils.getChildren(v);
            this.replace(i, 1, children);
            i += children.length - 1;
        }
        this.layout = new InlineLayout(this);
        this.performPreLayout();
    }

    private void rebuildView() {
        if (Logger.doesLog(3)) {
            Logger.info("Rebuild caused by " + this);
        }
        View parent = this.getParent();
        this.setParent(null);
        this.setParent(parent);
    }

    public int getTextIndent() {
        if (this.textIndent != null) {
            return (int)this.textIndent.calculateValue(this.getContentWidth(), this);
        }
        return 0;
    }

    @Override
    protected void setPropertiesFromAttributes(boolean inline) {
        super.setPropertiesFromAttributes(inline);
        this.textIndent = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.TEXT_INDENT);
        this.collapsedMargins = (Insets)this.getBox().getMargins().clone();
        TransformValue t = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.TRANSFORM);
        if (t != null && !t.isNone()) {
            this.hasTransform = true;
        }
    }

    @Override
    public Insets getMargins() {
        return this.collapsedMargins;
    }

    public Insets getOriginalMargins() {
        return super.getMargins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBGImage() {
        ArrayList<Element> arrayList = VIEW_REBUILT;
        synchronized (arrayList) {
            backgroundImage = new BufferedImage(600, 130, 2);
            Graphics2D g = (Graphics2D)backgroundImage.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setColor(new Color(255, 255, 255, 0));
            g.fillRect(0, 0, 600, 130);
            g.setColor(new Color(192, 192, 192, 80));
            g.setFont(new Font("sans serif", 0, 48));
            FontMetrics metrics = g.getFontMetrics();
            g.drawString("i-net JWebEngine", (600 - metrics.stringWidth("i-net JWebEngine")) / 2, 60);
            g.drawString("- trial license -", (600 - metrics.stringWidth("- trial license -")) / 2, 120);
        }
    }

    void paintBackground(Graphics g, Rectangle rect) {
        if (userMarker && backgroundImage != null && this.tag != HTML.Tag.IMPLIED && (this.tag == HTML.Tag.HTML || this.tag == HTML.Tag.TABLE || this.getBackgroundValue() != null && this.getBackgroundValue().getValue().getAlpha() == 255)) {
            Rectangle area;
            Shape clip = g.getClip();
            if (clip == null) {
                area = rect;
                g.setClip(area);
            } else if (this.tag != HTML.Tag.BODY) {
                area = rect.intersection(clip.getBounds());
                g.setClip(area);
            } else {
                area = clip.getBounds();
            }
            int startX = area.x / 600;
            int startY = area.y / 130;
            int endX = (area.x + area.width) / 600;
            int endY = (area.y + area.height) / 130;
            for (int y = startY; y <= endY; ++y) {
                for (int x = startX - y % 2; x <= endX + y % 2; ++x) {
                    g.drawImage(backgroundImage, x * 600 + y % 2 * 600 / 2, y * 130, null);
                }
            }
            g.setClip(clip);
        }
    }

    @Override
    public boolean getVisibleDOM(Rectangle2D clip, DOMUtils.ResultMap result) {
        if (super.getVisibleDOM(clip, result)) {
            DOMUtils.DOMVisibilityResult entry;
            if (this.collapsedMargins.bottom > super.getMargins().bottom && (entry = (DOMUtils.DOMVisibilityResult)result.get(this.getElement())) != null) {
                entry.setAttribute((Object)CSS.Attribute.MARGIN_BOTTOM, new LengthUnit(this.collapsedMargins.bottom));
            }
            return true;
        }
        return false;
    }

    @Override
    public Rectangle getSpan() {
        return this.span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream in = InetHtmlDocument.class.getResourceAsStream("license.txt");
        if (in == null) {
            in = InetHtmlDocument.class.getResourceAsStream("licence.txt");
        }
        if (in != null) {
            try {
                JWebEngineLicense license;
                ByteArrayOutputStream bout = new ByteArrayOutputStream(400);
                int len = 0;
                byte[] buffer = new byte[400];
                try {
                    while ((len = in.read(buffer)) >= 0) {
                        bout.write(buffer, 0, len);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                byte[] bytes = bout.toByteArray();
                if (bytes.length > 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                    byte[] bytesCopy = new byte[bytes.length - 3];
                    System.arraycopy(bytes, 3, bytesCopy, 0, bytes.length - 3);
                    bytes = bytesCopy;
                }
                userMarker = !(license = new JWebEngineLicense(new String(bytes))).isValid() && !InetHtmlDocument.isReady();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class ElementComparator
    implements Comparator<Element> {
        private ElementComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            int dist = o1.getStartOffset() - o2.getStartOffset();
            if (dist == 0) {
                dist = o1.getEndOffset() - o2.getEndOffset();
                if (dist == 0) {
                    return o1 == o2 ? 0 : o1.hashCode() - o2.hashCode();
                }
                return dist;
            }
            return dist;
        }
    }
}

