/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import com.inet.html.InetHtmlDocument;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.image.ImageCache;
import com.inet.html.image.ImageFetcher;
import com.inet.html.parser.URLResolver;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SrcDataValue;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.Base64;
import com.inet.html.utils.Logger;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;

public class ImageInliner {
    private Map<Object, String> cache = new HashMap<Object, String>();
    private static final Map<String, String> MIME_TYPES = new HashMap<String, String>();
    private static final List<Object> IMAGE_ATTRIBUTES = new ArrayList<Object>();
    private boolean embeddedOnly;

    public void inlineImages(InetHtmlDocument doc) {
        this.crawl(doc.getRootElements()[0]);
    }

    public void setEmbeddedOnly(boolean embeddedOnly) {
        this.embeddedOnly = embeddedOnly;
    }

    private void crawl(Element elem) {
        if (elem == null) {
            return;
        }
        this.replaceImages(elem);
        for (int i = 0; i < elem.getElementCount(); ++i) {
            this.crawl(elem.getElement(i));
        }
    }

    private void replaceImages(Element elem) {
        AttributeSet atts = elem.getAttributes();
        for (Object attType : IMAGE_ATTRIBUTES) {
            URL target;
            if (!atts.isDefined(attType)) continue;
            Object value = atts.getAttribute(attType);
            URLResolver resolver = null;
            if (value instanceof UriValue) {
                if (((UriValue)value).isNone()) continue;
                resolver = ((UriValue)value).getResolver();
            } else if (value instanceof UrlValue) {
                resolver = ((UrlValue)value).getResolver();
            } else {
                resolver = new URLResolver(value != null ? value.toString() : "");
                resolver.setBase(((InetHtmlDocument)elem.getDocument()).getBase());
            }
            try {
                target = resolver.getFullURL();
                if (this.embeddedOnly) {
                    continue;
                }
            }
            catch (MalformedURLException e) {
                target = null;
            }
            String encoded = this.encodeFromTarget(resolver, target);
            SimpleAttributeSet set = new SimpleAttributeSet(atts);
            set.removeAttribute(attType);
            if (attType == TemporaryStyle.Attribute.LIST_STYLE_IMAGE) {
                AttributeValue.addCssAtrributes(set, CSS.Attribute.LIST_STYLE_IMAGE, encoded == null ? "none" : "url(" + encoded + ")", true);
                set.addAttribute((Object)TemporaryStyle.Attribute.LIST_STYLE_IMAGE, set.getAttribute((Object)CSS.Attribute.LIST_STYLE_IMAGE));
            }
            if (attType == TemporaryStyle.Attribute.BACKGROUND_IMAGE) {
                AttributeValue.addCssAtrributes(set, CSS.Attribute.BACKGROUND_IMAGE, encoded == null ? "none" : "url(" + encoded + ")", true);
                set.addAttribute((Object)TemporaryStyle.Attribute.BACKGROUND_IMAGE, set.getAttribute((Object)CSS.Attribute.BACKGROUND_IMAGE));
            }
            if (attType == HTML.Attribute.SRC) {
                if (encoded == null) {
                    if (!set.isDefined((Object)HTML.Attribute.ALT) && (value = AttributeValue.convertValue((InetHtmlDocument)elem.getDocument(), HTML.Tag.IMG, HTML.Attribute.ALT, resolver.getOriginalURI())) != null) {
                        set.addAttribute((Object)HTML.Attribute.ALT, value);
                    }
                } else {
                    SrcDataValue attribute = new SrcDataValue(encoded);
                    attribute.setCSSattribute(attType instanceof TemporaryStyle.Attribute);
                    set.addAttribute(attType, attribute);
                }
            }
            ((InetHtmlDocument)elem.getDocument()).setElementAttributes(elem, set, true);
        }
    }

    private String encodeFromTarget(URLResolver resolver, URL target) {
        Object cacheKey;
        Object object = cacheKey = target != null ? target : resolver.getOriginalURI();
        if (this.cache.containsKey(cacheKey)) {
            return this.cache.get(cacheKey);
        }
        try {
            String mime;
            String suffix;
            byte[] data;
            block22: {
                data = null;
                suffix = "png";
                mime = null;
                if (target != null) {
                    URLConnection connection = ImageFetcher.openConnection(target, 5000);
                    mime = connection.getContentType();
                    try (InputStream in = resolver.getContent(0);){
                        data = this.getDataFromStream(in);
                    }
                    String path = target.getPath();
                    if (path.indexOf(46) >= 0) {
                        suffix = path.substring(path.lastIndexOf(46) + 1).toLowerCase();
                    }
                } else {
                    Image image = ImageCache.getStaticInstance().getCachedImage(resolver.getOriginalURI(), null);
                    if (image instanceof RenderedImage) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        try {
                            if (!((RenderedImage)((Object)image)).getColorModel().hasAlpha()) {
                                suffix = "jpg";
                            }
                            if (ImageIO.write((RenderedImage)((Object)image), suffix.toUpperCase(), bout)) {
                                data = bout.toByteArray();
                            }
                        }
                        catch (IOException e) {
                            if (!Logger.doesLog(1)) break block22;
                            Logger.error(e);
                        }
                    }
                }
            }
            if (data == null) {
                return null;
            }
            String base64 = Base64.encodeBytes(data, 0, data.length, 0);
            if (mime == null) {
                mime = MIME_TYPES.get(suffix.toLowerCase());
            }
            if (mime == null) {
                mime = MIME_TYPES.get("jpg");
            }
            base64 = "data:" + mime + ";base64," + base64;
            this.cache.put(cacheKey, base64);
            return base64;
        }
        catch (Throwable t) {
            if (Logger.doesLog(1)) {
                Logger.error(t);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getDataFromStream(InputStream stream) {
        byte[] byArray;
        block21: {
            ByteArrayOutputStream bout = null;
            try {
                bout = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int c = 0;
                while ((c = stream.read(buffer)) > 0) {
                    bout.write(buffer, 0, c);
                }
                byArray = bout.toByteArray();
                if (bout == null) break block21;
            }
            catch (Throwable t) {
                try {
                    if (Logger.doesLog(2)) {
                        Logger.warning(t.getMessage());
                    }
                    byte[] byArray2 = null;
                    return byArray2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (bout != null) {
                        try {
                            bout.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            try {
                bout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (stream == null) return byArray;
        try {
            stream.close();
            return byArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    static {
        MIME_TYPES.put("gif", "image/gif");
        MIME_TYPES.put("jpeg", "image/jpeg");
        MIME_TYPES.put("jpg", "image/jpeg");
        MIME_TYPES.put("jpe", "image/jpeg");
        MIME_TYPES.put("png", "image/png");
        MIME_TYPES.put("tif", "image/tiff");
        MIME_TYPES.put("tiff", "image/tiff");
        MIME_TYPES.put("tif", "image/tiff");
        MIME_TYPES.put("bmp", "image/bmp");
        MIME_TYPES.put("ico", "image/x-icon");
        IMAGE_ATTRIBUTES.add((Object)HTML.Attribute.SRC);
        IMAGE_ATTRIBUTES.add((Object)TemporaryStyle.Attribute.LIST_STYLE_IMAGE);
        IMAGE_ATTRIBUTES.add((Object)TemporaryStyle.Attribute.BACKGROUND_IMAGE);
    }
}

