/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;
import java.util.Hashtable;

public class OverflowWrap
extends SingleAttributeValue {
    private static final String BREAK_WORD_STRING = "break-word";
    private static final String ANYWHERE_STRING = "anywhere";
    private static final String NORMAL_STRING = "normal";
    public static final byte NORMAL = 0;
    public static final byte ANYWHERE = 1;
    public static final byte BREAK_WORD = 2;
    private static final Hashtable<String, OverflowWrap> MAP = new Hashtable();
    static final OverflowWrap PARSER;
    private byte value;

    public static OverflowWrap getOverflow(byte overflow) {
        switch (overflow) {
            case 1: {
                return MAP.get(ANYWHERE_STRING);
            }
            case 2: {
                return MAP.get(BREAK_WORD_STRING);
            }
        }
        return MAP.get(NORMAL_STRING);
    }

    private static void factory(String strValue, byte intValue) {
        OverflowWrap va = new OverflowWrap();
        va.setString(strValue);
        va.value = intValue;
        MAP.put(strValue, va);
    }

    public byte getOverflow() {
        return this.value;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        return MAP.get(valueStr.toLowerCase());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OverflowWrap)) {
            return false;
        }
        OverflowWrap other = (OverflowWrap)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.value == other.value;
    }

    static {
        OverflowWrap.factory(NORMAL_STRING, (byte)0);
        OverflowWrap.factory(ANYWHERE_STRING, (byte)1);
        OverflowWrap.factory(BREAK_WORD_STRING, (byte)2);
        PARSER = MAP.get(NORMAL_STRING);
    }
}

