/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.Hashtable;
import javax.swing.text.View;

public class LengthUnit
extends HtmlAttribute {
    static final LengthUnit PARSER = new LengthUnit();
    private static final Hashtable<String, Float> UNITS = new Hashtable();
    private static float logicalInch;
    private float value;
    private int type;
    private boolean isAsterisk;
    public static final int AUTO = -1;
    public static final int ABSOLUTE = 0;
    public static final int REALTIVE = 1;
    public static final int EM = 2;
    public static final int EX = 3;
    public static final int REM = 4;

    public LengthUnit(String value) {
        LengthUnit dummy = (LengthUnit)this.parseCssValue(value, false);
        if (dummy != null) {
            this.setString(value);
            this.type = dummy.type;
            this.value = dummy.value;
            this.isAsterisk = dummy.isAsterisk;
        }
    }

    public LengthUnit(int value) {
        this(Integer.toString(value) + "px", (float)value, 0);
    }

    LengthUnit() {
    }

    protected LengthUnit(float value, int type, boolean isAsterisk) {
        this.value = value;
        this.type = type;
        this.isAsterisk = isAsterisk;
    }

    public LengthUnit(String strValue, float value, int type) {
        this.setString(strValue);
        this.value = value;
        this.type = type;
    }

    public static void setSystemDPI(float dpi) {
        logicalInch = dpi;
        UNITS.put("pt", new Float(logicalInch / 72.0f));
        UNITS.put("px", new Float(1.0f));
        UNITS.put("mm", new Float(logicalInch / 25.4f));
        UNITS.put("cm", new Float((double)logicalInch / 2.54));
        UNITS.put("pc", new Float(logicalInch / 6.0f));
        UNITS.put("in", new Float(logicalInch));
    }

    public static float getPTforPX(float px) {
        return Math.round(px * 72.0f / logicalInch);
    }

    public static float getPXforPT(float pt) {
        return Math.round(pt * logicalInch / 72.0f);
    }

    public float getValue() {
        return this.value;
    }

    public boolean isAbsolute() {
        return this.type != 1 && this.type != -1;
    }

    public boolean isAuto() {
        return this.type == -1;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        LengthUnit lengthUnit;
        block21: {
            String unit;
            String valueNum;
            char c0;
            int length;
            block20: {
                if ("inherit".equalsIgnoreCase(valueStr)) {
                    return AttributeValue.INHERIT;
                }
                lengthUnit = new LengthUnit();
                lengthUnit.setString(valueStr);
                if ("auto".equalsIgnoreCase(valueStr)) {
                    lengthUnit.type = -1;
                    return lengthUnit;
                }
                if ("0".equals(valueStr)) {
                    return lengthUnit;
                }
                if ("*".equals(valueStr)) {
                    lengthUnit.isAsterisk = true;
                    lengthUnit.type = 1;
                    lengthUnit.value = 1.0f;
                    return lengthUnit;
                }
                length = valueStr.length();
                if (valueStr.endsWith("%")) {
                    try {
                        lengthUnit.value = Float.parseFloat(valueStr.substring(0, length - 1)) / 100.0f;
                        lengthUnit.type = 1;
                        return lengthUnit;
                    }
                    catch (Throwable th) {
                        if (!Logger.doesLog(2)) break block20;
                        Logger.warning(th);
                    }
                }
            }
            if (!Character.isDigit(c0 = (valueStr = valueStr.trim()).charAt(0)) && c0 != '.' && c0 != '+' && c0 != '-') {
                return null;
            }
            if (valueStr.length() >= 3 && !Character.isDigit(valueStr.charAt(valueStr.length() - 1))) {
                valueNum = valueStr.substring(0, length - 2);
                unit = valueStr.substring(length - 2, length).toLowerCase();
                if (valueNum.length() > 0 && valueNum.indexOf(44) >= 0) {
                    valueNum = valueNum.replace(',', '.');
                }
            } else {
                valueNum = valueStr;
                unit = "px";
            }
            Float scale = UNITS.get(unit);
            try {
                if (scale != null) {
                    lengthUnit.value = Float.parseFloat(valueNum) * scale.floatValue();
                    return lengthUnit;
                }
                if (unit.equals("em")) {
                    if (valueNum.endsWith("r")) {
                        lengthUnit.type = 4;
                        valueNum = valueNum.substring(0, valueNum.length() - 1);
                    } else {
                        lengthUnit.type = 2;
                    }
                    lengthUnit.value = Float.parseFloat(valueNum);
                    return lengthUnit;
                }
                if (unit.equals("ex")) {
                    lengthUnit.value = Float.parseFloat(valueNum) * 0.5f;
                    lengthUnit.type = 2;
                    return lengthUnit;
                }
            }
            catch (Throwable th) {
                if (!Logger.doesLog(2)) break block21;
                Logger.warning(th);
            }
        }
        try {
            int valuePX = Integer.parseInt(valueStr);
            lengthUnit.value = valuePX;
            lengthUnit.type = 0;
            return lengthUnit;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String strValue) {
        try {
            strValue = strValue.trim();
            LengthUnit lengthUnit = new LengthUnit();
            lengthUnit.setString(strValue);
            if ("*".equals(strValue)) {
                lengthUnit.isAsterisk = true;
                lengthUnit.type = 1;
                lengthUnit.value = 1.0f;
                return lengthUnit;
            }
            int length = strValue.length();
            try {
                if (strValue.endsWith("%")) {
                    lengthUnit.value = Float.parseFloat(strValue.substring(0, length - 1)) / 100.0f;
                    lengthUnit.type = 1;
                } else if (strValue.startsWith("%")) {
                    lengthUnit.value = Float.parseFloat(strValue.substring(1)) / 100.0f;
                    lengthUnit.type = 1;
                } else {
                    if (strValue.toLowerCase().endsWith("px")) {
                        strValue = strValue.substring(0, length - 2);
                    }
                    int intValue = Integer.parseInt(strValue);
                    lengthUnit.value = intValue;
                    lengthUnit.type = 0;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            return lengthUnit;
        }
        catch (Throwable th) {
            if (Logger.doesLog(1)) {
                Logger.error(th);
            }
            return null;
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean isAsterisk() {
        return this.isAsterisk;
    }

    public float calculateValue(float baseValue, View targetView) {
        switch (this.type) {
            case 0: {
                return this.value;
            }
            case 1: {
                return this.value * baseValue;
            }
            case 2: {
                float fontSize = targetView != null ? ((BoxView)targetView).getFontSize() : 16.0f;
                return this.value * fontSize;
            }
            case 3: {
                float fontSize = targetView != null ? ((BoxView)targetView).getFontSize() : 16.0f;
                return this.value * fontSize * 0.6f;
            }
            case 4: {
                float fontSize = targetView != null ? ((BoxView)targetView).getHTMLRoot().getFontSize() : 16.0f;
                return this.value * fontSize;
            }
        }
        return 0.0f;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LengthUnit) {
            LengthUnit other = (LengthUnit)obj;
            if (other.type != this.type) {
                return false;
            }
            if (other.value != this.value) {
                return false;
            }
            return other.isAsterisk == this.isAsterisk;
        }
        return false;
    }

    static {
        float systemDPI = 96.0f;
        try {
            systemDPI = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        logicalInch = 96.0f;
        try {
            String osType = System.getProperty("os.name");
            if (osType != null && osType.toLowerCase().contains("windows")) {
                logicalInch = systemDPI;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LengthUnit.setSystemDPI(logicalInch);
    }
}

