/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;

public class FontWeight
extends SingleAttributeValue {
    private boolean bold;

    FontWeight() {
    }

    public FontWeight(boolean isBold) {
        this.bold = isBold;
        if (isBold) {
            this.setString("bold");
        } else {
            this.setString("normal");
        }
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontWeight) {
            FontWeight other = (FontWeight)obj;
            if (other.isBold() != this.isBold()) {
                return false;
            }
            return other.isImportant() == this.isImportant();
        }
        return false;
    }

    @Override
    protected AttributeValue parseCssValue(String value, boolean important) {
        if ("inherit".equalsIgnoreCase(value)) {
            return AttributeValue.INHERIT;
        }
        FontWeight fontWeight = new FontWeight();
        fontWeight.setString(value);
        if (value.equalsIgnoreCase("bold")) {
            fontWeight.bold = true;
            fontWeight.setImportant(important);
            return fontWeight;
        }
        if (value.equalsIgnoreCase("bolder")) {
            fontWeight.bold = true;
            fontWeight.setImportant(important);
            return fontWeight;
        }
        if (value.equalsIgnoreCase("lighter")) {
            fontWeight.bold = false;
            fontWeight.setImportant(important);
            return fontWeight;
        }
        if (value.equalsIgnoreCase("normal")) {
            fontWeight.bold = false;
            fontWeight.setImportant(important);
            return fontWeight;
        }
        try {
            int weight = Integer.parseInt(value);
            if (weight >= 100 && weight <= 900 && weight % 100 == 0) {
                fontWeight.bold = weight >= 700;
                fontWeight.setImportant(important);
                return fontWeight;
            }
            return null;
        }
        catch (Throwable th) {
            return null;
        }
    }
}

