/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.SingleAttributeValue;
import java.util.Hashtable;
import java.util.Map;

public class DisplayValue
extends SingleAttributeValue {
    public static final byte NONE = 1;
    public static final byte INLINE = 2;
    public static final byte BLOCK = 3;
    public static final byte LIST_ITEM = 4;
    public static final byte RUN_IN = 5;
    public static final byte COMPACT = 6;
    public static final byte MARKER = 7;
    public static final byte TABLE = 8;
    public static final byte INLINE_TABLE = 9;
    public static final byte TABLE_ROW = 10;
    public static final byte TABLE_COLUMN = 11;
    public static final byte TABLE_CELL = 12;
    public static final byte TABLE_ROW_GROUP = 13;
    public static final byte TABLE_HEADER_GROUP = 14;
    public static final byte TABLE_FOOTER_GROUP = 15;
    public static final byte TABLE_COLUMN_GROUP = 16;
    public static final byte TABLE_CAPTION = 17;
    public static final byte INLINE_BLOCK = 18;
    private static final Hashtable<String, Byte> VALUE_MAP = new Hashtable(17, 1.0f);
    public static final DisplayValue INLINE_VALUE;
    private byte display;

    private DisplayValue() {
    }

    public DisplayValue(byte displayConstant) {
        this.display = displayConstant;
        for (Map.Entry<String, Byte> entry : VALUE_MAP.entrySet()) {
            if (entry.getValue() != displayConstant) continue;
            this.setString(entry.getKey());
            break;
        }
    }

    public byte getDisplay() {
        return this.display;
    }

    public boolean isBlockElement() {
        switch (this.display) {
            case 1: 
            case 2: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected AttributeValue parseCssValue(String value, boolean important) {
        if ("inherit".equals(value = value.toLowerCase())) {
            return AttributeValue.INHERIT;
        }
        Byte intValue = VALUE_MAP.get(value);
        if (intValue == null) {
            return null;
        }
        DisplayValue val = new DisplayValue();
        val.display = intValue;
        val.setString(value);
        val.setImportant(important);
        return val;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DisplayValue) {
            return ((DisplayValue)obj).getDisplay() == this.getDisplay();
        }
        return false;
    }

    static {
        VALUE_MAP.put("none", (byte)1);
        VALUE_MAP.put("inline", (byte)2);
        VALUE_MAP.put("block", (byte)3);
        VALUE_MAP.put("list-item", (byte)4);
        VALUE_MAP.put("run-in", (byte)5);
        VALUE_MAP.put("compact", (byte)6);
        VALUE_MAP.put("marker", (byte)7);
        VALUE_MAP.put("table", (byte)8);
        VALUE_MAP.put("inline-table", (byte)9);
        VALUE_MAP.put("table-row", (byte)10);
        VALUE_MAP.put("table-column", (byte)11);
        VALUE_MAP.put("table-cell", (byte)12);
        VALUE_MAP.put("table-row-group", (byte)13);
        VALUE_MAP.put("table-header-group", (byte)14);
        VALUE_MAP.put("table-footer-group", (byte)15);
        VALUE_MAP.put("table-column-group", (byte)16);
        VALUE_MAP.put("table-caption", (byte)17);
        VALUE_MAP.put("inline-block", (byte)18);
        INLINE_VALUE = new DisplayValue(2);
    }
}

