/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class DocType {
    private static final String HTML5 = "<!DOCTYPE html>";
    private static final String PREFIX = "<!DOCTYPE html PUBLIC \"-//W3C//DTD ";
    private static final String SUFFIX = "\">";
    private static final NumberFormat VERSION_FORMAT;
    private Type type;
    private float version;
    private Variant variant;

    public DocType() {
        this.type = Type.quirks;
        this.version = 3.2f;
        this.variant = Variant.Transitional;
    }

    public DocType(Type type, float version, Variant variant) {
        this.type = type;
        this.version = version;
        this.variant = variant;
    }

    public void parseDocType(String docType) {
        if (docType == null) {
            this.type = Type.quirks;
            this.version = 3.2f;
            this.variant = Variant.Transitional;
            return;
        }
        int idx1 = docType.indexOf("-//W3C//DTD ");
        if (idx1 > 0) {
            String str;
            int idx2 = docType.indexOf("//", idx1 += 12);
            if (idx2 > 0 && (idx1 = (str = docType.substring(idx1, idx2).trim()).indexOf(32)) > 0) {
                String docTypeStr = str.substring(0, idx1);
                if (docTypeStr.equals("HTML")) {
                    this.setType(Type.HTML);
                } else if (docTypeStr.equals("XHTML")) {
                    this.setType(Type.XHTML);
                } else {
                    this.setType(Type.quirks);
                    return;
                }
                str = str.substring(idx1).trim();
                idx1 = str.indexOf(32);
                if (idx1 < 0) {
                    idx1 = str.length();
                }
                try {
                    this.setVersion(Float.parseFloat(str.substring(0, idx1)));
                }
                catch (Throwable th) {
                    this.setType(Type.quirks);
                    return;
                }
                str = str.substring(idx1).trim();
                if (str.length() == 0) {
                    this.setVariant(this.version >= 2.0f && this.version < 4.0f ? Variant.Transitional : Variant.Strict);
                } else if (str.equalsIgnoreCase("Frameset")) {
                    this.setVariant(Variant.Frameset);
                } else if (str.equalsIgnoreCase("Strict")) {
                    this.setVariant(Variant.Strict);
                } else if (str.contains("Loose")) {
                    this.setVariant(Variant.Transitional);
                }
            }
        } else {
            if (docType.toLowerCase().contains("html")) {
                this.type = Type.HTML;
                this.version = 4.01f;
                this.variant = Variant.Transitional;
            }
            if (docType.toLowerCase().trim().equals("html")) {
                this.version = 5.0f;
            }
        }
    }

    public String getTypeString() {
        String dtd = null;
        switch (this.type) {
            case quirks: {
                return null;
            }
            case HTML: {
                if (this.version >= 5.0f) {
                    return HTML5;
                }
                if (this.version <= 2.0f) {
                    this.version = 2.0f;
                }
                if (!(this.version >= 4.0f) || !(this.version < 5.0f)) break;
                this.version = 4.01f;
                dtd = "http://www.w3.org/TR/html4/" + (this.variant != Variant.Transitional ? this.variant.name().toLowerCase() : "loose") + ".dtd";
                break;
            }
            case XHTML: {
                if (this.version <= 1.0f) {
                    this.version = 1.0f;
                    dtd = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-" + this.variant.name().toLowerCase() + ".dtd";
                }
                if (!(this.version > 1.0f)) break;
                this.version = 1.1f;
                dtd = "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd";
            }
        }
        StringBuilder typeBuilder = new StringBuilder(PREFIX);
        typeBuilder.append(this.type.name()).append(" ").append(VERSION_FORMAT.format(this.version));
        if (this.version >= 4.0f && this.type == Type.HTML || this.version == 1.0f && this.type == Type.XHTML) {
            typeBuilder.append(" ").append(this.variant.name());
        }
        typeBuilder.append("//EN");
        if (dtd != null) {
            typeBuilder.append("\" \"").append(dtd);
        }
        typeBuilder.append(SUFFIX);
        return typeBuilder.toString();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float version) {
        this.version = version;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public void setVariant(Variant variant) {
        this.variant = variant;
    }

    public boolean isHTML4OrHigher() {
        return this.type == Type.XHTML || this.type == Type.HTML && this.version >= 4.0f;
    }

    public boolean isLooseType() {
        switch (this.type) {
            case HTML: {
                return this.version < 5.0f && this.variant == Variant.Transitional;
            }
            case XHTML: {
                return false;
            }
            case quirks: {
                return true;
            }
        }
        return false;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        VERSION_FORMAT = new DecimalFormat("0.0#", symbols);
    }

    public static enum Type {
        quirks,
        HTML,
        XHTML;

    }

    public static enum Variant {
        Transitional,
        Strict,
        Frameset;

    }
}

