/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.edit.image;

import com.inet.html.css.CSS;
import com.inet.html.edit.EditDialog;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.views.ImageView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class PanelImageProps
implements EditDialog.EditPanel {
    private JSpinner spnWidth = new JSpinner();
    private JSpinner spnHeight = new JSpinner();
    private ImageView view;

    public PanelImageProps(ImageView view) {
        this.view = view;
        LengthUnit wu = view.getWidthUnit();
        int width = wu != null && !wu.isAuto() ? (int)wu.getValue() : view.getImage().getWidth(null);
        this.initSpinner(width, this.spnWidth);
        LengthUnit hu = view.getHeightUnit();
        int height = hu != null && !hu.isAuto() ? (int)hu.getValue() : view.getImage().getHeight(null);
        this.initSpinner(height, this.spnHeight);
    }

    public void initSpinner(int value, JSpinner spinner) {
        SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
        model.setMaximum(Integer.valueOf(16000));
        model.setMinimum(Integer.valueOf(1));
        model.setStepSize(Math.max(1, value / 50));
        model.setValue(value);
    }

    private JPanel getSpinnerPanel(JSpinner spinner) {
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(spinner);
        panel.add(new JComboBox<Object>(new Object[]{"px", "pt", "%"}));
        return panel;
    }

    @Override
    public AttributeSet getAttributes() {
        SimpleAttributeSet atts = new SimpleAttributeSet();
        atts.addAttribute((Object)CSS.Attribute.HEIGHT, new LengthUnit(((Number)this.spnHeight.getValue()).intValue()));
        atts.addAttribute((Object)CSS.Attribute.WIDTH, new LengthUnit(((Number)this.spnWidth.getValue()).intValue()));
        return atts;
    }

    @Override
    public JComponent getComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        BufferedImage preview = new BufferedImage(100, 100, 2);
        Image refImage = this.view.getImage();
        double scale = Math.min((double)refImage.getWidth(null) / (double)preview.getWidth(), (double)refImage.getHeight(null) / (double)preview.getHeight());
        int width = (int)Math.round((double)refImage.getWidth(null) * scale);
        int height = (int)Math.round((double)refImage.getHeight(null) * scale);
        preview.getGraphics().drawImage(refImage, (preview.getWidth() - width) / 2, (preview.getHeight() - height) / 2, width, height, null);
        JLabel lblImg = new JLabel(new ImageIcon(preview));
        panel.add((Component)this.getSpinnerPanel(this.spnWidth), "North");
        panel.add((Component)this.getSpinnerPanel(this.spnHeight), "West");
        panel.add((Component)lblImg, "Center");
        return panel;
    }

    @Override
    public String getTabName() {
        return "Image";
    }
}

