/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.edit.image;

import com.inet.editor.ColorButton;
import com.inet.editor.ColorList;
import com.inet.editor.ScrollPopup;
import com.inet.html.css.CSS;
import com.inet.html.edit.EditDialog;
import com.inet.html.parser.converter.BorderStyleValue;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.views.ImageView;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class PanelBoxModel
implements EditDialog.EditPanel {
    private ImageView image;
    private ColorButton btnColor;
    private JSpinner spnWidth;
    private JComboBox cmbStyle;
    private ScrollPopup colorMenu;
    private ColorList colorList;
    private Object[] items = new Object[]{"none", "inset", "groove", "outset", "ridge", "dotted", "dashed", "solid", "double", "hidden"};

    public PanelBoxModel(ImageView image) {
        this.image = image;
    }

    @Override
    public AttributeSet getAttributes() {
        SimpleAttributeSet atts = new SimpleAttributeSet();
        if (this.colorList.getColor() != null) {
            ColorValue color = new ColorValue(this.colorList.getColor());
            atts.addAttribute((Object)CSS.Attribute.BORDER_BOTTOM_COLOR, color);
            atts.addAttribute((Object)CSS.Attribute.BORDER_TOP_COLOR, color);
            atts.addAttribute((Object)CSS.Attribute.BORDER_LEFT_COLOR, color);
            atts.addAttribute((Object)CSS.Attribute.BORDER_RIGHT_COLOR, color);
        }
        BorderStyleValue style = new BorderStyleValue(this.items[this.cmbStyle.getSelectedIndex()].toString(), this.cmbStyle.getSelectedIndex());
        atts.addAttribute((Object)CSS.Attribute.BORDER_BOTTOM_STYLE, style);
        atts.addAttribute((Object)CSS.Attribute.BORDER_TOP_STYLE, style);
        atts.addAttribute((Object)CSS.Attribute.BORDER_LEFT_STYLE, style);
        atts.addAttribute((Object)CSS.Attribute.BORDER_RIGHT_STYLE, style);
        LengthUnit width = new LengthUnit((Integer)this.spnWidth.getValue());
        atts.addAttribute((Object)CSS.Attribute.BORDER_BOTTOM_WIDTH, width);
        atts.addAttribute((Object)CSS.Attribute.BORDER_TOP_WIDTH, width);
        atts.addAttribute((Object)CSS.Attribute.BORDER_LEFT_WIDTH, width);
        atts.addAttribute((Object)CSS.Attribute.BORDER_RIGHT_WIDTH, width);
        return atts;
    }

    @Override
    public JComponent getComponent() {
        JPanel pnlBorder = new JPanel();
        pnlBorder.setLayout(new BoxLayout(pnlBorder, 1));
        pnlBorder.add(new JLabel("Border"));
        this.btnColor = new ColorButton();
        this.colorMenu = new ScrollPopup();
        this.colorList = new ColorList();
        this.colorList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color selectedcolor = PanelBoxModel.this.colorList.getColor();
                PanelBoxModel.this.btnColor.setColor(selectedcolor);
            }
        });
        ColorValue borderColor = this.image.getBorderBottomColor();
        if (borderColor != null) {
            this.btnColor.setColor(borderColor.getValue());
            this.colorList.setColor(borderColor.getValue());
        }
        this.btnColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PanelBoxModel.this.colorMenu.removeAll();
                for (JMenuItem mi : PanelBoxModel.this.colorList.getMenuItems()) {
                    PanelBoxModel.this.colorMenu.add(mi);
                }
                PanelBoxModel.this.colorMenu.show(PanelBoxModel.this.btnColor, 0, PanelBoxModel.this.btnColor.getHeight() - 2);
                e.consume();
            }
        });
        pnlBorder.add(this.btnColor);
        this.spnWidth = new JSpinner();
        SpinnerNumberModel model = (SpinnerNumberModel)this.spnWidth.getModel();
        model.setMinimum(Integer.valueOf(0));
        model.setMaximum(Integer.valueOf(10));
        model.setStepSize(1);
        model.setValue(this.image.getBox().getBorderStyles().bottom);
        pnlBorder.add(this.spnWidth);
        this.cmbStyle = new JComboBox<Object>(this.items);
        this.cmbStyle.setSelectedIndex(this.image.getBox().getBorderInsets().bottom);
        pnlBorder.add(this.cmbStyle);
        return pnlBorder;
    }

    @Override
    public String getTabName() {
        return "Border";
    }
}

