/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions.search;

import com.inet.html.actions.InetHtmlAction;
import com.inet.html.actions.search.SearchControl;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;

public class SearchAction
extends InetHtmlAction {
    private final boolean init;
    private final boolean forward;

    public SearchAction(boolean init, boolean forward) {
        super("search-" + (init ? "init" : (forward ? "next" : "previous")));
        this.init = init;
        this.forward = forward;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final JEditorPane editor = this.getEditor(e);
        if (editor == null) {
            return;
        }
        Object controllerObj = editor.getClientProperty("searchController");
        if (controllerObj instanceof SearchControl) {
            final SearchControl controller = (SearchControl)controllerObj;
            if (this.init) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Point offset = editor.getLocationOnScreen();
                        Rectangle bounds = editor.getVisibleRect();
                        Point visOffset = bounds.getLocation();
                        bounds = new Rectangle(offset, bounds.getSize());
                        bounds.translate(visOffset.x, visOffset.y);
                        controller.requestSearch(false, bounds);
                    }
                });
            } else {
                controller.doSearch(this.forward, true);
            }
        }
    }
}

