/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions.search;

import com.inet.html.actions.search.ISearchHighlighter;
import com.inet.html.utils.Logger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class DefaultSearchHighlighter
implements ISearchHighlighter {
    private static final DefaultHighlighter.DefaultHighlightPainter PAINTER = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 255, 0, 127));
    private final JEditorPane editor;

    public DefaultSearchHighlighter(JEditorPane editor) {
        this.editor = editor;
    }

    @Override
    public int doHighlight(Pattern pattern, boolean forward, boolean updateSelection) {
        ArrayList<Dimension> positions = new ArrayList<Dimension>();
        try {
            String text = this.editor.getDocument().getText(0, this.editor.getDocument().getLength());
            Matcher m = pattern.matcher(text);
            while (m.find()) {
                int end;
                int start = m.start();
                if (start >= (end = m.end())) continue;
                boolean nwsFirst = !Character.isWhitespace(text.charAt(start));
                boolean nwsLast = !Character.isWhitespace(text.charAt(end - 1));
                positions.add(new Dimension(nwsFirst ? start : start + 1, nwsLast ? end : end - 1));
            }
        }
        catch (BadLocationException e) {
            Logger.error(e);
            return 0;
        }
        this.markHighlights(positions);
        if (positions.size() > 0 && updateSelection) {
            this.markCurrent(positions, forward);
        }
        return positions.size();
    }

    private void markHighlights(List<Dimension> positions) {
        this.clearHighlights();
        Highlighter highlighter = this.editor.getHighlighter();
        for (Dimension position : positions) {
            try {
                highlighter.addHighlight(position.width, position.height, PAINTER);
            }
            catch (BadLocationException e) {
                Logger.error(e);
            }
        }
    }

    private static Dimension findPosition(List<Dimension> positions, int start, boolean forward) {
        int count;
        if (positions.size() == 1) {
            return positions.get(0);
        }
        if (forward) {
            for (Dimension pos : positions) {
                if (pos.width < start) continue;
                return pos;
            }
            return positions.get(0);
        }
        for (int i = count = positions.size() - 1; i >= 0; --i) {
            Dimension pos = positions.get(i);
            if (pos.height > start) continue;
            return pos;
        }
        return positions.get(count);
    }

    private void markCurrent(List<Dimension> positions, boolean forward) {
        Caret caret = this.editor.getCaret();
        int position = forward ? Math.max(caret.getDot(), caret.getMark()) : Math.min(caret.getDot(), caret.getMark());
        this.editor.setCaretPosition(position);
        final Dimension newPos = DefaultSearchHighlighter.findPosition(positions, position, forward);
        FocusListener[] listeners = this.editor.getFocusListeners();
        FocusEvent ev = new FocusEvent(this.editor, 1004, true);
        for (FocusListener listener : listeners) {
            listener.focusGained(ev);
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception e) {
            Logger.error(e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSearchHighlighter.this.editor.select(newPos.width, newPos.height);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Caret caret = DefaultSearchHighlighter.this.editor.getCaret();
                        if (caret != null) {
                            caret.setSelectionVisible(true);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void clearHighlights() {
        Highlighter.Highlight[] highlights = this.editor.getHighlighter().getHighlights();
        if (highlights != null && highlights.length > 0) {
            for (Highlighter.Highlight hl : highlights) {
                if (hl.getPainter() != PAINTER) continue;
                this.editor.getHighlighter().removeHighlight(hl);
            }
        }
    }
}

