/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.actions;

import com.inet.html.InetHtmlDocument;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.css.CSS;
import com.inet.html.parser.converter.FontStyle;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class ItalicAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;

    public ItalicAction() {
        super("font-italic");
    }

    @Override
    public Object getValue(String key) {
        if (key == "ShortDescription") {
            return InetHtmlAction.getTranslation("italic");
        }
        return super.getValue(key);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JEditorPane editor = this.getHtmlEditor(e);
        if (editor != null && editor.getDocument() instanceof InetHtmlDocument) {
            Document doc = editor.getDocument();
            Caret c = editor.getCaret();
            if (c.getDot() - c.getMark() != 0) {
                Element paragraph;
                int pos = c.getMark();
                if (c.getDot() < c.getMark()) {
                    --pos;
                }
                if ((paragraph = ((InetHtmlDocument)doc).getParagraphElement(pos)).getEndOffset() - 1 == pos) {
                    --pos;
                }
                Element characterElement = ((InetHtmlDocument)doc).getCharacterElement(pos);
                boolean italic = CSS.isItalic(characterElement);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                CSS.setFontStyle(sas, !italic);
                int start = Math.min(c.getDot(), c.getMark());
                int end = Math.max(c.getDot(), c.getMark());
                ((InetHtmlDocument)doc).setCharacterAttributes(start, end - start, sas, false);
            }
            if (editor instanceof JTextPane) {
                MutableAttributeSet atts;
                Object value = (atts = ((JTextPane)editor).getInputAttributes()).getAttribute((Object)CSS.Attribute.FONT_STYLE);
                CSS.setFontStyle(atts, value == null || value instanceof FontStyle && !((FontStyle)value).isItalic());
                this.updateCaretListeners(editor);
            }
        }
    }
}

