/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html;

import com.inet.annotations.PublicApi;
import com.inet.html.InetHtmlConfiguration;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlFactory;
import com.inet.html.InetHtmlFontFactory;
import com.inet.html.InetHtmlTransferHandler;
import com.inet.html.InetHtmlWriter;
import com.inet.html.actions.AlignmentAction;
import com.inet.html.actions.BeginEndLineAction;
import com.inet.html.actions.BoldAction;
import com.inet.html.actions.DeleteNextCharAction;
import com.inet.html.actions.DeletePrevCharAction;
import com.inet.html.actions.EnterAction;
import com.inet.html.actions.HRuleAction;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.actions.ItalicAction;
import com.inet.html.actions.ListAction;
import com.inet.html.actions.ParagraphIndentAction;
import com.inet.html.actions.SoftBreakAction;
import com.inet.html.actions.TabKeyAction;
import com.inet.html.actions.UnderlineAction;
import com.inet.html.actions.search.SearchAction;
import com.inet.html.actions.search.SearchClearAction;
import com.inet.html.actions.search.SearchControl;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.css.TemporaryStyle;
import com.inet.html.edit.ElementEditor;
import com.inet.html.edit.LinkEditor;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.ColorValue;
import com.inet.html.parser.converter.FontFamily;
import com.inet.html.parser.converter.FontSize;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.ViewPositionInfo;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

@PublicApi
public class InetHtmlEditorKit
extends StyledEditorKit {
    private static final long serialVersionUID = 1L;
    public static final String PARAGRAPH_INDENT_LEFT = "paraIndentLeft";
    public static final String PARAGRAPH_INDENT_RIGHT = "paraIndentRight";
    public static final String TAB_KEY_ACTION = "tabKeyAction";
    public static final String TAB_KEY_SHIFT_ACTION = "tabKeyShiftAction";
    public static final String BULLET_LIST_ACTION = "bulletListAction";
    public static final String NUMBERED_LIST_ACTION = "numberedListAction";
    public static final String PASTE_PLAIN_ACTION = "paste-from-clipboard-plain";
    public static final String COPY_PLAIN_ACTION = "copy-to-clipboard-plain";
    public static final String SEARCH_INIT_ACTION = "search-init";
    public static final String SEARCH_NEXT_ACTION = "search-next";
    public static final String SEARCH_PREVIOUS_ACTION = "search-previous";
    public static final String SEARCH_CLEAR_ACTION = "search-clear";
    private static Action boldAction;
    private static Action italicAction;
    private static Action underlineAction;
    private static Action searchInit;
    private static Action searchNext;
    private static Action searchPrev;
    private static Action searchClear;
    private static Action[] DEFAULT_ACTIONS;
    private static RENDER_MODE renderingMode;
    public static final int SHORTCUT_KEY_MASK;
    private MutableAttributeSet inputAttributes;
    private InetHtmlAttributeTracker tracker;
    private MouseController linkController;
    private Cursor defaultCursor = new Cursor(0);
    private Cursor linkCursor = new Cursor(12);
    private InetHtmlConfiguration defaultConfig = InetHtmlConfiguration.getMailEditorConfig();
    private TransferHandler prevTransferHandler = null;
    private Object recentEditor = null;
    private InetHtmlFactory factory;
    private ScalingFontFactory fontFactory;
    private long parserTimeout;

    public InetHtmlEditorKit() {
        this.init();
    }

    public InetHtmlEditorKit(boolean useTextAntiAlias) {
        this.init();
        this.factory.setUseTextAntiAlias(useTextAntiAlias);
    }

    private static void presetGlobalActions() {
        boldAction = new BoldAction();
        italicAction = new ItalicAction();
        underlineAction = new UnderlineAction();
        searchInit = new SearchAction(true, true);
        searchNext = new SearchAction(false, true);
        searchPrev = new SearchAction(false, false);
        searchClear = new SearchClearAction();
    }

    private void init() {
        this.tracker = new InetHtmlAttributeTracker();
        this.createInputAttributes();
        this.fontFactory = new ScalingFontFactory();
        this.factory = new InetHtmlFactory(null, this.fontFactory);
    }

    public void setFontScale(float scale) {
        this.fontFactory.setScale(scale);
    }

    public void setParserTimeout(long timeout) {
        this.parserTimeout = timeout;
    }

    @Override
    public InetHtmlDocument createDefaultDocument() {
        InetHtmlDocument doc = new InetHtmlDocument();
        doc.setAsynchronousLoadPriority(4);
        try {
            if (this.recentEditor != null && this.recentEditor.getClass().getName().endsWith("JHEditorPane")) {
                doc.putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, this.getJavaHelpConfig());
            } else {
                doc.putProperty(InetHtmlDocument.PROPERTY_CONFIGURATION, this.defaultConfig.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            Logger.error(e);
        }
        return doc;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }

    public void setDefaultConfig(InetHtmlConfiguration defaultConfig) {
        if (defaultConfig == null) {
            return;
        }
        this.defaultConfig = defaultConfig;
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        InetHtmlDocument doc4 = (InetHtmlDocument)doc;
        try {
            if (this.parserTimeout <= 0L) {
                doc.putProperty(InetHtmlDocument.PROPERTY_TIMEOUT, null);
            } else {
                doc.putProperty(InetHtmlDocument.PROPERTY_TIMEOUT, this.parserTimeout);
            }
            doc4.parse(in, pos);
        }
        catch (BadLocationException e) {
            Logger.error(e);
            throw e;
        }
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        InetHtmlWriter w = new InetHtmlWriter(out, doc, pos, len);
        w.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Action[] getActions() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (DEFAULT_ACTIONS == null) {
                try {
                    DEFAULT_ACTIONS = new Action[]{new HRuleAction(), new SoftBreakAction(), new BeginEndLineAction("caret-end-line", false, false), new BeginEndLineAction("selection-end-line", false, true), new BeginEndLineAction("caret-begin-line", true, false), new BeginEndLineAction("selection-begin-line", true, true), new AlignmentAction("left-justify", 0), new AlignmentAction("right-justify", 2), new AlignmentAction("center-justify", 1), new AlignmentAction("justified-justify", 3), new DeletePrevCharAction(), new DeleteNextCharAction(), new EnterAction(new DefaultEditorKit.InsertBreakAction()), boldAction, italicAction, underlineAction, new ParagraphIndentAction(true, 40), new ParagraphIndentAction(false, 40), new ListAction(false), new ListAction(true), searchInit, searchNext, searchPrev, searchClear};
                }
                catch (NoClassDefFoundError th) {
                    DEFAULT_ACTIONS = new Action[0];
                }
            }
        }
        return TextAction.augmentList(super.getActions(), DEFAULT_ACTIONS);
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    private InetHtmlConfiguration getJavaHelpConfig() {
        return InetHtmlConfiguration.getBrowserConfig();
    }

    @Override
    public void install(JEditorPane c) {
        if (c == null) {
            return;
        }
        this.recentEditor = c;
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        this.createInputAttributes();
        c.addCaretListener(this.tracker);
        c.addPropertyChangeListener(this.tracker);
        Caret caret = c.getCaret();
        if (caret != null) {
            this.tracker.updateAttributes(caret.getDot(), caret.getMark(), c);
        }
        Keymap localMap = c.getKeymap();
        PastePlainAction pasteFromClipBoardPlainAction = new PastePlainAction();
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(86, 64 + SHORTCUT_KEY_MASK), pasteFromClipBoardPlainAction);
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(155, 64 + SHORTCUT_KEY_MASK), pasteFromClipBoardPlainAction);
        c.getActionMap().put(PASTE_PLAIN_ACTION, pasteFromClipBoardPlainAction);
        CopyPlainAction copyToClipBoardPlainAction = new CopyPlainAction();
        c.addCaretListener(copyToClipBoardPlainAction);
        c.getActionMap().put(COPY_PLAIN_ACTION, copyToClipBoardPlainAction);
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(67, 64 + SHORTCUT_KEY_MASK), copyToClipBoardPlainAction);
        try {
            this.addActionsToEditor(c);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            this.setTransferHandler(c);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.linkController = new MouseController();
        c.addMouseListener(this.linkController);
        c.addMouseMotionListener(this.linkController);
    }

    private void setTransferHandler(JEditorPane c) {
        this.prevTransferHandler = c.getTransferHandler();
        InetHtmlTransferHandler inetHtmlTransferHandler = new InetHtmlTransferHandler(c);
        c.addCaretListener(inetHtmlTransferHandler);
        c.setTransferHandler(inetHtmlTransferHandler);
        c.setDragEnabled(true);
    }

    private void addActionsToEditor(JEditorPane c) {
        Keymap localMap = c.getKeymap();
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(9, 0), new TabKeyAction());
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(70, 64 + SHORTCUT_KEY_MASK), boldAction);
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(75, 64 + SHORTCUT_KEY_MASK), italicAction);
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(85, 64 + SHORTCUT_KEY_MASK), underlineAction);
        c.putClientProperty("searchController", new SearchControl(c));
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(70, SHORTCUT_KEY_MASK), searchInit);
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(70, 64 + SHORTCUT_KEY_MASK), searchClear);
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(114, 0), searchNext);
        this.addActionForKeyStroke(localMap, KeyStroke.getKeyStroke(114, 64), searchPrev);
    }

    private void addActionForKeyStroke(Keymap map, KeyStroke key, Action a) {
        if (key != null && a != null) {
            map.addActionForKeyStroke(key, a);
        }
    }

    @Override
    public void deinstall(JEditorPane c) {
        this.recentEditor = null;
        Keymap map = c.getKeymap();
        if (map != null) {
            map.removeKeyStrokeBinding(KeyStroke.getKeyStroke(9, 0));
            map.removeKeyStrokeBinding(KeyStroke.getKeyStroke(9, 64));
            map.removeKeyStrokeBinding(KeyStroke.getKeyStroke(86, 64 + SHORTCUT_KEY_MASK));
            map.removeKeyStrokeBinding(KeyStroke.getKeyStroke(155, 64 + SHORTCUT_KEY_MASK));
            map.removeKeyStrokeBinding(KeyStroke.getKeyStroke(70, 64 + SHORTCUT_KEY_MASK));
            map.removeKeyStrokeBinding(KeyStroke.getKeyStroke(75, 64 + SHORTCUT_KEY_MASK));
            map.removeKeyStrokeBinding(KeyStroke.getKeyStroke(85, 64 + SHORTCUT_KEY_MASK));
        }
        for (MouseListener mouseListener : c.getMouseListeners()) {
            if (!(mouseListener instanceof MouseController)) continue;
            c.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : c.getMouseMotionListeners()) {
            if (!(eventListener instanceof MouseController)) continue;
            c.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : c.getCaretListeners()) {
            if (!(eventListener instanceof CopyPlainAction)) continue;
            c.removeCaretListener((CaretListener)eventListener);
        }
        c.removeCaretListener(this.tracker);
        c.removePropertyChangeListener(this.tracker);
        try {
            this.restoreTransferHandler(c);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        c.getActionMap().remove(PASTE_PLAIN_ACTION);
        c.getActionMap().remove(COPY_PLAIN_ACTION);
        this.inputAttributes = null;
        this.linkController = null;
        c.setToolTipText(null);
    }

    public List<Action> getCurrentCustomActions() {
        ArrayList<Action> list = new ArrayList<Action>();
        for (ElementEditor editor : this.linkController.handlerState.keySet()) {
            List<Action> actions = editor.getMenuEntries();
            if (actions == null) continue;
            list.addAll(actions);
        }
        return list;
    }

    private void restoreTransferHandler(JEditorPane c) {
        TransferHandler handler = c.getTransferHandler();
        if (handler instanceof InetHtmlTransferHandler) {
            c.removeCaretListener((InetHtmlTransferHandler)handler);
        }
        c.setTransferHandler(this.prevTransferHandler);
    }

    @Override
    protected void createInputAttributes(Element element, MutableAttributeSet set) {
        this.createInputAttributes(element, element, set);
    }

    protected void createInputAttributes(Element dotElement, Element markElement, MutableAttributeSet set) {
        if (dotElement == null || markElement == null) {
            return;
        }
        Element startElement = dotElement;
        Element endElement = markElement;
        if (dotElement.getStartOffset() > markElement.getStartOffset()) {
            startElement = markElement;
            endElement = dotElement;
        }
        int endOffset = endElement.getEndOffset();
        set.removeAttributes(set);
        boolean isBold = false;
        boolean isItalic = false;
        boolean isUnderline = false;
        boolean nullFontColor = false;
        ColorValue fontColor = null;
        boolean nullFontSize = false;
        float fontSize = -1.0f;
        boolean nullFontFamily = false;
        FontFamily fontFamily = null;
        if (startElement.getDocument() instanceof InetHtmlDocument) {
            InetHtmlDocument doc = (InetHtmlDocument)startElement.getDocument();
            Element slider = startElement;
            do {
                Object localFontSize;
                isBold |= CSS.isBold(slider);
                isItalic |= CSS.isItalic(slider);
                isUnderline |= CSS.isUnderline(slider);
                if (!nullFontColor) {
                    ColorValue localColor = StyleResolver.getAttributeValue(slider, AttributeFinder.COLOR);
                    if (fontColor == null) {
                        fontColor = localColor;
                    } else if (!fontColor.equals(localColor)) {
                        nullFontColor = true;
                        fontColor = null;
                    }
                }
                if (!nullFontFamily) {
                    FontFamily localFontFamily = StyleResolver.getAttributeValue(slider, AttributeFinder.FONT_FAMILY);
                    if (fontFamily == null) {
                        fontFamily = localFontFamily;
                    } else if (!fontFamily.equals(localFontFamily)) {
                        nullFontFamily = true;
                        fontFamily = null;
                    }
                }
                if (!nullFontSize && (localFontSize = slider.getAttributes().getAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE)) != null) {
                    float fsFloat = ((Float)localFontSize).floatValue();
                    if (fontSize < 0.0f) {
                        fontSize = fsFloat;
                    } else if (fontSize != fsFloat) {
                        nullFontSize = true;
                        fontSize = -1.0f;
                    }
                }
                if (slider == endElement || slider.getEndOffset() > endOffset) {
                    slider = null;
                    continue;
                }
                Element oldSliderPos = slider;
                slider = ElementUtils.getLeafAt(doc.getRootElements()[0], slider.getEndOffset());
                if (slider != oldSliderPos) continue;
                slider = ElementUtils.getLeafAt(doc.getRootElements()[0], slider.getEndOffset() + 1);
            } while (slider != null);
            CSS.setFontWeight(set, isBold);
            CSS.setFontStyle(set, isItalic);
            CSS.setTextDecoration(set, isUnderline ? 1 : 0);
            if (!nullFontColor && fontColor != null) {
                CSS.setTextColor(set, fontColor.getValue());
                set.addAttribute((Object)CSS.Attribute.COLOR, fontColor);
            }
            if (!nullFontFamily) {
                set.addAttribute((Object)CSS.Attribute.FONT_FAMILY, fontFamily);
            }
            if (!nullFontSize) {
                set.addAttribute((Object)CSS.Attribute.FONT_SIZE, new FontSize((int)LengthUnit.getPTforPX(fontSize)));
                set.addAttribute((Object)TemporaryStyle.Attribute.FONT_SIZE, Float.valueOf(fontSize));
            }
        }
    }

    @Override
    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    private void createInputAttributes() {
        this.inputAttributes = new NonCopyAttributeSet();
    }

    public void forceUpdateInputAttributes(JEditorPane editor) {
        if (editor == null) {
            return;
        }
        Document doc = editor.getDocument();
        if (!(doc instanceof InetHtmlDocument)) {
            return;
        }
        Element element = ((InetHtmlDocument)doc).getCharacterElement(Math.max(editor.getCaret().getMark() - 1, 0));
        this.createInputAttributes(element, this.getInputAttributes());
    }

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public void setDefaultCursor(Cursor defaultCursor) {
        this.defaultCursor = defaultCursor;
    }

    public Cursor getLinkCursor() {
        return this.linkCursor;
    }

    public void setLinkCursor(Cursor linkCursor) {
        this.linkCursor = linkCursor;
    }

    @Override
    public Object clone() {
        return new InetHtmlEditorKit();
    }

    public static void setRenderingMode(RENDER_MODE mode) {
        renderingMode = mode != null ? mode : RENDER_MODE.java_custom;
    }

    public static RENDER_MODE getRenderingMode() {
        return renderingMode;
    }

    private static void setPastePlainMode(TransferHandler handler) {
        if (handler instanceof InetHtmlTransferHandler) {
            InetHtmlTransferHandler inetHandler = (InetHtmlTransferHandler)handler;
            inetHandler.setModePlain();
        }
    }

    static {
        block6: {
            renderingMode = RENDER_MODE.java_custom;
            try {
                InetHtmlEditorKit.presetGlobalActions();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                String handler = System.getProperty("java.protocol.handler.pkgs", "");
                if (handler.indexOf("com.inet.protocol") < 0) {
                    if (handler.length() > 0) {
                        handler = handler + "|";
                    }
                    handler = handler + "com.inet.protocol";
                    System.getProperties().put("java.protocol.handler.pkgs", handler);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof SecurityException)) break block6;
                Logger.error("The application does not have the permission to register the 'data' protocol, date URL are therefore disabled");
            }
        }
        SHORTCUT_KEY_MASK = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 2;
    }

    @PublicApi
    public static enum RENDER_MODE {
        java_custom,
        os_native,
        os_native_rounded;

    }

    private class InetHtmlAttributeTracker
    implements CaretListener,
    PropertyChangeListener {
        private Element dotLeaf;
        private Element markLeaf;

        private InetHtmlAttributeTracker() {
        }

        private void updateAttributes(int dot, int mark, JTextComponent c) {
            Element markParagraph;
            Element currentParagraph;
            Document doc = c.getDocument();
            if (!(doc instanceof InetHtmlDocument)) {
                return;
            }
            if (dot != mark) {
                if (dot > mark) {
                    ++mark;
                } else {
                    ++dot;
                }
            }
            InetHtmlDocument htmlDoc = (InetHtmlDocument)doc;
            Element newMarkLeaf = null;
            Element newDotLeaf = ElementUtils.getLeafAt(currentParagraph, dot == (currentParagraph = htmlDoc.getParagraphElement(dot)).getStartOffset() ? dot : Math.max(dot - 1, 0));
            newMarkLeaf = dot != mark ? ElementUtils.getLeafAt(markParagraph, dot == (markParagraph = htmlDoc.getParagraphElement(mark)).getStartOffset() ? mark : Math.max(mark - 1, 0)) : newDotLeaf;
            if (newDotLeaf != this.dotLeaf || newMarkLeaf != this.markLeaf) {
                this.dotLeaf = newDotLeaf;
                this.markLeaf = newMarkLeaf;
                InetHtmlEditorKit.this.createInputAttributes(this.dotLeaf, this.markLeaf, InetHtmlEditorKit.this.getInputAttributes());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            Object source = evt.getSource();
            if (source instanceof JTextComponent && newValue instanceof InetHtmlDocument) {
                this.updateAttributes(0, 0, (JTextComponent)source);
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.updateAttributes(e.getDot(), e.getMark(), (JTextComponent)e.getSource());
        }
    }

    private static class ScalingFontFactory
    implements InetHtmlFontFactory {
        private float scale = 1.0f;

        private ScalingFontFactory() {
        }

        @Override
        public Font getFont(String name, int style, int size, String text) {
            return this.getFont(name, style, (float)size, text);
        }

        @Override
        public Font getFont(String name, int style, float size, String text) {
            float scaleSize = size * this.getScale();
            if (renderingMode == RENDER_MODE.os_native_rounded) {
                return new Font(name, style, Math.round(scaleSize));
            }
            Font font = new Font(name, style, (int)scaleSize);
            if (scaleSize != (float)((int)scaleSize)) {
                font = font.deriveFont(scaleSize);
            }
            return font;
        }

        public void setScale(float scale) {
            if ((double)scale < 0.1) {
                scale = 0.1f;
            }
            if (scale > 10.0f) {
                scale = 10.0f;
            }
            this.scale = scale;
        }

        @Override
        public boolean requiresText() {
            return false;
        }

        protected float getScale() {
            return this.scale;
        }
    }

    private static class PastePlainAction
    extends AbstractAction {
        private static final long serialVersionUID = -6328692980720768453L;

        private PastePlainAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == null) {
                return;
            }
            while (source instanceof Container && !(source instanceof JTextComponent)) {
                if (source instanceof JPopupMenu) {
                    source = ((JPopupMenu)source).getInvoker();
                    continue;
                }
                source = ((Container)source).getParent();
            }
            if (source instanceof JTextComponent) {
                JTextComponent text = (JTextComponent)source;
                try {
                    InetHtmlEditorKit.setPastePlainMode(text.getTransferHandler());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                text.dispatchEvent(new KeyEvent(text, 401, System.currentTimeMillis(), SHORTCUT_KEY_MASK, 86, 'v'));
            }
        }
    }

    private static class CopyPlainAction
    extends InetHtmlAction
    implements CaretListener {
        private boolean actionEnabled;

        public CopyPlainAction() {
            super("copy plain");
        }

        @Override
        public boolean isEnabled() {
            return this.actionEnabled;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor == null) {
                return;
            }
            try {
                InetHtmlEditorKit.setPastePlainMode(editor.getTransferHandler());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            editor.dispatchEvent(new KeyEvent(editor, 401, System.currentTimeMillis(), SHORTCUT_KEY_MASK, 67, 'c'));
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.actionEnabled = e.getMark() != e.getDot();
        }
    }

    public static class MouseController
    extends MouseAdapter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Point start;
        private static final int LINK_TOLERANCE = 10;
        private Map<HTML.Tag, ElementEditor> handlerMap = new HashMap<HTML.Tag, ElementEditor>();
        private Map<ElementEditor, State> handlerState = new HashMap<ElementEditor, State>();
        private long startTime;
        private View lastRoot = null;

        public MouseController() {
            this.addHandler(new LinkEditor());
        }

        public void addHandler(ElementEditor handler) {
            if (this.handlerMap.containsValue(handler)) {
                return;
            }
            for (HTML.Tag tag : handler.getHandledTags()) {
                this.handlerMap.put(tag, handler);
            }
            this.handlerState.put(handler, State.inactive);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!(editor.getEditorKit() instanceof InetHtmlEditorKit) || !(editor.getDocument() instanceof InetHtmlDocument)) {
                return;
            }
            Point pt = new Point(e.getX(), e.getY());
            View rootView = editor.getUI().getRootView(editor).getView(0);
            if (editor.getDocument() instanceof InetHtmlDocument && rootView instanceof HtmlRootView) {
                ElementEditor handler;
                Insets margin;
                if (rootView != this.lastRoot) {
                    this.lastRoot = rootView;
                    for (ElementEditor ed : this.handlerState.keySet()) {
                        ((HtmlRootView)rootView).addOverlayPainter(ed.getPainter());
                    }
                }
                BoxView boxView = (BoxView)rootView;
                Rectangle location = boxView.getSpan();
                Border border = editor.getBorder();
                if (border != null && (margin = border.getBorderInsets(editor)) != null) {
                    pt.x -= margin.left;
                    pt.y -= margin.top;
                }
                ViewPositionInfo info = ((BoxView)rootView).getViewForPosition(pt, new Rectangle(0, 0, boxView.getOuterWidth(), boxView.getOuterHeight()));
                Element elem = boxView.getElement();
                if (info != null) {
                    boxView = info.getView();
                    location = new Rectangle(info);
                    elem = boxView.getElement();
                }
                int checked = 0;
                for (ElementEditor elementEditor : this.handlerState.keySet()) {
                    elementEditor.setEditor(editor);
                    switch (this.handlerState.get(elementEditor)) {
                        case active: {
                            this.handlerState.put(elementEditor, State.check_wasActive);
                            break;
                        }
                    }
                }
                while (elem != null) {
                    State state;
                    AttributeSet attributes = elem.getAttributes();
                    Object object = attributes.getAttribute(StyleConstants.NameAttribute);
                    handler = this.handlerMap.get(object);
                    if (handler != null && (state = this.handlerState.get(handler)) != State.active && handler.setSelectedView(boxView, location, elem)) {
                        this.handlerState.put(handler, State.active);
                        if (++checked == this.handlerState.size()) break;
                    }
                    elem = elem.getParentElement();
                }
                for (Map.Entry entry : this.handlerState.entrySet()) {
                    handler = (ElementEditor)entry.getKey();
                    switch ((State)((Object)entry.getValue())) {
                        case check_wasActive: {
                            if (handler.setSelectedView(null, null, null)) {
                                this.handlerState.put(handler, State.inactive);
                                break;
                            }
                            this.handlerState.put(handler, State.active);
                        }
                        case active: {
                            handler.getMouseHandler().mouseMoved(e);
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            for (Map.Entry<ElementEditor, State> entry : this.handlerState.entrySet()) {
                if (entry.getValue() != State.active) continue;
                entry.getKey().getMouseHandler().mousePressed(e);
            }
            this.start = e.getPoint();
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            for (Map.Entry<ElementEditor, State> entry : this.handlerState.entrySet()) {
                if (entry.getValue() != State.active) continue;
                entry.getKey().getMouseHandler().mouseDragged(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.start != null && System.currentTimeMillis() - this.startTime < 500L) {
                Point end = e.getPoint();
                int xDist = end.x - this.start.x;
                int yDist = end.y - this.start.y;
                int distance = (int)Math.sqrt(xDist * xDist + yDist * yDist);
                if (distance < 10 && e.getButton() == 1) {
                    for (Map.Entry<ElementEditor, State> entry : this.handlerState.entrySet()) {
                        if (entry.getValue() != State.active) continue;
                        entry.getKey().getMouseHandler().mouseClicked(e);
                    }
                }
            }
            for (Map.Entry<ElementEditor, State> entry : this.handlerState.entrySet()) {
                if (entry.getValue() != State.active) continue;
                MouseAdapter handler = entry.getKey().getMouseHandler();
                handler.mouseReleased(e);
            }
            this.start = null;
        }
    }

    private static class NonCopyAttributeSet
    extends SimpleAttributeSet {
        private NonCopyAttributeSet() {
        }

        @Override
        public AttributeSet copyAttributes() {
            return this;
        }
    }

    public static class ExtendedHyperlinkEvent
    extends HyperlinkEvent {
        private static final long serialVersionUID = 1737694883377397946L;
        public static final String TARGET_TOP = "_top";
        public static final String TARGET_BLANK = "_blank";
        public static final String TARGET_NEW_TAB = "_newtab";
        private String target = "_top";

        public ExtendedHyperlinkEvent(Object source, HyperlinkEvent.EventType type, URL u, String desc, Element sourceElement) {
            super(source, type, u, desc, sourceElement);
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getTarget() {
            return this.target;
        }
    }

    private static enum State {
        active,
        check_wasActive,
        inactive;

    }
}

