/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.html.utils.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.SuppressFBWarnings;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SpellCheckerProxy {
    private static final State state = new State();

    public static boolean isSpellCheckerAvailable() {
        return state.spellCheckerClass != null;
    }

    static void notifyDictionaryLoaded() {
        if (state.initListener == null) {
            return;
        }
        state.initListener = null;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean active = SpellCheckerProxy.isDictionaryLoaded();
                ArrayList arrayList = state.pendingActivations;
                synchronized (arrayList) {
                    for (WeakReference ref : state.pendingActivations) {
                        ActivationCallback comp = (ActivationCallback)ref.get();
                        if (comp == null) continue;
                        comp.setActive(active);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activate(ActivationCallback callback) {
        if (SpellCheckerProxy.isSpellCheckerAvailable()) {
            ArrayList arrayList = state.pendingActivations;
            synchronized (arrayList) {
                if (SpellCheckerProxy.getCurrentLocale() != null) {
                    callback.setActive(true);
                } else {
                    state.pendingActivations.add(new WeakReference<ActivationCallback>(callback));
                    callback.setActive(false);
                }
            }
        } else {
            callback.setActive(false);
        }
    }

    public static void enableAutoSpell(JTextComponent text, boolean autoCheck) {
        SpellCheckerProxy.state.call("enableAutoSpell", new Object[]{text, autoCheck});
    }

    public static Locale getCurrentLocale() {
        Object name = SpellCheckerProxy.state.call("getCurrentLocale", new Object[0]);
        if (name instanceof Locale) {
            return (Locale)name;
        }
        return null;
    }

    public static String getApplicationName() {
        Object name = SpellCheckerProxy.state.call("getApplicationName", new Object[0]);
        if (name instanceof String) {
            return (String)name;
        }
        return null;
    }

    public static JMenu createCheckerMenu() {
        Object menu = SpellCheckerProxy.state.call("createCheckerMenu", new Object[0]);
        if (menu instanceof JMenu) {
            return (JMenu)menu;
        }
        return null;
    }

    public static boolean isDictionaryLoaded() {
        Object menu = SpellCheckerProxy.state.call("isDictionaryLoaded", new Object[0]);
        if (menu instanceof Boolean) {
            return (Boolean)menu;
        }
        return false;
    }

    public static JMenu createLanguagesMenu() {
        Object menu = SpellCheckerProxy.state.call("createLanguagesMenu", new Object[0]);
        if (menu instanceof JMenu) {
            return (JMenu)menu;
        }
        return null;
    }

    public static void enableShortKey(JTextComponent editor, boolean enable) {
        SpellCheckerProxy.state.call("enableShortKey", new Object[]{editor, enable});
    }

    public static void registerDictionaries(URL baseURL, String availableLocales, String activeLocale) {
        SpellCheckerProxy.state.call("registerDictionaries", new Object[]{baseURL, availableLocales, activeLocale});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Thread t = new Thread(new Loader(state));
        t.setName("SpellChecker loader");
        t.start();
        try {
            State state = SpellCheckerProxy.state;
            synchronized (state) {
                SpellCheckerProxy.state.wait(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class State {
        private Class<?> spellCheckerClass;
        private Object initListener = null;
        private ArrayList<WeakReference<ActivationCallback>> pendingActivations = new ArrayList();

        private State() {
        }

        private Object call(String name, Object ... params) {
            block11: {
                if (this.spellCheckerClass != null) {
                    Object result = null;
                    try {
                        if (params != null && params.length > 0) {
                            Class[] types = new Class[params.length];
                            for (int i = 0; i < params.length; ++i) {
                                types[i] = params[i].getClass();
                                if (types[i] == Boolean.class) {
                                    types[i] = Boolean.TYPE;
                                }
                                if (!(params[i] instanceof JTextComponent)) continue;
                                types[i] = JTextComponent.class;
                            }
                            Method method = this.spellCheckerClass.getMethod(name, types);
                            result = method.invoke(null, params);
                        } else {
                            Method method = this.spellCheckerClass.getMethod(name, new Class[0]);
                            result = method.invoke(null, new Object[0]);
                        }
                        return result;
                    }
                    catch (NoSuchMethodException e) {
                        if (params == null || params.length <= 0) break block11;
                        try {
                            Method[] methods;
                            for (Method m : methods = this.spellCheckerClass.getMethods()) {
                                if (!m.getName().equals(name)) continue;
                                result = m.invoke(null, params);
                                return result;
                            }
                        }
                        catch (Exception ex) {
                            Logger.error(ex);
                        }
                    }
                    catch (Exception e) {
                        Logger.error(e);
                    }
                }
            }
            return null;
        }
    }

    public static interface ActivationCallback {
        public void setActive(boolean var1);
    }

    private static class Loader
    implements Runnable {
        private State loaderState;

        public Loader(State state) {
            this.loaderState = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The location is fixed and points to a ressoure in the current classpath.")
        public void run() {
            block7: {
                URL test = null;
                try {
                    this.loaderState.spellCheckerClass = Class.forName("com.inet.jortho.SpellChecker");
                    try {
                        test = new URL("file:dictionary_en.ortho");
                        InputStream stream = test.openStream();
                        stream.close();
                    }
                    catch (IOException e) {
                        URL base = this.loaderState.spellCheckerClass.getProtectionDomain().getCodeSource().getLocation();
                        test = new URL(base, "dictionary_en.ortho");
                        InputStream stream = test.openStream();
                        stream.close();
                    }
                    Class<?> listener = Class.forName("com.inet.editor.DictionaryListener");
                    this.loaderState.initListener = listener.newInstance();
                    this.loaderState.call("addLanguageChangeLister", new Object[]{this.loaderState.initListener});
                    this.loaderState.call("registerDictionaries", new Object[]{test, "en", "en"});
                }
                catch (Exception e) {
                    if (!Logger.doesLog(3)) break block7;
                    Logger.info("Optional JOrtho spell checker not found, spell checking is disabled.");
                    if (test == null) break block7;
                    Logger.info("Dictionairy reference is: " + test);
                }
            }
            State state = this.loaderState;
            synchronized (state) {
                this.loaderState.notifyAll();
            }
        }
    }
}

