/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.SyntaxDocument;
import com.inet.html.InetHtmlEditorKit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class LineNumTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private int areaWidth = 35;
    private Color areaColor = new Color(225, 225, 225);
    private boolean lineNumbersVisible = true;

    public LineNumTextPane() {
        this.init();
        this.setTabs(4);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public void setSize(Dimension d) {
        d.width = Math.max(d.width, this.getParent().getWidth());
        super.setSize(d);
    }

    public void setTabs(int charactersPerTab) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int charWidth = fm.charWidth(' ');
        int tabWidth = charWidth * charactersPerTab;
        TabStop[] tabs = new TabStop[10];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        int length = this.getDocument().getLength();
        this.getStyledDocument().setParagraphAttributes(0, length, attributes, false);
    }

    private void init() {
        KeyStroke ksLines = KeyStroke.getKeyStroke(76, InetHtmlEditorKit.SHORTCUT_KEY_MASK);
        AbstractAction actionShowLines = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LineNumTextPane.this.setLineNumbersVisible(!LineNumTextPane.this.isLineNumbersVisible());
            }
        };
        this.getInputMap().put(ksLines, "lines");
        this.getActionMap().put("lines", actionShowLines);
    }

    @Override
    public void scrollRectToVisible(Rectangle rect) {
        if (this.isLineNumbersVisible()) {
            try {
                Rectangle r0 = this.modelToView(0);
                if (rect.x <= r0.x) {
                    rect.x = 0;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        super.scrollRectToVisible(rect);
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit(){
            private static final long serialVersionUID = 1L;

            @Override
            public Document createDefaultDocument() {
                SyntaxDocument syntaxDocument = new SyntaxDocument();
                return syntaxDocument;
            }

            @Override
            public ViewFactory getViewFactory() {
                return new LnViewFactory();
            }
        };
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            int width = this.getFontMetrics(font).stringWidth("99999");
            this.areaWidth = Math.max(35, width);
        }
        super.setFont(font);
    }

    public boolean isLineNumbersVisible() {
        return this.lineNumbersVisible;
    }

    public void setLineNumbersVisible(boolean b) {
        if (!this.isEditable()) {
            return;
        }
        boolean old = this.lineNumbersVisible;
        this.lineNumbersVisible = b;
        if (this.lineNumbersVisible != old) {
            this.repaint();
        }
    }

    public Color getNumberAreaColor() {
        return this.areaColor;
    }

    public void setNumberAreaColor(Color numberAreaColor) {
        if (numberAreaColor != null) {
            this.areaColor = numberAreaColor;
        }
    }

    class LnParagraphView
    extends ParagraphView {
        public LnParagraphView(Element e) {
            super(e);
        }

        @Override
        protected short getLeftInset() {
            return LineNumTextPane.this.isLineNumbersVisible() ? (short)(super.getLeftInset() + LineNumTextPane.this.areaWidth) : super.getLeftInset();
        }

        @Override
        public void paint(Graphics g, Shape a) {
            super.paint(g, a);
            for (int i = 0; i < this.getViewCount(); ++i) {
                Shape s = this.getChildAllocation(i, a);
                this.paintChild(g, s.getBounds(), i);
            }
        }

        @Override
        public void paintChild(Graphics g, Rectangle r, int n) {
            super.paintChild(g, r, n);
            int line = this.getPreviousLineCount() + 1;
            if (LineNumTextPane.this.isLineNumbersVisible()) {
                g.setFont(g.getFont().deriveFont(0));
                if (n == 0) {
                    g.setColor(Color.black);
                    String s = String.valueOf(line);
                    int w = g.getFontMetrics().stringWidth(s);
                    int numberX = LineNumTextPane.this.areaWidth - 5 - w;
                    int numberY = r.y + r.height - 3;
                    g.drawString(s, numberX, numberY);
                } else if (this.getViewCount() - 1 == n) {
                    g.setColor(Color.gray);
                    int w = g.getFontMetrics().stringWidth("0");
                    g.drawLine(LineNumTextPane.this.areaWidth - 6 - w / 2, r.y, LineNumTextPane.this.areaWidth - 6 - w / 2, r.y + r.height / 2);
                    g.drawLine(LineNumTextPane.this.areaWidth - 6 - w / 2, r.y + r.height / 2, LineNumTextPane.this.areaWidth - 2 - w / 2, r.y + r.height / 2);
                } else {
                    g.setColor(Color.gray);
                    int w = g.getFontMetrics().stringWidth("0");
                    g.drawLine(LineNumTextPane.this.areaWidth - 6 - w / 2, r.y, LineNumTextPane.this.areaWidth - 6 - w / 2, r.y + r.height);
                }
            }
        }

        public int getPreviousLineCount() {
            View parent = this.getParent();
            int count = parent.getViewCount();
            int i = 0;
            for (i = 0; i < count; ++i) {
                if (parent.getView(i) != this) continue;
                return i;
            }
            return count;
        }
    }

    class LnViewFactory
    implements ViewFactory {
        LnViewFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new LabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new LnParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1){

                        @Override
                        public void paint(Graphics g, Shape allocation) {
                            if (LineNumTextPane.this.isLineNumbersVisible()) {
                                g.setColor(LineNumTextPane.this.areaColor);
                                g.fillRect(0, 0, LineNumTextPane.this.areaWidth, this.getContainer().getHeight() - 1);
                            }
                            super.paint(g, allocation);
                        }
                    };
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }
}

