/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.HyperlinkInputDialog;
import com.inet.html.InetHtmlDocument;
import com.inet.html.InetHtmlEditorKit;
import com.inet.html.actions.InetHtmlAction;
import com.inet.html.css.ClassIDGenerator;
import com.inet.html.css.HTML;
import com.inet.html.parser.converter.ClassValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.ElementUtils;
import com.inet.html.utils.Logger;
import com.inet.html.utils.URLUtils;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class HyperlinkAction
extends InetHtmlAction {
    private static final long serialVersionUID = 1L;
    private static final String REMOVE_LINK = "remove";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("\\S{1,}@\\S{1,}\\.\\S{1,}");

    public HyperlinkAction() {
        super("hyperlink");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, InetHtmlEditorKit.SHORTCUT_KEY_MASK + 1));
    }

    @Override
    public Object getValue(String key) {
        if (key == "ShortDescription") {
            return HtmlEditorUtils.getTranslation("hyperlink");
        }
        return super.getValue(key);
    }

    private Element findAnchorElement(InetHtmlDocument doc, int offset) {
        Element e;
        for (e = ElementUtils.getLeafAt(doc.getDefaultRootElement(), offset); e != null && e.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.A; e = e.getParentElement()) {
        }
        return e;
    }

    private String getLink(Element anchor) {
        Object href = anchor.getAttributes().getAttribute((Object)HTML.Attribute.HREF);
        if (href != null) {
            return href.toString();
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        boolean dataOK;
        boolean markerHasA;
        boolean remove;
        boolean replace;
        String addresse;
        String name;
        String origName;
        Element link;
        int p1;
        int p0;
        Object defaultClass;
        InetHtmlDocument doc;
        JEditorPane text;
        block36: {
            text = this.getHtmlEditor(ev);
            if (text == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
            if (!(text.getDocument() instanceof InetHtmlDocument)) {
                return;
            }
            doc = (InetHtmlDocument)text.getDocument();
            defaultClass = doc.getProperty(InetHtmlDocument.PROPERTY_DEFAULT_STYLE_CLASS);
            Caret caret = text.getCaret();
            p0 = Math.min(caret.getDot(), caret.getMark());
            p1 = Math.max(caret.getDot(), caret.getMark());
            link = this.findAnchorElement(doc, p1 > p0 ? p1 - 1 : p0);
            origName = "";
            name = "";
            addresse = link != null ? this.getLink(link) : null;
            replace = false;
            remove = false;
            markerHasA = false;
            dataOK = true;
            if (this.isInSameBlock(p0, p1, doc)) {
                try {
                    if (p1 - p0 == 0 && link != null) {
                        Element tmpLink;
                        p0 = link.getStartOffset();
                        p1 = link.getEndOffset();
                        while (p0 > 0 && (tmpLink = this.findAnchorElement(doc, p0 - 1)) != null && addresse.equals(this.getLink(tmpLink))) {
                            p0 = tmpLink.getStartOffset();
                        }
                        while (p1 < doc.getLength() - 1 && (tmpLink = this.findAnchorElement(doc, p1 + 1)) != null && addresse.equals(this.getLink(tmpLink))) {
                            p1 = tmpLink.getEndOffset();
                        }
                    }
                    if ((origName = (name = doc.getText(p0, p1 - p0))).endsWith("\n")) {
                        name = origName = origName.substring(0, origName.length() - 1);
                        --p1;
                        markerHasA = true;
                    }
                    break block36;
                }
                catch (BadLocationException e) {
                    if (Logger.doesLog(1)) {
                        Logger.error(e);
                    }
                    break block36;
                }
            }
            replace = true;
        }
        do {
            Container parent;
            block37: {
                if (addresse == null) {
                    if (name != null && name.length() > 0) {
                        try {
                            URL url = new URL(name.trim());
                            url.toURI();
                            addresse = url.toString();
                        }
                        catch (Exception e) {
                            String potentialAddress = name.trim();
                            if (potentialAddress.length() > 0 && EMAIL_PATTERN.matcher(potentialAddress).matches()) {
                                addresse = "mailto:" + potentialAddress;
                                break block37;
                            }
                            addresse = "http://";
                        }
                    } else {
                        addresse = "http://";
                    }
                }
            }
            String[] result = this.requestAdresseAndName(text, addresse, name);
            name = result[1];
            addresse = result[0];
            dataOK = true;
            if (name == null) {
                return;
            }
            if (name == REMOVE_LINK) {
                remove = true;
                dataOK = true;
                break;
            }
            for (parent = text; parent != null && !(parent instanceof JScrollPane) && parent.getParent() != null; parent = parent.getParent()) {
            }
            if (parent != null && parent.getParent() != null) {
                parent = parent.getParent();
            }
            if (!(replace && link != null || name.trim().length() != 0)) {
                JOptionPane.showMessageDialog(parent, HtmlEditorUtils.getTranslation("HyperlinkInputDialog.error.emptyName"), HtmlEditorUtils.getTranslation("HyperlinkInputDialog.error.emptyName.title"), 0);
                dataOK = false;
            } else if (addresse == null || addresse.length() == 0 || addresse.equals("http://")) {
                JOptionPane.showMessageDialog(parent, HtmlEditorUtils.getTranslation("HyperlinkInputDialog.error.emptyAdress"), HtmlEditorUtils.getTranslation("HyperlinkInputDialog.error.emptyAdress.title"), 0);
                dataOK = false;
            }
            addresse = URLUtils.safeEncode(addresse);
        } while (!dataOK);
        try {
            SimpleAttributeSet anchor = new SimpleAttributeSet();
            anchor.addAttribute(StyleConstants.NameAttribute, (Object)HTML.Tag.A);
            if (markerHasA) {
                doc.removeElement(anchor, p1, p1 + 1, true);
            }
            if (remove) {
                doc.removeElement(anchor, p0, p1, true);
            } else {
                Object parentClassObj;
                Element parent;
                anchor.addAttribute((Object)HTML.Attribute.HREF, new UrlValue(addresse, doc.getBase()));
                ClassValue classValue = new ClassValue();
                if (defaultClass != null) {
                    classValue.addClass(defaultClass);
                }
                if ((parent = ElementUtils.findSharedParagraph(p0, p1 - p0, doc.getDefaultRootElement())) != null && (parentClassObj = parent.getAttributes().getAttribute((Object)HTML.Attribute.CLASS)) instanceof ClassValue) {
                    ArrayList<Object> classNames = ((ClassValue)parentClassObj).getClassNames();
                    for (Object className : classNames) {
                        String classNameString = className.toString();
                        if (!ClassIDGenerator.WEBENGINE_PREFIX_PATTERN.matcher(classNameString).matches()) continue;
                        classValue.addClass(classNameString);
                    }
                }
                if (classValue.getClassNames() != null && classValue.getClassNames().size() > 0) {
                    anchor.addAttribute((Object)HTML.Attribute.CLASS, classValue);
                }
                if (replace || !origName.equals(name)) {
                    doc.replace(p0, p1 - p0, name, anchor);
                } else {
                    doc.setCharacterAttributes(p0, p1 - p0, anchor, false, true);
                }
            }
        }
        catch (Exception ex) {
            if (Logger.doesLog(1)) {
                Logger.error(ex);
            }
            UIManager.getLookAndFeel().provideErrorFeedback(null);
        }
    }

    private boolean isInSameBlock(int pos1, int pos2, InetHtmlDocument doc) {
        Element pRight;
        Element pLeft = doc.getParagraphElement(pos1);
        if (pLeft != (pRight = doc.getParagraphElement(pos2))) {
            return false;
        }
        return doc.getUpperContentBoundary(pos1, pLeft) > doc.getLowerContentBoundary(pos2, pLeft);
    }

    private String[] requestAdresseAndName(JEditorPane text, String addresse, String name) {
        String[] result = new String[2];
        HyperlinkInputDialog hyperlinkInputDialog = new HyperlinkInputDialog(addresse, name);
        int choice = hyperlinkInputDialog.showDialog(text);
        if (choice == 1) {
            result[0] = hyperlinkInputDialog.getUrl();
            result[1] = hyperlinkInputDialog.getDisplaytext();
        }
        if (choice == 2) {
            result[0] = REMOVE_LINK;
            result[1] = REMOVE_LINK;
        }
        return result;
    }
}

